/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.quickfix.IQuickFixGenerator;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDLibrary;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.action.AddAttributeMarkerResolution;
import org.jboss.tools.jst.web.ui.action.AddTLDMarkerResolution;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator2,
IQuickFixGenerator {
    private static final String HTML_VALIDATOR_MARKER = "org.eclipse.wst.html.core.validationMarker";
    private static final String JSP_VALIDATOR_MARKER = "org.eclipse.jst.jsp.core.validationMarker";
    private static final String UNKNOWN_TAG = "Unknown tag";
    private static final String MISSING_ATTRIBUTE = "Missing required attribute";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            return this.findResolutions(marker);
        }
        catch (CoreException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
            return new IMarkerResolution[0];
        }
    }

    public static boolean validatePrefix(IFile file, int start, String prefix) {
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (context instanceof XmlContextImpl) {
            Map nameSpaces = ((XmlContextImpl)context).getNameSpaces(start);
            for (List list : nameSpaces.values()) {
                for (INameSpace ns : list) {
                    if (!prefix.equals(ns.getPrefix())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean validateURI(IFile file, int start, String uri) {
        return true;
    }

    private void getAddAttribute(ArrayList<IJavaCompletionProposal> proposals, TemporaryAnnotation ta, String message, int start, int end) {
        String attributeName = JSPProblemMarkerResolutionGenerator.getAttributeName(message);
        IFile file = MarkerResolutionUtils.getFile();
        if (file == null) {
            return;
        }
        Object additionalInfo = ta.getAdditionalFixInfo();
        if (additionalInfo instanceof IDocument) {
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)additionalInfo);
            IDOMDocument xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            Node n = Utils.findNodeForOffset((IDOMNode)xmlDocument, (int)start);
            if (n == null || !(n instanceof Attr)) {
                return;
            }
            Element node = ((Attr)n).getOwnerElement();
            node.getPrefix();
            node.getNodeName();
            proposals.add(new AddAttributeMarkerResolution(file, node, attributeName, start, end));
        }
    }

    private void getAddTLD(ArrayList<IJavaCompletionProposal> proposals, TemporaryAnnotation ta, String message, int start, int end) {
        String prefix = JSPProblemMarkerResolutionGenerator.getPrifix(message);
        if (prefix == null) {
            return;
        }
        String tagName = JSPProblemMarkerResolutionGenerator.getTagName(message);
        if (tagName == null) {
            return;
        }
        IFile file = MarkerResolutionUtils.getFile();
        if (file == null) {
            return;
        }
        if (!JSPProblemMarkerResolutionGenerator.validatePrefix(file, start, prefix)) {
            return;
        }
        Object additionalInfo = ta.getAdditionalFixInfo();
        if (additionalInfo instanceof IDocument) {
            String uri;
            String resolutionName;
            INameSpace ns;
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)additionalInfo);
            IDOMDocument xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            IKbProject kbProject = KbProjectFactory.getKbProject((IProject)file.getProject(), (boolean)true);
            if (kbProject == null) {
                return;
            }
            List libraries = kbProject.getAllTagLibraries();
            ArrayList<String> names = new ArrayList<String>();
            for (ITagLibrary l : libraries) {
                if (l instanceof TLDLibrary) {
                    ((TLDLibrary)l).createDefaultNameSpace();
                }
                if ((ns = l.getDefaultNameSpace()) == null || ns.getPrefix() == null || !ns.getPrefix().equals(prefix) || (resolutionName = this.getResolutionName(xmlDocument != null && xmlDocument.isXMLType(), true, prefix, uri = ns.getURI())) == null || names.contains(resolutionName) || l.getComponent(tagName) == null || !JSPProblemMarkerResolutionGenerator.validateURI(file, start, uri)) continue;
                proposals.add((IJavaCompletionProposal)new AddTLDMarkerResolution(file, resolutionName, start, end, uri, prefix));
                names.add(resolutionName);
            }
            for (ITagLibrary l : libraries) {
                ns = l.getDefaultNameSpace();
                if (ns != null && ns.getPrefix() != null && ns.getPrefix().equals(prefix) || (resolutionName = this.getResolutionName(xmlDocument != null && xmlDocument.isXMLType(), true, prefix, uri = l.getURI())) == null || names.contains(resolutionName) || l.getComponent(tagName) == null || !JSPProblemMarkerResolutionGenerator.validateURI(file, start, uri)) continue;
                proposals.add((IJavaCompletionProposal)new AddTLDMarkerResolution(file, resolutionName, start, end, uri, prefix));
                names.add(resolutionName);
            }
        }
    }

    private IJavaCompletionProposal[] findProposals(Annotation annotation, Position position) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        if (!(annotation instanceof TemporaryAnnotation)) {
            return new IJavaCompletionProposal[0];
        }
        TemporaryAnnotation ta = (TemporaryAnnotation)annotation;
        String message = annotation.getText();
        if (ta.getPosition() == null) {
            return new IJavaCompletionProposal[0];
        }
        int start = position.getOffset();
        int end = position.getOffset() + position.getLength();
        if (message.startsWith(UNKNOWN_TAG)) {
            this.getAddTLD(proposals, ta, message, start, end);
        } else if (message.startsWith(MISSING_ATTRIBUTE)) {
            this.getAddAttribute(proposals, ta, message, start, end);
        }
        return proposals.toArray(new IJavaCompletionProposal[0]);
    }

    private String getResolutionName(boolean xml, boolean noXML, String prefix, String uri) {
        if (xml) {
            return "xmlns: " + prefix + " = \"" + uri + "\"";
        }
        if (noXML) {
            return "<%@ taglib uri = \"" + uri + "\" prefix=\"" + prefix + "\" %>";
        }
        return null;
    }

    private void getAddAttribute(ArrayList<IMarkerResolution> resolutions, IMarker marker, String message, int start, int end) throws CoreException {
        String attributeName = JSPProblemMarkerResolutionGenerator.getAttributeName(message);
        IFile file = (IFile)marker.getResource();
        FileEditorInput input = new FileEditorInput(file);
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)input);
        provider.getDocument((Object)input);
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(file);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return;
            }
            Node node = Utils.findNodeForOffset((Node)xmlDocument, (int)start);
            if (node == null) {
                return;
            }
            try {
                node.getNodeName();
                resolutions.add((IMarkerResolution)new AddAttributeMarkerResolution(file, node, attributeName, start, end));
            }
            catch (IOException ex) {
                WebUiPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
        finally {
            smw.dispose();
        }
    }

    private void getAddTLD(ArrayList<IMarkerResolution> resolutions, IMarker marker, String message, int start, int end) throws CoreException {
        String resolutionName;
        String uri;
        INameSpace ns;
        String prefix = JSPProblemMarkerResolutionGenerator.getPrifix(message);
        if (prefix == null) {
            return;
        }
        String tagName = JSPProblemMarkerResolutionGenerator.getTagName(message);
        if (tagName == null) {
            return;
        }
        IFile file = (IFile)marker.getResource();
        if (!JSPProblemMarkerResolutionGenerator.validatePrefix(file, start, prefix)) {
            return;
        }
        IKbProject kbProject = KbProjectFactory.getKbProject((IProject)file.getProject(), (boolean)true);
        if (kbProject == null) {
            return;
        }
        List libraries = kbProject.getAllTagLibraries();
        ArrayList<String> names = new ArrayList<String>();
        for (ITagLibrary l : libraries) {
            if (l instanceof TLDLibrary) {
                ((TLDLibrary)l).createDefaultNameSpace();
            }
            if ((ns = l.getDefaultNameSpace()) == null || ns.getPrefix() == null || !ns.getPrefix().equals(prefix)) continue;
            uri = ns.getURI();
            resolutionName = this.getResolutionName(marker.getType().equals(HTML_VALIDATOR_MARKER) || marker.isSubtypeOf(HTML_VALIDATOR_MARKER), marker.getType().equals(JSP_VALIDATOR_MARKER) || marker.isSubtypeOf(JSP_VALIDATOR_MARKER), prefix, uri);
            if (resolutionName == null || names.contains(resolutionName) || l.getComponent(tagName) == null || !JSPProblemMarkerResolutionGenerator.validateURI(file, start, uri)) continue;
            resolutions.add((IMarkerResolution)new AddTLDMarkerResolution(file, resolutionName, start, end, uri, prefix));
            names.add(resolutionName);
        }
        for (ITagLibrary l : libraries) {
            ns = l.getDefaultNameSpace();
            if (ns != null && ns.getPrefix() != null && ns.getPrefix().equals(prefix)) continue;
            uri = l.getURI();
            resolutionName = this.getResolutionName(marker.getType().equals(HTML_VALIDATOR_MARKER) || marker.isSubtypeOf(HTML_VALIDATOR_MARKER), marker.getType().equals(JSP_VALIDATOR_MARKER) || marker.isSubtypeOf(JSP_VALIDATOR_MARKER), prefix, uri);
            if (resolutionName == null || names.contains(resolutionName) || l.getComponent(tagName) == null || !JSPProblemMarkerResolutionGenerator.validateURI(file, start, uri)) continue;
            resolutions.add((IMarkerResolution)new AddTLDMarkerResolution(file, resolutionName, start, end, uri, prefix));
            names.add(resolutionName);
        }
    }

    private IMarkerResolution[] findResolutions(IMarker marker) throws CoreException {
        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
        String message = (String)marker.getAttribute("message");
        Integer attribute = (Integer)marker.getAttribute("charStart");
        if (attribute == null) {
            return new IMarkerResolution[0];
        }
        int start = attribute;
        attribute = (Integer)marker.getAttribute("charEnd");
        if (attribute == null) {
            return new IMarkerResolution[0];
        }
        int end = attribute;
        if (message.startsWith(UNKNOWN_TAG)) {
            this.getAddTLD(resolutions, marker, message, start, end);
        } else if (message.startsWith(MISSING_ATTRIBUTE)) {
            this.getAddAttribute(resolutions, marker, message, start, end);
        }
        return resolutions.toArray(new IMarkerResolution[0]);
    }

    public static String getPrifix(String message) {
        String prefix = "";
        int start = message.indexOf("(");
        if (start < 0) {
            return null;
        }
        int end = message.indexOf(":", start);
        if (end < 0) {
            return null;
        }
        prefix = message.substring(start + 1, end);
        return prefix;
    }

    public static String getTagName(String message) {
        String tagName = "";
        int start = message.indexOf(":");
        if (start < 0) {
            return null;
        }
        int end = message.indexOf(")", start);
        if (end < 0) {
            return null;
        }
        tagName = message.substring(start + 1, end);
        return tagName;
    }

    public static String getAttributeName(String message) {
        String attributeName = "";
        int start = message.indexOf("\"");
        if (start < 0) {
            return null;
        }
        int end = message.lastIndexOf("\"");
        if (end < 0) {
            return null;
        }
        attributeName = message.substring(start + 1, end);
        return attributeName;
    }

    public boolean hasResolutions(IMarker marker) {
        if (marker.exists()) {
            String message = marker.getAttribute("message", "");
            return message.startsWith(UNKNOWN_TAG) || message.startsWith(MISSING_ATTRIBUTE);
        }
        return false;
    }

    public boolean hasProposals(Annotation annotation, Position position) {
        String message = annotation.getText();
        return message.startsWith(UNKNOWN_TAG) || message.startsWith(MISSING_ATTRIBUTE);
    }

    public IJavaCompletionProposal[] getProposals(Annotation annotation, Position position) {
        return this.findProposals(annotation, position);
    }
}

