/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.browser;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.IBrowserSimBrowserFactory;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.browser.internal.WebKitBrowser_gtk_linux_x86;
import org.jboss.tools.vpe.browsersim.browser.internal.WebKitBrowser_gtk_linux_x86_64;
import org.jboss.tools.vpe.browsersim.browser.internal.WebKitBrowser_webkit_cocoa_macos;
import org.jboss.tools.vpe.browsersim.browser.internal.WebKitBrowser_win32_win32_x86;
import org.jboss.tools.vpe.browsersim.browser.javafx.JavaFXBrowser;

public class WebKitBrowserFactory
implements IBrowserSimBrowserFactory {
    @Override
    public IBrowser createBrowser(Composite parent, int style, boolean isJavaFx) {
        if (isJavaFx) {
            return new JavaFXBrowser(parent);
        }
        if (PlatformUtil.CURRENT_PLATFORM.equals("gtk.linux.x86")) {
            return new WebKitBrowser_gtk_linux_x86(parent, style);
        }
        if (PlatformUtil.CURRENT_PLATFORM.equals("gtk.linux.x86_64")) {
            return new WebKitBrowser_gtk_linux_x86_64(parent, style);
        }
        if (PlatformUtil.CURRENT_PLATFORM.startsWith("cocoa.macosx")) {
            return new WebKitBrowser_webkit_cocoa_macos(parent, style);
        }
        if (PlatformUtil.CURRENT_PLATFORM.equals("win32.win32.x86")) {
            return new WebKitBrowser_win32_win32_x86(parent, style);
        }
        throw new SWTError("Unsupported Platform");
    }
}

