/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.packaging.ClassFilter;
import org.hibernate.ejb.packaging.Entry;
import org.hibernate.ejb.packaging.FileFilter;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.PackageFilter;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.xml.sax.EntityResolver;

public class OpenMappingUtilsEjb3 {
    public static final String META_INF_PERS_XML = "META-INF/persistence.xml";
    public static final String META_INF_ORM_XML = "META-INF/orm.xml";
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));

    private OpenMappingUtilsEjb3() {
    }

    public static List<String> enumDocuments(String persistenceUnitName, EntityResolver entityResolver) {
        Enumeration<URL> xmls = null;
        try {
            xmls = Thread.currentThread().getContextClassLoader().getResources(META_INF_PERS_XML);
        }
        catch (IOException iOException) {}
        if (xmls == null || !xmls.hasMoreElements()) {
            return null;
        }
        String IMPLEMENTATION_NAME = HibernatePersistence.class.getName();
        ArrayList<String> res = null;
        while (xmls.hasMoreElements() && res == null) {
            URL url = xmls.nextElement();
            List metadataFiles = null;
            try {
                metadataFiles = PersistenceXmlLoader.deploy((URL)url, (Map)EMPTY_MAP, (EntityResolver)entityResolver, (PersistenceUnitTransactionType)PersistenceUnitTransactionType.RESOURCE_LOCAL);
            }
            catch (Exception exception) {}
            if (metadataFiles == null) continue;
            boolean stopErrorFlag = false;
            for (PersistenceMetadata metadata : metadataFiles) {
                boolean tmp = metadata.getProvider() == null;
                boolean bl = tmp = tmp || IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProvider());
                if (!tmp) continue;
                JarVisitor visitor = null;
                URL visitorJarURL = null;
                if (metadata.getName() == null) {
                    visitor = OpenMappingUtilsEjb3.getMainJarVisitor(url, metadata, EMPTY_MAP);
                    visitorJarURL = JarVisitorFactory.getJarURLFromURLEntry((URL)url, (String)"/META-INF/persistence.xml");
                    metadata.setName(visitor.getUnqualifiedJarName());
                }
                if (persistenceUnitName == null && xmls.hasMoreElements()) {
                    stopErrorFlag = true;
                    break;
                }
                if (persistenceUnitName != null && !metadata.getName().equals(persistenceUnitName)) continue;
                if (visitor == null) {
                    visitor = OpenMappingUtilsEjb3.getMainJarVisitor(url, metadata, EMPTY_MAP);
                    visitorJarURL = JarVisitorFactory.getJarURLFromURLEntry((URL)url, (String)"/META-INF/persistence.xml");
                }
                try {
                    OpenMappingUtilsEjb3.addMetadataFromVisitor(visitor, visitorJarURL.getPath(), metadata);
                }
                catch (IOException iOException) {}
                res = new ArrayList<String>();
                for (NamedInputStream nis : metadata.getHbmfiles()) {
                    res.add(nis.getName());
                    try {
                        nis.getStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (stopErrorFlag) break;
        }
        return res;
    }

    private static JarVisitor getMainJarVisitor(URL url, PersistenceMetadata metadata, Map integration) {
        URL jarURL = JarVisitorFactory.getJarURLFromURLEntry((URL)url, (String)"/META-INF/persistence.xml");
        Filter[] persistenceXmlFilter = OpenMappingUtilsEjb3.getFilters(metadata, integration, metadata.getExcludeUnlistedClasses());
        JarVisitor visitor = JarVisitorFactory.getVisitor((URL)jarURL, (Filter[])persistenceXmlFilter);
        return visitor;
    }

    private static void addMetadataFromVisitor(JarVisitor visitor, String addPath, PersistenceMetadata metadata) throws IOException {
        Set[] entries = visitor.getMatchingEntries();
        Filter[] filters = visitor.getFilters();
        int size = filters.length;
        List classes = metadata.getClasses();
        List packages = metadata.getPackages();
        List hbmFiles = metadata.getHbmfiles();
        List mappingFiles = metadata.getMappingFiles();
        int index = 0;
        while (index < size) {
            for (Object o : entries[index]) {
                Entry entry = (Entry)o;
                if (filters[index] instanceof ClassFilter) {
                    classes.add(entry.getName());
                    continue;
                }
                if (filters[index] instanceof PackageFilter) {
                    packages.add(entry.getName());
                    continue;
                }
                if (!(filters[index] instanceof FileFilter)) continue;
                hbmFiles.add(new NamedInputStream(String.valueOf(addPath) + "/" + entry.getName(), entry.getInputStream()));
                if (mappingFiles == null) continue;
                mappingFiles.remove(entry.getName());
            }
            ++index;
        }
    }

    private static boolean[] getDetectedArtifacts(Properties properties, Map overridenProperties, boolean excludeIfNotOverriden) {
        boolean[] result = new boolean[2];
        String detect = overridenProperties != null ? (String)overridenProperties.get("hibernate.archive.autodetection") : null;
        String string = detect = detect == null ? properties.getProperty("hibernate.archive.autodetection") : detect;
        if (detect == null && excludeIfNotOverriden) {
            return result;
        }
        if (detect == null) {
            detect = "class,hbm";
        }
        StringTokenizer st = new StringTokenizer(detect, ", ", false);
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            if ("class".equalsIgnoreCase(element)) {
                result[0] = true;
            }
            if (!"hbm".equalsIgnoreCase(element)) continue;
            result[1] = true;
        }
        return result;
    }

    private static Filter[] getFilters(PersistenceMetadata metadata, Map overridenProperties, boolean excludeIfNotOverriden) {
        Properties properties = metadata.getProps();
        List mappingFiles = metadata.getMappingFiles();
        boolean[] detectedArtifacts = OpenMappingUtilsEjb3.getDetectedArtifacts(properties, overridenProperties, excludeIfNotOverriden);
        return OpenMappingUtilsEjb3.getFilters(detectedArtifacts, true, mappingFiles);
    }

    private static Filter[] getFilters(final boolean[] detectedArtifacts, final boolean searchORM, final List<String> mappingFiles) {
        final int mappingFilesSize = mappingFiles != null ? mappingFiles.size() : 0;
        int size = (detectedArtifacts[0] ? 2 : 0) + (searchORM || detectedArtifacts[1] || mappingFilesSize > 0 ? 1 : 0);
        Filter[] filters = new Filter[size];
        if (detectedArtifacts[0]) {
            filters[0] = new PackageFilter(false, null){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
            filters[1] = new ClassFilter(false, new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class}){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
        }
        if (detectedArtifacts[1] || searchORM || mappingFilesSize > 0) {
            filters[size - 1] = new FileFilter(true){

                public boolean accept(String javaElementName) {
                    return detectedArtifacts[1] && javaElementName.endsWith("hbm.xml") || searchORM && javaElementName.endsWith(OpenMappingUtilsEjb3.META_INF_ORM_XML) || mappingFilesSize > 0 && mappingFiles.contains(javaElementName);
                }
            };
        }
        return filters;
    }
}

