/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.Hbm2DDLExporter;
import org.hibernate.tool.hbm2x.HibernateConfigurationExporter;
import org.hibernate.tool.hbm2x.QueryExporter;
import org.jboss.tools.hibernate.proxy.ArtifactCollectorProxy;
import org.jboss.tools.hibernate.proxy.ConfigurationProxy;
import org.jboss.tools.hibernate.proxy.GenericExporterProxy;
import org.jboss.tools.hibernate.proxy.Hbm2DDLExporterProxy;
import org.jboss.tools.hibernate.proxy.QueryExporterProxy;
import org.jboss.tools.hibernate.spi.HibernateException;
import org.jboss.tools.hibernate.spi.IArtifactCollector;
import org.jboss.tools.hibernate.spi.IConfiguration;
import org.jboss.tools.hibernate.spi.IExporter;
import org.jboss.tools.hibernate.spi.IGenericExporter;
import org.jboss.tools.hibernate.spi.IHbm2DDLExporter;
import org.jboss.tools.hibernate.spi.IQueryExporter;

public class ExporterProxy
implements IExporter {
    private Exporter target;

    public ExporterProxy(String exporterClassName) {
        this.target = this.createTarget(exporterClassName);
    }

    public void setConfiguration(IConfiguration configuration) {
        if (configuration instanceof ConfigurationProxy) {
            this.target.setConfiguration(((ConfigurationProxy)configuration).getConfiguration());
        }
    }

    private Exporter createTarget(String exporterClassName) {
        Exporter result = null;
        try {
            result = (Exporter)this.getClass().getClassLoader().loadClass(exporterClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new HibernateException((Throwable)e);
        }
        return result;
    }

    public void setProperties(Properties properties) {
        this.target.setProperties(properties);
    }

    public void setArtifactCollector(IArtifactCollector collector) {
        if (collector instanceof ArtifactCollectorProxy) {
            this.target.setArtifactCollector(((ArtifactCollectorProxy)collector).getTarget());
        }
    }

    public void setOutputDirectory(File file) {
        this.target.setOutputDirectory(file);
    }

    public void setTemplatePath(String[] strings) {
        this.target.setTemplatePath(strings);
    }

    public void start() throws HibernateException {
        try {
            this.target.start();
        }
        catch (org.hibernate.HibernateException e) {
            throw new HibernateException(e.getMessage(), e.getCause());
        }
    }

    public Properties getProperties() {
        return this.target.getProperties();
    }

    public IGenericExporter getGenericExporter() {
        GenericExporterProxy result = null;
        if (this.target instanceof GenericExporter) {
            result = new GenericExporterProxy((GenericExporter)this.target);
        }
        return result;
    }

    public IHbm2DDLExporter getHbm2DDLExporter() {
        Hbm2DDLExporterProxy result = null;
        if (this.target instanceof Hbm2DDLExporter) {
            result = new Hbm2DDLExporterProxy((Hbm2DDLExporter)this.target);
        }
        return result;
    }

    public IQueryExporter getQueryExporter() {
        QueryExporterProxy result = null;
        if (this.target instanceof QueryExporter) {
            result = new QueryExporterProxy((QueryExporter)this.target);
        }
        return result;
    }

    public void setCustomProperties(Properties props) {
        assert (this.target instanceof HibernateConfigurationExporter);
        ((HibernateConfigurationExporter)this.target).setCustomProperties(props);
    }

    public void setOutput(StringWriter stringWriter) {
        assert (this.target instanceof HibernateConfigurationExporter);
        ((HibernateConfigurationExporter)this.target).setOutput((Writer)stringWriter);
    }
}

