/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.spi.ITable;

public class DatabaseCollectorProxy
implements IDatabaseCollector {
    private DefaultDatabaseCollector target = null;
    private HashMap<String, List<ITable>> qualifierEntries = null;

    public DatabaseCollectorProxy(DefaultDatabaseCollector dbc) {
        this.target = dbc;
    }

    DefaultDatabaseCollector getTarget() {
        return this.target;
    }

    public Iterator<Map.Entry<String, List<ITable>>> getQualifierEntries() {
        if (this.qualifierEntries == null) {
            this.initializeQualifierEntries();
        }
        return this.qualifierEntries.entrySet().iterator();
    }

    private void initializeQualifierEntries() {
        this.qualifierEntries = new HashMap();
        Iterator origin = this.target.getQualifierEntries();
        while (origin.hasNext()) {
            Map.Entry entry = (Map.Entry)origin.next();
            ArrayList<TableProxy> list = new ArrayList<TableProxy>();
            for (Table table : (List)entry.getValue()) {
                list.add(new TableProxy(table));
            }
            this.qualifierEntries.put((String)entry.getKey(), list);
        }
    }
}

