/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.forge.core.io.ForgeAnsiCommandFilter;
import org.jboss.tools.forge.core.io.ForgeCommandFilter;
import org.jboss.tools.forge.core.io.ForgeCommandProcessor;
import org.jboss.tools.forge.core.io.ForgeOutputListener;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandProcessorImpl;

public class ForgeDocument
extends Document {
    private ForgeRuntime runtime;
    private int cursorOffset = 0;
    private StyleRange currentStyleRange;
    private ForgeOutputListener outputListener;
    private Map<String, Color> colors;
    private List<StyleRange> styleRanges = new ArrayList<StyleRange>();
    private Set<CursorListener> cursorListeners = new HashSet<CursorListener>();

    public ForgeDocument() {
        this.initColors();
    }

    public void finalize() throws Throwable {
        this.disposeColors();
        super.finalize();
    }

    public void connect(ForgeRuntime runtime) {
        this.disconnect();
        this.runtime = runtime;
        ForgeOutputListener target = new ForgeOutputListener(){

            public void outputAvailable(String output) {
                ForgeDocument.this.handleAvailableOutput(output);
            }
        };
        ForgeAnsiCommandFilter facf = new ForgeAnsiCommandFilter(target){

            public void ansiCommandAvailable(String command) {
                ForgeDocument.this.executeAnsiCommand(command);
            }
        };
        this.outputListener = new SyncForgeCommandFilter((ForgeOutputListener)facf);
        runtime.addOutputListener(this.outputListener);
    }

    private void disconnect() {
        if (this.runtime != null) {
            this.runtime.removeOutputListener(this.outputListener);
            this.runtime = null;
        }
        this.reset();
    }

    private void executeAnsiCommand(String command) {
        char c = command.charAt(command.length() - 1);
        switch (c) {
            case 'G': {
                this.moveCursorAbsoluteInLine(command);
                break;
            }
            case 'K': {
                this.clearCurrentLine(command);
                break;
            }
            case 'm': {
                this.changeColor(command);
                break;
            }
            case 'H': {
                this.setCursorPosition(command);
                break;
            }
            case 'J': {
                this.clearCurrentScreenPage(command);
                break;
            }
            default: {
                ForgeUIPlugin.log(new RuntimeException("Unhandled Ansi control sequence in ForgeTextViewer: " + command));
            }
        }
    }

    private void handleAvailableOutput(String output) {
        try {
            String filteredOutput = output.replaceAll("\r", "");
            if (this.currentStyleRange != null) {
                this.currentStyleRange.length += filteredOutput.length();
            }
            this.replace(this.cursorOffset, this.getLength() - this.cursorOffset, filteredOutput);
            this.moveCursorTo(this.cursorOffset + filteredOutput.length());
        }
        catch (BadLocationException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void moveCursorAbsoluteInLine(String command) {
        try {
            int column = Integer.valueOf(command.substring(2, command.length() - 1));
            int lineStart = this.getLineOffset(this.getLineOfOffset(this.cursorOffset));
            this.moveCursorTo(lineStart + column - 1);
        }
        catch (BadLocationException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void clearCurrentLine(String command) {
        try {
            this.replace(this.cursorOffset, this.getLength() - this.cursorOffset, "");
        }
        catch (BadLocationException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void changeColor(String command) {
        String str = command.substring(2, command.length() - 1);
        Color newColor = this.colors.get(str);
        if (newColor != null) {
            this.currentStyleRange = new StyleRange(this.getLength(), 0, newColor, null);
            this.styleRanges.add(this.currentStyleRange);
        } else {
            this.currentStyleRange = null;
        }
    }

    private void setCursorPosition(String command) {
        String str = command.substring(2, command.length() - 1);
        int i = str.indexOf(59);
        int line = 0;
        int column = 0;
        if (i != -1) {
            line = Integer.valueOf(str.substring(0, i));
            column = Integer.valueOf(str.substring(i + 1));
        } else if (str.length() > 0) {
            line = Integer.valueOf(str);
        }
        try {
            int offset = this.getLineOffset(line);
            int maxColumn = this.getLineLength(line);
            this.moveCursorTo(offset += Math.min(maxColumn, column));
        }
        catch (BadLocationException e) {
            ForgeUIPlugin.log(e);
        }
    }

    private void clearCurrentScreenPage(String command) {
        String str = command.substring(2, command.length() - 1);
        if ("2".equals(str)) {
            this.reset();
        }
    }

    public void reset() {
        this.set("");
        this.moveCursorTo(0);
        this.styleRanges.clear();
        this.currentStyleRange = null;
    }

    private void initColors() {
        this.colors = new HashMap<String, Color>();
        this.colors.put("30", new Color((Device)Display.getDefault(), 0, 0, 0));
        this.colors.put("31", new Color((Device)Display.getDefault(), 255, 0, 0));
        this.colors.put("32", new Color((Device)Display.getDefault(), 0, 255, 0));
        this.colors.put("33", new Color((Device)Display.getDefault(), 128, 128, 0));
        this.colors.put("34", new Color((Device)Display.getDefault(), 0, 0, 255));
        this.colors.put("35", new Color((Device)Display.getDefault(), 255, 0, 255));
        this.colors.put("36", new Color((Device)Display.getDefault(), 0, 255, 255));
        this.colors.put("37", new Color((Device)Display.getDefault(), 192, 192, 192));
    }

    private void disposeColors() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        this.colors = null;
    }

    public StyleRange getCurrentStyleRange() {
        return this.currentStyleRange;
    }

    public StyleRange[] getStyleRanges() {
        return this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]);
    }

    public int getCursorOffset() {
        return this.cursorOffset;
    }

    public void addCursorListener(CursorListener listener) {
        this.cursorListeners.add(listener);
    }

    public void removeCursorListener(CursorListener listener) {
        this.cursorListeners.remove(listener);
    }

    private void moveCursorTo(int newOffset) {
        this.cursorOffset = newOffset;
        for (CursorListener listener : this.cursorListeners) {
            listener.cursorMoved();
        }
    }

    public static interface CursorListener {
        public void cursorMoved();
    }

    private class SyncForgeCommandFilter
    extends ForgeCommandFilter {
        public SyncForgeCommandFilter(ForgeOutputListener listener) {
            super(listener, (ForgeCommandProcessor)new ForgeCommandProcessorImpl());
        }

        public void outputAvailable(final String output) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SyncForgeCommandFilter.super.outputAvailable(output);
                }
            });
        }
    }
}

