/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.cli;

import java.io.IOException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.jboss.forge.addon.shell.spi.Terminal;

public class TextViewerTerminal
implements Terminal {
    private final UpdateWidgetSizeListener controlListener = new UpdateWidgetSizeListener();
    private final ITextViewer textViewer;
    private int height;
    private int width;

    public TextViewerTerminal(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public void initialize() {
        this.updateSize();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StyledText textWidget = TextViewerTerminal.this.textViewer.getTextWidget();
                textWidget.addControlListener((ControlListener)TextViewerTerminal.this.controlListener);
            }
        });
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void close() throws IOException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StyledText textWidget = TextViewerTerminal.this.textViewer.getTextWidget();
                textWidget.removeControlListener((ControlListener)TextViewerTerminal.this.controlListener);
            }
        });
    }

    private void updateSize() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StyledText textWidget = TextViewerTerminal.this.textViewer.getTextWidget();
                GC gc = new GC((Drawable)textWidget);
                gc.setFont(textWidget.getFont());
                Point p = gc.stringExtent("w");
                Point size = textWidget.getSize();
                TextViewerTerminal.this.height = size.y / p.y;
                TextViewerTerminal.this.width = size.x / p.x;
                gc.dispose();
            }
        });
    }

    private class UpdateWidgetSizeListener
    implements ControlListener {
        private UpdateWidgetSizeListener() {
        }

        public void controlMoved(ControlEvent e) {
            TextViewerTerminal.this.updateSize();
        }

        public void controlResized(ControlEvent e) {
            TextViewerTerminal.this.updateSize();
        }
    }
}

