/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.cli;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.ITextViewer;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.shell.spi.ShellHandle;
import org.jboss.forge.addon.shell.spi.ShellHandleSettings;
import org.jboss.forge.addon.shell.spi.Terminal;
import org.jboss.forge.addon.shell.spi.command.CdTokenHandler;
import org.jboss.forge.addon.shell.spi.command.CdTokenHandlerFactory;
import org.jboss.forge.addon.ui.UIDesktop;
import org.jboss.forge.addon.ui.command.AbstractCommandExecutionListener;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.tools.aesh.core.console.AbstractConsole;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.cli.CommandLineListener;
import org.jboss.tools.forge.ui.internal.cli.TextViewerTerminal;
import org.jboss.tools.forge.ui.internal.cli.WorkspaceCdTokenHandler;
import org.jboss.tools.forge.ui.internal.ext.provider.ForgeUIDesktop;

public class AeshConsole
extends AbstractConsole {
    private TextViewerTerminal terminal;
    private ShellHandle handle;
    private CommandLineListener executionListener = new CommandLineListener();
    private ListenerRegistration<CdTokenHandler> tokenHandler;
    private Resource<?> currentResource;

    public AeshConsole(ITextViewer textViewer) {
        this.terminal = new TextViewerTerminal(textViewer);
    }

    public void start() {
        this.handle = (ShellHandle)FurnaceService.INSTANCE.lookup(ShellHandle.class);
        ResourceFactory resourceFactory = (ResourceFactory)FurnaceService.INSTANCE.lookup(ResourceFactory.class);
        File currentDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        this.currentResource = resourceFactory.create((Object)currentDir);
        OutputStream stdOut = this.getOutputStream();
        OutputStream stdErr = this.getErrorStream();
        PrintStream out = new PrintStream(stdOut, true);
        PrintStream err = new PrintStream(stdErr, true);
        ShellHandleSettings settings = new ShellHandleSettings();
        settings.stdOut(out).stdErr(err).stdIn(this.getInputStream()).currentResource(currentDir).terminal((Terminal)this.terminal).desktop((UIDesktop)new ForgeUIDesktop());
        this.handle.initialize(settings);
        this.handle.addCommandExecutionListener((CommandExecutionListener)this.executionListener);
        this.handle.addCommandExecutionListener((CommandExecutionListener)new AbstractCommandExecutionListener(){

            public void postCommandExecuted(UICommand command, UIExecutionContext context, Result result) {
                AeshConsole.this.currentResource = (Resource)context.getUIContext().getSelection().get();
            }
        });
        ProjectFactory projectFactory = (ProjectFactory)FurnaceService.INSTANCE.lookup(ProjectFactory.class);
        projectFactory.addProjectListener((ProjectListener)this.executionListener);
        CdTokenHandlerFactory tokenHandlerFactory = (CdTokenHandlerFactory)FurnaceService.INSTANCE.lookup(CdTokenHandlerFactory.class);
        this.tokenHandler = tokenHandlerFactory.addTokenHandler((CdTokenHandler)new WorkspaceCdTokenHandler(resourceFactory));
    }

    public void stop() {
        this.handle.destroy();
        this.handle = null;
        if (this.tokenHandler != null) {
            this.tokenHandler.removeListener();
        }
        this.tokenHandler = null;
    }

    public Resource<?> getCurrentResource() {
        return this.currentResource;
    }
}

