/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.eclipse.preferences;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.browsersim.eclipse.Messages;
import org.jboss.tools.vpe.browsersim.eclipse.preferences.PreferencesUtil;

public class BrowserSimPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String BROWSERSIM_JVM_ID = "org.jboss.tools.vpe.browsersim.jvm";
    public static final String BROWSERSIM_JVM_AUTOMATICALLY = "org.jboss.tools.vpe.browsersim.jvm.automatically";
    public static final String BROWSERSIM_GTK_2 = "org.jboss.tools.vpe.browsersim.gtk2";
    private Combo combo;
    private Button automatically;
    private Button select;
    private Button gtk2;
    private Button gtk3;
    private List<IVMInstall> jvms;
    private SelectionListener radioListener;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.jvms = PreferencesUtil.getSuitableJvms();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 2;
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = nColumns;
        result.setLayout((Layout)layout);
        PreferenceLinkArea contentTypeArea = new PreferenceLinkArea(result, 0, "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", Messages.BrowserSimPreferencesPage_JRE_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        contentTypeArea.getControl().setLayoutData((Object)data);
        contentTypeArea.getControl().setFont(parent.getFont());
        Group jreGroup = new Group(result, 0);
        GridLayout jreGroupLayout = new GridLayout();
        jreGroupLayout.numColumns = 3;
        jreGroup.setLayout((Layout)jreGroupLayout);
        GridData jreGroupLayoutData = new GridData(768);
        jreGroupLayoutData.horizontalSpan = 2;
        jreGroup.setLayoutData((Object)jreGroupLayoutData);
        jreGroup.setText(Messages.BrowserSimPreferencesPage_SELECT_JRE);
        this.radioListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BrowserSimPreferencesPage.this.controlChanged(e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.automatically = this.addRadioButton((Composite)jreGroup, Messages.BrowserSimPreferencesPage_DETECT_AUTOMATICALLY, BROWSERSIM_JVM_AUTOMATICALLY, "true", 0);
        this.automatically.addSelectionListener(this.radioListener);
        this.select = this.addRadioButton((Composite)jreGroup, Messages.BrowserSimPreferencesPage_SELECT, BROWSERSIM_JVM_AUTOMATICALLY, "false", 0);
        this.select.addSelectionListener(this.radioListener);
        this.combo = new Combo((Composite)jreGroup, 8);
        int i = 0;
        while (i < this.jvms.size()) {
            this.combo.add(this.jvms.get(i).getName(), i);
            ++i;
        }
        this.combo.setLayoutData((Object)new GridData(768));
        this.fillValues();
        if ("linux".equals(PlatformUtil.getOs())) {
            this.addGtkGroup(result);
        }
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void addGtkGroup(Composite result) {
        Group gtkGroup = new Group(result, 0);
        GridLayout gtkGroupLayout = new GridLayout();
        gtkGroupLayout.numColumns = 2;
        gtkGroup.setLayout((Layout)gtkGroupLayout);
        GridData gtkGridData = new GridData(768);
        gtkGroup.setLayoutData((Object)gtkGridData);
        gtkGroup.setText(Messages.BrowserSimPreferencesPage_SELECT_GTK);
        this.gtk2 = this.addRadioButton((Composite)gtkGroup, Messages.BrowserSimPreferencesPage_GTK_2, BROWSERSIM_GTK_2, "true", 0);
        this.gtk3 = this.addRadioButton((Composite)gtkGroup, Messages.BrowserSimPreferencesPage_GTK_3, BROWSERSIM_GTK_2, "false", 0);
        this.setGtkValues();
    }

    private void setGtkValues() {
        if ("true".equals(this.getPreferenceStore().getString(BROWSERSIM_GTK_2))) {
            this.gtk2.setSelection(true);
        } else {
            this.gtk3.setSelection(true);
        }
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        return button;
    }

    private void fillValues() {
        if (this.jvms.isEmpty()) {
            boolean is32bitEclipse = "x86".equals(PlatformUtil.getArch());
            String message = MessageFormat.format(Messages.BrowserSimPreferencesPage_REQUIREMENTS, is32bitEclipse ? "32-bit" : "64-bit");
            this.setMessage(message, 3);
            this.automatically.setSelection(true);
            this.select.setEnabled(false);
            this.combo.setEnabled(false);
        } else {
            int selectionIndex = -1;
            if ("false".equals(this.getPreferenceStore().getString(BROWSERSIM_JVM_AUTOMATICALLY))) {
                String selectedID = this.getPreferenceStore().getString(BROWSERSIM_JVM_ID);
                int i = 0;
                while (i < this.jvms.size()) {
                    if (selectedID.equals(this.jvms.get(i).getId())) {
                        selectionIndex = i;
                        break;
                    }
                    ++i;
                }
                this.select.setSelection(true);
                this.controlChanged((Widget)this.select);
            } else {
                this.automatically.setSelection(true);
                this.controlChanged((Widget)this.automatically);
            }
            this.automatically.setText(String.valueOf(this.automatically.getText()) + " (" + this.jvms.get(0).getName() + ")");
            this.combo.select(selectionIndex);
        }
    }

    private void controlChanged(Widget widget) {
        if (this.select.equals(widget)) {
            this.combo.setEnabled(true);
            if (this.combo.getSelectionIndex() == -1) {
                this.combo.select(0);
            }
        } else {
            this.combo.setEnabled(false);
        }
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if ("linux".equals(PlatformUtil.getOs())) {
            if (this.gtk2.getSelection()) {
                store.setValue(BROWSERSIM_GTK_2, "true");
            } else {
                store.setValue(BROWSERSIM_GTK_2, "false");
            }
        }
        if (this.automatically.getSelection()) {
            store.setValue(BROWSERSIM_JVM_AUTOMATICALLY, "true");
        } else {
            store.setValue(BROWSERSIM_JVM_AUTOMATICALLY, "false");
            String value = this.jvms.get(this.combo.getSelectionIndex()).getId();
            boolean exists = false;
            for (IVMInstall vm : PreferencesUtil.getSuitableJvms()) {
                if (!value.equals(vm.getId())) continue;
                exists = true;
                break;
            }
            if (exists) {
                store.setValue(BROWSERSIM_JVM_ID, value);
            } else {
                store.setValue(BROWSERSIM_JVM_AUTOMATICALLY, "true");
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.automatically.setSelection(true);
        this.select.setSelection(false);
        if ("linux".equals(PlatformUtil.getOs())) {
            this.gtk2.setSelection(true);
            this.gtk3.setSelection(false);
        }
        this.controlChanged((Widget)this.automatically);
        super.performDefaults();
    }
}

