/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.eclipse.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.browsersim.eclipse.Messages;
import org.jboss.tools.vpe.browsersim.eclipse.dialog.BrowserSimErrorDialog;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessCallback;
import org.jboss.tools.vpe.browsersim.eclipse.preferences.PreferencesUtil;
import org.osgi.framework.Bundle;

public class ExternalProcessLauncher {
    private static String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String CONFIGURATION = "-configuration";
    private static final String SWT_GTK3 = "SWT_GTK3";
    private static final String OFF = "0";
    private static final String ON = "1";

    public static void launchAsExternalProcess(List<String> bundles, List<String> resourcesBundles, List<ExternalProcessCallback> callbacks, String className, List<String> parameters, String programName, IVMInstall jvm) {
        try {
            String classPath = ExternalProcessLauncher.getClassPathString(bundles, resourcesBundles);
            String jreContainerPath = JavaRuntime.newJREContainerPath((IVMInstall)jvm).toPortableString();
            if (jreContainerPath != null) {
                ArrayList<String> commandElements = new ArrayList<String>();
                commandElements.add("-Dsun.net.http.allowRestrictedHeaders=true");
                if ("macosx".equals(Platform.getOS())) {
                    commandElements.add("-XstartOnFirstThread");
                }
                ExternalProcessLauncher.addConfigurationFolderParameter(parameters);
                ILaunch launch = ExternalProcessLauncher.launch(programName, classPath, className, parameters, jreContainerPath, commandElements);
                ExternalProcessLauncher.ProcessCallBacks(launch, callbacks);
            } else {
                ExternalProcessLauncher.showErrorDialog(programName);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private static List<String> addConfigurationFolderParameter(List<String> parameters) throws URISyntaxException, IOException {
        parameters.add(CONFIGURATION);
        parameters.add(PreferencesUtil.getBrowserSimConfigFolderPath());
        return parameters;
    }

    private static void ProcessCallBacks(ILaunch launch, final List<ExternalProcessCallback> callbacks) {
        IProcess[] processes = launch.getProcesses();
        if (processes.length > 0) {
            IProcess process = processes[0];
            IStreamMonitor outputStreamMonitor = process.getStreamsProxy().getOutputStreamMonitor();
            outputStreamMonitor.addListener(new IStreamListener(){

                public void streamAppended(String message, IStreamMonitor monitor) {
                    for (ExternalProcessCallback callback : callbacks) {
                        if (!message.startsWith(callback.getCallbackId())) continue;
                        try {
                            callback.call(message, null);
                        }
                        catch (IOException e) {
                            Activator.logError(e.getMessage(), e);
                        }
                    }
                }
            });
        } else {
            Activator.logError("Unable to get launch process", new Throwable());
        }
    }

    public static boolean isGTK2() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return "true".equals(store.getString("org.jboss.tools.vpe.browsersim.gtk2"));
    }

    private static void setUpGtkEnvironmentalVariable(ILaunchConfigurationWorkingCopy workingCopy) {
        HashMap<String, String> environment = new HashMap<String, String>();
        if (ExternalProcessLauncher.isGTK2()) {
            environment.put(SWT_GTK3, OFF);
        } else {
            environment.put(SWT_GTK3, ON);
        }
        workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environment);
    }

    public static void showErrorDialog(final String programName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (shell == null) {
                    shell = Display.getDefault().getShells()[0];
                }
                BrowserSimErrorDialog e = new BrowserSimErrorDialog(shell, Messages.ExternalProcessLauncher_ERROR, shell.getDisplay().getSystemImage(1), programName, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                e.open();
            }
        });
    }

    private static String getClassPathString(List<String> bundles, List<String> resourcesBundles) throws IOException {
        ArrayList<Bundle> classPathBundles = new ArrayList<Bundle>();
        for (String bundleName : bundles) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) continue;
            classPathBundles.add(bundle);
        }
        StringBuilder classPath = new StringBuilder();
        if (classPathBundles.size() > 0) {
            int i = 0;
            while (i < classPathBundles.size() - 1) {
                classPath.append(ExternalProcessLauncher.getBundleLocation((Bundle)classPathBundles.get(i)));
                classPath.append(PATH_SEPARATOR);
                ++i;
            }
            classPath.append(ExternalProcessLauncher.getBundleLocation((Bundle)classPathBundles.get(classPathBundles.size() - 1)));
        }
        for (String bundleName : resourcesBundles) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) continue;
            classPath.append(ExternalProcessLauncher.getResource(bundle));
        }
        return classPath.toString();
    }

    public static List<String> getClassPathMementos(String classPathString) {
        String[] classPathArray = classPathString.split(PATH_SEPARATOR);
        ArrayList<String> classpathMementos = new ArrayList<String>();
        int i = 0;
        while (i < classPathArray.length) {
            IRuntimeClasspathEntry cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(classPathArray[i]));
            cpEntry.setClasspathProperty(3);
            try {
                classpathMementos.add(cpEntry.getMemento());
            }
            catch (CoreException e) {
                BrowserSimLogger.logError((String)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return classpathMementos;
    }

    public static String getBundleLocation(Bundle bundle) throws IOException {
        try {
            File binDirectory;
            File bundleLocation = FileLocator.getBundleFile((Bundle)bundle);
            if (bundleLocation.isDirectory() && (binDirectory = new File(bundleLocation, "bin")).isDirectory()) {
                bundleLocation = binDirectory;
            }
            return bundleLocation.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IOException(String.valueOf(Messages.ExternalProcessLauncher_NO_BUNDLE) + bundle.getSymbolicName(), e);
        }
    }

    private static String getResource(Bundle bundle) throws IOException {
        StringBuilder result = new StringBuilder();
        String location = FileLocator.getBundleFile((Bundle)bundle).getCanonicalPath();
        File resources = new File(String.valueOf(location) + "/plugins");
        if (resources.exists()) {
            File[] fileArray = resources.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File resource = fileArray[n2];
                result.append(PATH_SEPARATOR);
                result.append(resource.getCanonicalPath());
                ++n2;
            }
        }
        return result.toString();
    }

    private static ILaunch launch(String programmName, String classPath, String className, List<String> parameters, String jvmPath, List<String> commandElements) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, programmName);
        ExternalProcessLauncher.setWorkingCopyAttributes(workingCopy, classPath, className, parameters, jvmPath, commandElements);
        return workingCopy.launch("run", null);
    }

    private static void setWorkingCopyAttributes(ILaunchConfigurationWorkingCopy workingCopy, String classPath, String className, List<String> parameters, String jreContainerPath, List<String> commandElements) {
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, ExternalProcessLauncher.getClassPathMementos(classPath));
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, jreContainerPath);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, PreferencesUtil.argumentsListToString(commandElements));
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, PreferencesUtil.argumentsListToString(parameters));
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, className);
        if ("linux".equals(PlatformUtil.getOs())) {
            ExternalProcessLauncher.setUpGtkEnvironmentalVariable(workingCopy);
        }
    }
}

