/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.android.core.adt;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.android.core.AndroidCore;
import org.eclipse.thym.android.core.adt.AndroidProjectUtils;
import org.eclipse.thym.android.core.adt.AndroidSDK;
import org.eclipse.thym.android.core.adt.AndroidSDKManager;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.ImageResourceBase;
import org.eclipse.thym.core.config.Splash;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AndroidProjectGenerator
extends AbstractProjectGeneratorDelegate {
    public AndroidProjectGenerator() {
    }

    public AndroidProjectGenerator(IProject project, File generationFolder, String platform) {
        this.init(project, generationFolder, platform);
    }

    protected void generateNativeFiles(HybridMobileLibraryResolver resolver) throws CoreException {
        AndroidSDKManager sdkManager = AndroidSDKManager.getManager();
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
        if (hybridProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Not a hybrid mobile project, can not generate files"));
        }
        Widget widgetModel = WidgetModel.getModel((HybridProject)hybridProject).getWidgetForRead();
        String packageName = widgetModel.getId();
        String name = hybridProject.getBuildArtifactAppName();
        AndroidSDK target = AndroidProjectUtils.selectBestValidTarget(resolver);
        File destinationDir = this.getDestination();
        Path destinationPath = new Path(destinationDir.toString());
        if (destinationDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)destinationDir);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.thym.android.core", NLS.bind((String)"Could not clean the android working directory at {0}", (Object)destinationDir), (Throwable)e));
            }
        }
        sdkManager.createProject(target, name, destinationDir, name, packageName, (IProgressMonitor)new NullProgressMonitor());
        try {
            IPath cordovaJarPath = destinationPath.append("libs").append("cordova.jar");
            org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)resolver.getTemplateFile(cordovaJarPath.makeRelativeTo((IPath)destinationPath)), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)cordovaJarPath.toFile()));
            IPath resPath = destinationPath.append("res");
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile(resPath.makeRelativeTo((IPath)destinationPath)), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)resPath.toFile()));
            IFile configFile = hybridProject.getConfigFile();
            IPath xmlPath = resPath.append("xml");
            File xmldir = xmlPath.toFile();
            if (!xmldir.exists()) {
                xmldir.mkdirs();
            }
            org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)configFile.getLocation().toFile()), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)xmlPath.append("config.xml").toFile()));
            this.handleIcons(widgetModel, hybridProject);
            this.handleSplashScreens(widgetModel, hybridProject);
            this.updateAppName(hybridProject.getAppName());
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("__ID__", packageName);
            values.put("__PACKAGE__", packageName);
            values.put("__ACTIVITY__", name);
            values.put("__APILEVEL__", target.getApiLevel());
            IPath andrManifestPath = destinationPath.append("AndroidManifest.xml");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile(andrManifestPath.makeRelativeTo((IPath)destinationPath)), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)andrManifestPath.toFile()), values);
            IPath activityPath = new Path("src").append("$package").append("$appname.java");
            IPath resolvedActivityPath = destinationPath.append("src").append(packageName.replace('.', '/')).append(String.valueOf(name) + ".java");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile(activityPath), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)resolvedActivityPath.toFile()), values);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Error generating the native android project", (Throwable)e));
        }
    }

    private void handleSplashScreens(Widget widget, HybridProject project) throws CoreException {
        List splashes = widget.getSplashes();
        if (splashes == null || splashes.isEmpty()) {
            return;
        }
        File resDir = new File(this.getDestination(), "res");
        boolean templateCleaned = false;
        for (Splash splash : splashes) {
            String filename;
            IFile splashFile = null;
            String density = null;
            if (splash.isDefault()) {
                splashFile = project.getProject().getFile(splash.getSrc());
            } else if (this.getTargetShortName().equals(splash.getPlatform()) && splash.getDensity() != null && !splash.getDensity().isEmpty()) {
                splashFile = project.getProject().getFile(splash.getSrc());
                density = splash.getDensity();
            }
            if (splashFile == null) continue;
            if (!templateCleaned) {
                this.deleteTemplateResources(resDir, "screen.png");
                templateCleaned = true;
            }
            if (!splashFile.exists()) {
                AndroidCore.log(4, NLS.bind((String)"Missing splash screen image {0}", (Object)splash.getSrc()), null);
                continue;
            }
            String string = filename = splashFile.getName().indexOf(".9.") > 0 ? "screen.9.png" : "screen.png";
            if (density != null && !density.isEmpty()) {
                filename = "drawable-" + density + "/" + filename;
            }
            try {
                org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)splashFile.getLocation().toFile()), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(resDir, filename)));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Error while processing android splash screens ", (Throwable)e));
            }
        }
    }

    private void handleIcons(Widget widgetModel, HybridProject project) throws CoreException {
        List icons = widgetModel.getIcons();
        if (icons == null || icons.isEmpty()) {
            return;
        }
        try {
            File resFile = new File(this.getDestination(), "res");
            boolean templateCleaned = false;
            for (ImageResourceBase icon : icons) {
                IFile iconFile = null;
                String density = null;
                if (icon.isDefault()) {
                    iconFile = project.getProject().getFile(icon.getSrc());
                } else if (this.getTargetShortName().equals(icon.getPlatform())) {
                    iconFile = project.getProject().getFile(icon.getSrc());
                    density = AndroidProjectUtils.getDensityForIcon(icon);
                    if (density == null || density.isEmpty()) {
                        AndroidCore.log(4, NLS.bind((String)"Can not determine density for icon {0}", (Object)icon.getSrc()), null);
                        continue;
                    }
                }
                if (iconFile == null) continue;
                if (!templateCleaned) {
                    this.deleteTemplateResources(resFile, "icon.png");
                    templateCleaned = true;
                }
                if (!iconFile.exists()) {
                    AndroidCore.log(4, NLS.bind((String)"Missing icon file {0}", (Object)icon.getSrc()), null);
                    continue;
                }
                String drawableDir = density != null && !density.isEmpty() ? "drawable-" + density : "drawable";
                org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)iconFile.getLocation().toFile()), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(resFile, String.valueOf(drawableDir) + "/icon.png")));
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.android.core", "Error whiile processing android icons", (Throwable)e));
        }
    }

    private void deleteTemplateResources(File directory, String name) {
        Collection files = FileUtils.listFiles((File)directory, (IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File file : files) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    private void updateAppName(String appName) throws CoreException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            IPath stringsPath = new Path(this.getDestination().toString()).append("res").append("values").append("strings.xml");
            File strings = stringsPath.toFile();
            Document configDocument = db.parse(strings);
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                XPathExpression expr = xpath.compile("//string[@name=\"app_name\"]");
                Node node = (Node)expr.evaluate(configDocument, XPathConstants.NODE);
                node.setTextContent(appName);
                configDocument.setXmlStandalone(true);
                DOMSource source = new DOMSource(configDocument);
                StreamResult result = new StreamResult(strings);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer xformer = transformerFactory.newTransformer();
                xformer.transform(source, result);
            }
            catch (XPathExpressionException e) {
                AndroidCore.log(4, "Error when updating the application name", e);
            }
            catch (TransformerConfigurationException e) {
                AndroidCore.log(4, "Error when updating the application name", e);
            }
            catch (TransformerException e) {
                AndroidCore.log(4, "Error when updating the application name", e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parser error when parsing /res/values/strings.xml", (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Parsing error on /res/values/strings.xml", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "IO error when parsing /res/values/strings.xml", (Throwable)e));
        }
    }

    protected void replaceCordovaPlatformFiles(HybridMobileLibraryResolver resolver) throws IOException {
        IPath cordovaJSPath = new Path(this.getPlatformWWWDirectory().toString()).append("cordova.js");
        org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)resolver.getTemplateFile(HybridMobileLibraryResolver.PATH_CORDOVA_JS), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)cordovaJSPath.toFile()));
    }

    protected File getPlatformWWWDirectory() {
        return AndroidProjectUtils.getPlatformWWWDirectory(this.getDestination());
    }
}

