/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.xml.components.model;

import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.xml.components.model.SeamComponentConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamComponentsLoaderUtil
extends XModelObjectLoaderUtil
implements SeamComponentConstants {
    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        return super.save(parent, o);
    }

    protected boolean needToSave(XModelObject o) {
        String s = o.getModelEntity().getProperty("saveDefault");
        if (!"false".equals(s)) {
            return true;
        }
        if (this.hasSetAttributes(o)) {
            return true;
        }
        return o.getChildren().length > 0;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && (v = o.getAttributeValue(as[i].getName())) != null && v.length() > 0) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }

    public boolean saveChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        String childrenLoader = o.getModelEntity().getProperty("childrenLoader");
        if ("SeamPropertyMap".equals(entity) || "map".equals(childrenLoader)) {
            return this.savePropertyMapChildren(element, o);
        }
        return super.saveChildren(element, o);
    }

    private boolean savePropertyMapChildren(Element element, XModelObject o) {
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            Element k = XMLUtilities.createElement((Element)element, (String)"key");
            this.saveAttribute(k, "#text", cs[i].getAttributeValue("key"));
            Element v = XMLUtilities.createElement((Element)element, (String)"value");
            this.saveAttribute(v, "#text", cs[i].getAttributeValue("value"));
            ++i;
        }
        return true;
    }

    public void loadChildren(Element element, XModelObject o) {
        super.loadChildren(element, o);
    }

    protected String getChildEntity(XModelEntity entity, Element e) {
        String n = e.getNodeName();
        if ("property".equals(n)) {
            Element[] es = XMLUtilities.getChildren((Element)e, (String)"key");
            if (es != null && es.length > 0) {
                return "SeamPropertyMap";
            }
            es = XMLUtilities.getChildren((Element)e, (String)"value");
            if (es != null && es.length > 0) {
                return "SeamPropertyList";
            }
            return "SeamProperty";
        }
        return super.getChildEntity(entity, e);
    }

    public void load(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        String childrenLoader = o.getModelEntity().getProperty("childrenLoader");
        if ("SeamPropertyMap".equals(entity) || "map".equals(childrenLoader)) {
            this.loadPropertyMap(element, o);
        } else {
            super.load(element, o);
        }
    }

    void loadPropertyMap(Element element, XModelObject o) {
        this.loadAttributes(element, o);
        XModelObject last = null;
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("key")) {
                    last = o.getModel().createModelObject("SeamMapEntry", null);
                    last.setAttributeValue("key", this.getAttribute((Element)n, "#text"));
                    o.addChild(last);
                } else if (n.getNodeName().equals("value")) {
                    if (last == null) {
                        last = o.getModel().createModelObject("SeamMapEntry", null);
                        o.addChild(last);
                    }
                    last.setAttributeValue("value", this.getAttribute((Element)n, "#text"));
                    last = null;
                }
            }
            ++i;
        }
    }
}

