/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.cdi.seam.solder.core.definition.InterfaceDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.impl.AnnotationLiteral;
import org.jboss.tools.common.model.XModelObject;

public class CDISeamSolderLoggerExtension
implements ICDIExtension,
IBuildParticipantFeature {
    LoggerDefinitionContext context = new LoggerDefinitionContext();

    protected Version getVersion() {
        return Version.instance;
    }

    public IDefinitionContextExtension getContext() {
        return this.context;
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
        LoggerDefinitionContext workingCopy = (LoggerDefinitionContext)this.context.getWorkingCopy();
        Map is = fileSet.getInterfaces();
        for (IPath path : is.keySet()) {
            for (IType t : (List)is.get(path)) {
                TypeDefinition d;
                InterfaceDefinition i = new InterfaceDefinition(t, (IDefinitionContextExtension)this.context);
                if (i.isAnnotationPresent(this.getVersion().getMessageLoggerAnnotationTypeName())) {
                    d = new TypeDefinition();
                    d.setType(t, workingCopy.getRootContext(), 0);
                    d.setBeanConstructor(true);
                    workingCopy.addMessageLogger(path, d);
                    continue;
                }
                if (!i.isAnnotationPresent(this.getVersion().getMessageBundleAnnotationTypeName())) continue;
                d = new TypeDefinition();
                d.setType(t, workingCopy.getRootContext(), 0);
                d.setBeanConstructor(true);
                workingCopy.addMessageBundle(path, d);
                AnnotationDeclaration ad = d.getAnnotation(this.getVersion().getMessageBundleAnnotationTypeName());
                if (ad.getMemberValue("projectCode") == null || ad.getMemberValue("projectCode").toString().length() <= 0) continue;
                String text = d.getContent();
                int st = ad.getStartPosition();
                int le = ad.getLength();
                String source = text.substring(st, st + le);
                AnnotationLiteral l = new AnnotationLiteral(d.getResource(), source, (ISourceRange)new SourceRange(st, le), null, ad.getType());
                d.removeAnnotation((IAnnotationDeclaration)ad);
                d.addAnnotation((IJavaAnnotation)l, workingCopy.getRootContext());
            }
        }
    }

    public void buildBeans(CDIProject target) {
        CDIProject p = target;
        Map<String, TypeDefinition> loggers = this.context.getMessageLoggers();
        for (TypeDefinition d : loggers.values()) {
            ClassBean b = new ClassBean();
            b.setDefinition(d);
            b.setParent((ICDIElement)p);
            p.addBean((IBean)b);
        }
        Map<String, TypeDefinition> bundles = this.context.getMessageBundles();
        for (TypeDefinition d : bundles.values()) {
            ClassBean b = new ClassBean();
            b.setDefinition(d);
            b.setParent((ICDIElement)p);
            p.addBean((IBean)b);
        }
    }

    class LoggerDefinitionContext
    extends AbstractDefinitionContextExtension {
        Map<String, TypeDefinition> messageLoggers = new HashMap<String, TypeDefinition>();
        Map<String, TypeDefinition> messageBundles = new HashMap<String, TypeDefinition>();

        LoggerDefinitionContext() {
        }

        protected LoggerDefinitionContext copy(boolean clean) {
            LoggerDefinitionContext copy = new LoggerDefinitionContext();
            copy.root = this.root;
            if (!clean) {
                TypeDefinition d;
                for (String qn : this.messageLoggers.keySet()) {
                    d = this.messageLoggers.get(qn);
                    if (!d.exists()) continue;
                    copy.messageLoggers.put(qn, d);
                }
                for (String qn : this.messageBundles.keySet()) {
                    d = this.messageBundles.get(qn);
                    if (!d.exists()) continue;
                    copy.messageBundles.put(qn, d);
                }
            }
            return copy;
        }

        protected void doApplyWorkingCopy() {
            this.messageLoggers = ((LoggerDefinitionContext)this.workingCopy).messageLoggers;
            this.messageBundles = ((LoggerDefinitionContext)this.workingCopy).messageBundles;
        }

        public void clean() {
            this.messageLoggers.clear();
            this.messageBundles.clear();
        }

        public void clean(IPath path) {
        }

        public void clean(String typeName) {
            this.messageLoggers.remove(typeName);
            this.messageBundles.remove(typeName);
        }

        public void addMessageLogger(IPath path, TypeDefinition def) {
            String typeName = def.getType().getFullyQualifiedName();
            this.messageLoggers.put(typeName, def);
            this.root.addType(path, typeName);
        }

        public void addMessageBundle(IPath path, TypeDefinition def) {
            String typeName = def.getType().getFullyQualifiedName();
            this.messageBundles.put(typeName, def);
            this.root.addType(path, typeName);
        }

        public Map<String, TypeDefinition> getMessageLoggers() {
            return this.messageLoggers;
        }

        public Map<String, TypeDefinition> getMessageBundles() {
            return this.messageBundles;
        }
    }
}

