/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.PackageDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderCorePlugin;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.TypeDeclaration;
import org.jboss.tools.common.java.impl.AnnotationLiteral;
import org.jboss.tools.common.util.BeanUtil;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class CDISeamSolderCoreExtension
implements ICDIExtension,
IProcessAnnotatedTypeFeature {
    protected Version getVersion() {
        return Version.instance;
    }

    public void processAnnotatedType(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        if (this.processVeto(typeDefinition, context)) {
            return;
        }
        if (this.processRequires(typeDefinition, context)) {
            return;
        }
        this.processNames(typeDefinition, context);
        this.processExact(typeDefinition, context);
    }

    private boolean processVeto(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        if (typeDefinition.isAnnotationPresent(this.getVersion().getVetoAnnotationTypeName()) || typeDefinition.getPackageDefinition() != null && typeDefinition.getPackageDefinition().isAnnotationPresent(this.getVersion().getVetoAnnotationTypeName())) {
            typeDefinition.veto();
            return true;
        }
        return false;
    }

    private boolean processRequires(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        HashSet<String> requiredClasses = new HashSet<String>();
        requiredClasses.addAll(this.getRequiredClasses((IAnnotated)typeDefinition));
        PackageDefinition pkg = typeDefinition.getPackageDefinition();
        if (pkg != null) {
            requiredClasses.addAll(this.getRequiredClasses((IAnnotated)pkg));
        }
        if (!requiredClasses.isEmpty()) {
            for (String c : requiredClasses) {
                if (context.getProject().getType(c) != null) continue;
                typeDefinition.veto();
                return true;
            }
        }
        return false;
    }

    private void processNames(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        PackageDefinition p = typeDefinition.getPackageDefinition();
        AnnotationDeclaration namedOnPackage = null;
        AnnotationDeclaration fullyQualifiedOnPackage = null;
        if (p != null) {
            namedOnPackage = p.getAnnotation("javax.inject.Named");
            fullyQualifiedOnPackage = p.getAnnotation(this.getVersion().getFullyQualifiedAnnotationTypeName());
        }
        this.processNames((AbstractMemberDefinition)typeDefinition, context, (IAnnotationDeclaration)namedOnPackage, (IAnnotationDeclaration)fullyQualifiedOnPackage, p);
        List fs = typeDefinition.getFields();
        for (FieldDefinition f : fs) {
            if (!f.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
            this.processNames((AbstractMemberDefinition)f, context, null, (IAnnotationDeclaration)fullyQualifiedOnPackage, p);
        }
        List ms = typeDefinition.getMethods();
        for (MethodDefinition m : ms) {
            if (!m.isAnnotationPresent("javax.enterprise.inject.Produces")) continue;
            this.processNames((AbstractMemberDefinition)m, context, null, (IAnnotationDeclaration)fullyQualifiedOnPackage, p);
        }
    }

    private void processNames(AbstractMemberDefinition d, IRootDefinitionContext context, IAnnotationDeclaration namedOnPackage, IAnnotationDeclaration fullyQualifiedOnPackage, PackageDefinition p) {
        AnnotationDefinition n;
        AnnotationDeclaration named = d.getAnnotation("javax.inject.Named");
        AnnotationDeclaration fullyQualified = d.getAnnotation(this.getVersion().getFullyQualifiedAnnotationTypeName());
        String beanName = null;
        if (!(fullyQualified == null && fullyQualifiedOnPackage == null || named == null && namedOnPackage == null)) {
            if (named == null) {
                named = namedOnPackage;
            }
            String pkg = this.resolvePackageName((IAnnotationDeclaration)fullyQualified, fullyQualifiedOnPackage, d.getTypeDefinition(), p);
            String simpleName = this.getSimpleBeanName(d, (IAnnotationDeclaration)named);
            beanName = simpleName == null ? null : (pkg.length() > 0 ? String.valueOf(pkg) + "." + simpleName : simpleName);
        } else if (named == null && namedOnPackage != null) {
            beanName = this.getSimpleBeanName(d, namedOnPackage);
        }
        if (beanName != null && (n = context.getAnnotation("javax.inject.Named")) != null) {
            AnnotationLiteral l = new AnnotationLiteral(d.getResource(), 0, 0, (Object)beanName, 9, n.getType());
            if (named != null) {
                d.removeAnnotation((IAnnotationDeclaration)named);
            }
            d.addAnnotation((IJavaAnnotation)l, context);
        }
    }

    private List<String> getRequiredClasses(IAnnotated d) {
        IAnnotationDeclaration requires = d.getAnnotation(this.getVersion().getRequiresAnnotationTypeName());
        return requires != null ? this.getArrayValue(requires) : new ArrayList();
    }

    private List<String> getArrayValue(IAnnotationDeclaration d) {
        Object value = d.getMemberValue(null);
        ArrayList<String> result = new ArrayList<String>();
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int i = 0;
            while (i < array.length) {
                if (array[i] != null) {
                    result.add(array[i].toString());
                }
                ++i;
            }
        } else if (value instanceof String) {
            result.add(value.toString());
        }
        return result;
    }

    private void processExact(TypeDefinition typeDefinition, IRootDefinitionContext context) {
        List fs = typeDefinition.getFields();
        for (FieldDefinition f : fs) {
            TypeDeclaration exact = this.getExactType((IAnnotated)f, typeDefinition, context);
            if (exact == null) continue;
            f.setOverridenType((ITypeDeclaration)exact);
        }
        List ms = typeDefinition.getMethods();
        for (MethodDefinition m : ms) {
            List ps = m.getParameters();
            for (ParameterDefinition p : ps) {
                TypeDeclaration exact = this.getExactType((IAnnotated)p, typeDefinition, context);
                if (exact == null) continue;
                p.setOverridenType(exact);
            }
        }
    }

    private TypeDeclaration getExactType(IAnnotated annotated, TypeDefinition declaringType, IRootDefinitionContext context) {
        String s;
        Object o;
        IAnnotationDeclaration a = annotated.getAnnotation(this.getVersion().getExactAnnotationTypeName());
        if (a != null && (o = a.getMemberValue(null)) != null && (s = o.toString()).length() > 0) {
            try {
                String content;
                int i;
                ParametedType p = context.getProject().getTypeFactory().getParametedType((IMember)declaringType.getType(), "Q" + s + ";");
                int b = a.getStartPosition();
                int e = b + a.getLength();
                if (b >= 0 && e > b && (i = (content = declaringType.getContent().substring(b, e)).indexOf(s)) >= 0) {
                    b = i;
                    e = i + s.length();
                }
                return new TypeDeclaration(p, a.getResource(), b, e - b);
            }
            catch (JavaModelException e) {
                CDISeamSolderCorePlugin.getDefault().logError(e);
            }
        }
        return null;
    }

    private String resolvePackageName(IAnnotationDeclaration fullyQualified, IAnnotationDeclaration fullyQualifiedOnPackage, AbstractTypeDefinition t, PackageDefinition p) {
        int dot;
        IAnnotationDeclaration a;
        String contextClass = null;
        IAnnotationDeclaration iAnnotationDeclaration = a = fullyQualified != null ? fullyQualified : fullyQualifiedOnPackage;
        if (a != null) {
            contextClass = this.getStringValue(a);
        }
        if (contextClass == null) {
            contextClass = t == null ? "" : t.getQualifiedName();
        } else if (fullyQualified != null && t != null) {
            String resolved = EclipseJavaUtil.resolveType((IType)t.getType(), (String)contextClass);
            if (resolved != null) {
                contextClass = resolved;
            }
        } else if (fullyQualifiedOnPackage != null) {
            contextClass = p.resolveType(contextClass);
        }
        if ("java.lang.Class".equals(contextClass)) {
            contextClass = t.getType().getFullyQualifiedName();
        }
        return (dot = contextClass.lastIndexOf(46)) < 0 ? "" : contextClass.substring(0, dot);
    }

    private String getSimpleBeanName(AbstractMemberDefinition d, IAnnotationDeclaration named) {
        String simpleName = null;
        if (named != null) {
            simpleName = this.getStringValue(named);
        }
        if (simpleName == null || simpleName.length() <= 0) {
            if (d instanceof TypeDefinition) {
                simpleName = Introspector.decapitalize(((TypeDefinition)d).getType().getElementName());
            } else if (d instanceof FieldDefinition) {
                simpleName = ((FieldDefinition)d).getField().getElementName();
            } else if (d instanceof MethodDefinition) {
                MethodDefinition m = (MethodDefinition)d;
                String mn = m.getMethod().getElementName();
                simpleName = BeanUtil.isGetter((IMethod)m.getMethod()) ? BeanUtil.getPropertyName((String)mn) : mn;
            }
        }
        return simpleName;
    }

    private String getStringValue(IAnnotationDeclaration a) {
        Object o = a.getMemberValue(null);
        return o == null ? null : o.toString();
    }
}

