/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.cdi.core.CDICoreBuilder;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInitializerMethod;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointField;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IInterceptorBinded;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IProducerField;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.ISessionBean;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.core.IStereotyped;
import org.jboss.tools.cdi.core.extension.feature.IBeanKeyProvider;
import org.jboss.tools.cdi.core.extension.feature.IInjectionPointValidatorFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.core.preferences.CDIPreferences;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.CDIProjectAsYouType;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.SessionBean;
import org.jboss.tools.cdi.internal.core.impl.definition.Dependencies;
import org.jboss.tools.cdi.internal.core.validation.AnnotationValidationDelegate;
import org.jboss.tools.cdi.internal.core.validation.BeansXmlValidationDelegate;
import org.jboss.tools.cdi.internal.core.validation.CDIProjectTree;
import org.jboss.tools.cdi.internal.core.validation.CDIValidationErrorManager;
import org.jboss.tools.cdi.internal.core.validation.CDIValidationMessages;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaReference;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.INodeReference;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.EditorValidationContext;
import org.jboss.tools.common.validation.IJavaElementValidator;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IStringValidator;
import org.jboss.tools.common.validation.ITypedReporter;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidationContextManager;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidationUtil;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;

public class CDICoreValidator
extends CDIValidationErrorManager
implements IJavaElementValidator,
IStringValidator {
    public static final String ID = "org.jboss.tools.cdi.core.CoreValidator";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.cdi.ui.preferences.CDIValidatorPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.cdi.ui.propertyPages.CDIValidatorPreferencePage";
    ICDIProject rootCdiProject;
    Map<IProject, CDIValidationContext> cdiContexts = new HashMap<IProject, CDIValidationContext>();
    String rootProjectName;
    IValidatingProjectTree projectTree;
    IValidatingProjectSet projectSet;
    Set<IFolder> sourceFolders;
    List<IFile> allBeansXmls;
    boolean missingBeansXmlValidated;
    private BeansXmlValidationDelegate beansXmlValidator = new BeansXmlValidationDelegate(this);
    private AnnotationValidationDelegate annotationValidator = new AnnotationValidationDelegate(this);
    public static final String SHORT_ID = "jboss.cdi.core";
    private static final String[] RESOURCE_ANNOTATIONS = new String[]{"javax.annotation.Resource", "javax.xml.ws.WebServiceRef", "javax.ejb.EJB", "javax.persistence.PersistenceContext", "javax.persistence.PersistenceUnit"};
    private static final String BUNDLE_NAME = "org.jboss.tools.cdi.internal.core.validation.messages";

    CDIValidationContext getCDIContext(IResource resource) {
        IProject project = resource.getProject();
        CDIValidationContext context = this.cdiContexts.get(project);
        if (context == null) {
            context = new CDIValidationContext(project);
            this.cdiContexts.put(project, context);
        }
        return context;
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return CDICoreBuilder.BUILDER_ID;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        this.projectTree = CDICoreValidator.getProjectTree(project);
        return this.projectTree;
    }

    public static IValidatingProjectTree getProjectTree(IProject project) {
        return new CDIProjectTree(project);
    }

    public boolean isEnabled(IProject project) {
        return CDIPreferences.isValidationEnabled(project);
    }

    public boolean shouldValidate(IProject project) {
        return this.shouldValidate(project, false);
    }

    public boolean shouldValidateAsYouType(IProject project) {
        return this.shouldValidate(project, true);
    }

    public boolean shouldValidate(IProject project, boolean asYouType) {
        try {
            return project.isAccessible() && project.hasNature(CDICoreNature.NATURE_ID) && this.isEnabled(project) && (asYouType || this.validateBuilderOrder(project));
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
            return false;
        }
    }

    private boolean validateBuilderOrder(IProject project) throws CoreException {
        return KBValidator.validateBuilderOrder((IProject)project, (String)this.getBuilderId(), (String)this.getId(), (SeverityPreferences)CDIPreferences.getInstance());
    }

    public void init(IProject rootProject, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(rootProject, validationHelper, context, manager, reporter);
        this.setAsYouTypeValidation(false);
        this.projectTree = validationHelper.getValidationContextManager().getValidatingProjectTree((org.jboss.tools.common.validation.IValidator)this);
        this.projectSet = (IValidatingProjectSet)this.projectTree.getBrunches().get(rootProject);
        this.rootCdiProject = null;
        this.allBeansXmls = null;
        this.missingBeansXmlValidated = false;
        CDICoreNature nature = CDICorePlugin.getCDI(this.projectSet.getRootProject(), true);
        if (nature != null) {
            this.rootCdiProject = nature.getDelegate();
            if (this.rootCdiProject == null) {
                CDICorePlugin.getDefault().logError("Trying to validate " + rootProject + " but CDI Tools model for the project is not built.");
            }
        } else {
            CDICorePlugin.getDefault().logError("Trying to validate " + rootProject + " but there is no CDI Nature in the project.");
        }
        this.rootProjectName = this.projectSet.getRootProject().getName();
        this.cdiContexts.clear();
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.displaySubtask(CDIValidationMessages.SEARCHING_RESOURCES, new String[]{project.getName()});
        if (this.rootCdiProject == null) {
            return this.OK_STATUS;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<IPath> resources = new HashSet<IPath>();
        HashSet<IPath> resourcesToClean = new HashSet<IPath>();
        for (IFile file : changedFiles) {
            resourcesToClean.add(file.getFullPath());
            Set<IPath> dd = this.getCDIContext((IResource)file).getDependencies().getDirectDependencies(file.getFullPath());
            if (dd == null) continue;
            for (IPath p : dd) {
                IFile f = root.getFile(p);
                if (!f.exists() || changedFiles.contains(f)) continue;
                resources.add(p);
                this.collectAllRelatedInjections(f, resources);
            }
        }
        for (IFile currentFile : changedFiles) {
            if (reporter.isCancelled()) break;
            if (!ValidationUtil.checkFileExtensionForJavaAndXml((IFile)currentFile)) continue;
            resources.add(currentFile.getFullPath());
            Set<String> newElNamesOfChangedFile = this.getELNamesByResource(this.getCDIContext((IResource)currentFile), currentFile.getFullPath());
            for (String newElName : newElNamesOfChangedFile) {
                Set linkedResources = this.validationContext.getCoreResourcesByVariableName(SHORT_ID, newElName, true);
                if (linkedResources == null) continue;
                resources.addAll(linkedResources);
            }
            Set oldElNamesOfChangedFile = this.validationContext.getVariableNamesByCoreResource(SHORT_ID, currentFile.getFullPath(), true);
            if (oldElNamesOfChangedFile != null) {
                for (String name : oldElNamesOfChangedFile) {
                    Set linkedResources = this.validationContext.getCoreResourcesByVariableName(SHORT_ID, name, true);
                    if (linkedResources != null) {
                        resources.addAll(linkedResources);
                    }
                    this.validationContext.addVariableNameForELValidation(SHORT_ID, name);
                }
            }
            this.collectAllRealtedCoreResources(currentFile, resources);
            this.collectAllRelatedResourcesFromPackageInfo(currentFile, resources);
        }
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        for (IPath linkedResource : resources) {
            IFile file = root.getFile(linkedResource);
            if (!this.shouldBeValidated(file)) continue;
            IProject pr = file.getProject();
            if (validationHelper.getValidationContextManager().projectHasBeenValidated((org.jboss.tools.common.validation.IValidator)this, pr)) continue;
            filesToValidate.add(file);
        }
        resourcesToClean.addAll(resources);
        this.getValidationContext().removeLinkedCoreResources(SHORT_ID, resourcesToClean);
        for (IFile file : filesToValidate) {
            this.removeAllMessagesFromResource((IResource)file);
        }
        this.validateRemovedFiles(project, context);
        for (IFile file : filesToValidate) {
            this.validateResource(file);
        }
        this.cleanSavedMarkers();
        return this.OK_STATUS;
    }

    private void validateRemovedFiles(IProject project, IProjectValidationContext context) {
        Set files = context.getValidationResourceRegister().getRemovedFiles();
        for (IFile file : files) {
            if (!file.getName().equals("beans.xml")) continue;
            this.validateMissingBeansXml();
            break;
        }
    }

    private void validateMissingBeansXml() {
        if (!this.missingBeansXmlValidated && !this.isAsYouTypeValidation()) {
            List<IFile> beansXmls = this.getAllBeansXmls();
            HashSet<String> projectsWithBeansXml = new HashSet<String>();
            for (IFile beansXml : beansXmls) {
                projectsWithBeansXml.add(beansXml.getProject().getName());
            }
            Set allProjects = this.projectSet.getAllProjects();
            for (IProject project : allProjects) {
                this.removeAllMessagesFromProject(project);
                CDIValidationContext context = this.getCDIContext((IResource)project);
                if (context.getCdiProject().getVersion() != CDIVersion.CDI_1_0 || projectsWithBeansXml.contains(project.getName())) continue;
                this.reportMissingBeansXml(project);
            }
            this.missingBeansXmlValidated = true;
        }
    }

    private void collectAllRealtedCoreResources(IFile validatingResource, Set<IPath> relatedResources) {
        Set oldReletedResources = this.getValidationContext().getVariableNamesByCoreResource(SHORT_ID, validatingResource.getFullPath(), false);
        if (oldReletedResources != null) {
            for (String resourcePath : oldReletedResources) {
                if (!resourcePath.startsWith("/") && !resourcePath.startsWith("\\")) continue;
                relatedResources.add(Path.fromOSString((String)resourcePath));
            }
        }
        this.collectAllRelatedInjections(validatingResource, relatedResources);
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        IResource bindings;
        IResource resource;
        IResource qualifiers;
        IResource resource32;
        IResource stereotypes;
        IResource resource22;
        IBean[] beans;
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        if (this.rootCdiProject == null) {
            return this.OK_STATUS;
        }
        this.displaySubtask(CDIValidationMessages.VALIDATING_PROJECT, new String[]{this.rootProjectName});
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        IBean[] iBeanArray = beans = this.rootCdiProject.getBeans();
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            IBean bean = iBeanArray[n2];
            resource22 = bean.getResource();
            if (resource22 != null && this.shouldValidateType(bean.getBeanClass()) && this.notValidatedYet(resource22)) {
                filesToValidate.add((IFile)resource22);
            }
            ++n2;
        }
        resource22 = stereotypes = this.rootCdiProject.getStereotypes();
        int n3 = ((IResource)resource22).length;
        n = 0;
        while (n < n3) {
            IResource stereotype = resource22[n];
            resource32 = stereotype.getResource();
            if (this.shouldValidateResourceOfElement(resource32) && this.notValidatedYet(resource32)) {
                filesToValidate.add((IFile)resource32);
            }
            ++n;
        }
        resource32 = qualifiers = this.rootCdiProject.getQualifiers();
        int resource22 = ((IResource)resource32).length;
        n3 = 0;
        while (n3 < resource22) {
            IResource qualifier = resource32[n3];
            resource = qualifier.getResource();
            if (this.shouldValidateResourceOfElement(resource) && this.notValidatedYet(resource)) {
                filesToValidate.add((IFile)resource);
            }
            ++n3;
        }
        resource = bindings = this.rootCdiProject.getInterceptorBindings();
        int resource32 = ((IResource)resource).length;
        resource22 = 0;
        while (resource22 < resource32) {
            IResource binding = resource[resource22];
            IResource resource4 = binding.getResource();
            if (this.shouldValidateResourceOfElement(resource4) && this.notValidatedYet(resource4)) {
                filesToValidate.add((IFile)resource4);
            }
            ++resource22;
        }
        for (String scopeName : this.rootCdiProject.getScopeNames()) {
            IScope scope = this.rootCdiProject.getScope(scopeName);
            resource = scope.getResource();
            if (!this.shouldValidateResourceOfElement(resource) || !this.notValidatedYet(resource)) continue;
            filesToValidate.add((IFile)resource);
        }
        List<IFile> beansXmls = this.getAllBeansXmls();
        for (IFile beansXml : beansXmls) {
            if (!this.notValidatedYet((IResource)beansXml)) continue;
            filesToValidate.add(beansXml);
        }
        for (IFile file : filesToValidate) {
            this.removeAllMessagesFromResource((IResource)file);
        }
        for (IFile file : filesToValidate) {
            this.validateResource(file);
        }
        this.validateMissingBeansXml();
        this.cleanSavedMarkers();
        return this.OK_STATUS;
    }

    public static void cleanProject(IProject project) {
        WorkbenchReporter.removeAllMessages((IResource)project, (String[])new String[]{CDICoreValidator.class.getName()}, null);
    }

    public void validate(IValidator validatorManager, IProject rootProject, Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, EditorValidationContext validationContext, IProjectValidationContext projectContext, IFile file) {
        ContextValidationHelper validationHelper = new ContextValidationHelper();
        validationHelper.setProject(rootProject);
        validationHelper.setValidationContextManager((IValidationContextManager)validationContext);
        this.init(rootProject, validationHelper, projectContext, validatorManager, reporter);
        this.setAsYouTypeValidation(true);
        this.document = validationContext.getDocument();
        if (this.rootCdiProject == null) {
            return;
        }
        this.rootCdiProject = new CDIProjectAsYouType(this.rootCdiProject, file);
        this.validateResource(file);
        if (reporter instanceof ITypedReporter) {
            ((ITypedReporter)reporter).addTypeForFile(this.getProblemType());
        }
        this.disableProblemAnnotations(new IRegion(){

            public int getOffset() {
                return 0;
            }

            public int getLength() {
                return CDICoreValidator.this.document.getLength();
            }
        }, reporter);
    }

    private void validateResource(IFile file) {
        if (this.reporter.isCancelled() || !file.isAccessible()) {
            return;
        }
        this.displaySubtask(CDIValidationMessages.VALIDATING_RESOURCE, new String[]{file.getProject().getName(), file.getName()});
        if (!this.isAsYouTypeValidation()) {
            this.coreHelper.getValidationContextManager().addValidatedProject((org.jboss.tools.common.validation.IValidator)this, file.getProject());
            Set<IPath> dd = this.getCDIContext((IResource)file).getDependencies().getDirectDependencies(file.getFullPath());
            if (dd != null && !dd.isEmpty()) {
                HashSet<IPath> resources = new HashSet<IPath>();
                for (IPath p : dd) {
                    IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(p);
                    if (!f.exists()) continue;
                    resources.add(p);
                    this.collectAllRelatedInjections(f, resources);
                }
                for (IPath p : resources) {
                    this.getValidationContext().addLinkedCoreResource(SHORT_ID, p.toString(), file.getFullPath(), false);
                }
            }
        }
        CDIValidationContext context = null;
        ICDIProject cdiProject = null;
        if (this.isAsYouTypeValidation()) {
            context = new CDIValidationContext(file.getProject(), this.rootCdiProject);
            cdiProject = this.rootCdiProject;
        } else {
            context = this.getCDIContext((IResource)file);
            cdiProject = context.getCdiProject();
        }
        if ("beans.xml".equalsIgnoreCase(file.getName())) {
            List<IFile> allBaensXmls;
            this.validateMissingBeansXml();
            if (CDIPreferences.shouldValidateBeansXml(file.getProject()) && (allBaensXmls = this.getAllBeansXmls()).contains(file)) {
                this.beansXmlValidator.validateBeansXml(context, file);
            }
        } else {
            Collection<IBean> beans = cdiProject.getBeans(file.getFullPath());
            for (IBean bean : beans) {
                this.validateBean(context, bean);
            }
            IStereotype stereotype = cdiProject.getStereotype(file.getFullPath());
            this.validateStereotype(stereotype);
            IQualifier qualifier = cdiProject.getQualifier(file.getFullPath());
            this.validateQualifier(qualifier);
            IScope scope = cdiProject.getScope(file.getFullPath());
            this.annotationValidator.validateScopeType(scope);
            IInterceptorBinding binding = cdiProject.getInterceptorBinding(file.getFullPath());
            this.validateInterceptorBinding(binding);
        }
        Set<IValidatorFeature> extensions = context.getExtensions();
        for (IValidatorFeature v : extensions) {
            this.setSeverityPreferences(v.getSeverityPreferences());
            v.validateResource(file, this);
            this.setSeverityPreferences(null);
        }
    }

    private void reportMissingBeansXml(IProject project) {
        this.addProblem(MessageFormat.format(CDIValidationMessages.MISSING_BEANS_XML, project.getName()), CDIPreferences.MISSING_BEANS_XML, new ITextSourceReference(){

            public int getStartPosition() {
                return 0;
            }

            public int getLength() {
                return 0;
            }

            public IResource getResource() {
                return null;
            }
        }, (IResource)project, 54);
    }

    Set<IFolder> getSourceFoldersForProjectsSet() {
        if (this.sourceFolders == null) {
            this.sourceFolders = new HashSet<IFolder>();
            Set projects = this.projectSet.getAllProjects();
            for (IProject project : projects) {
                this.sourceFolders.addAll(EclipseResourceUtil.getSourceFolders((IProject)project));
            }
        }
        return this.sourceFolders;
    }

    private List<IFile> getAllBeansXmls() {
        if (this.allBeansXmls == null) {
            this.allBeansXmls = new ArrayList<IFile>();
            Set<IFolder> sourceFolders = this.getSourceFoldersForProjectsSet();
            for (IFolder source : sourceFolders) {
                IResource beansXml = source.findMember((IPath)new Path("/META-INF/beans.xml"));
                if (!(beansXml instanceof IFile)) continue;
                this.allBeansXmls.add((IFile)beansXml);
            }
            Set allProjects = this.projectSet.getAllProjects();
            for (IProject project : allProjects) {
                IVirtualFile beansXml;
                IVirtualComponent com = ComponentCore.createComponent((IProject)project);
                if (com == null || (beansXml = com.getRootFolder().getFile((IPath)new Path("/WEB-INF/beans.xml"))) == null || !beansXml.getUnderlyingFile().isAccessible()) continue;
                this.allBeansXmls.add(beansXml.getUnderlyingFile());
            }
        }
        return this.allBeansXmls;
    }

    private void validateBean(CDIValidationContext context, IBean bean) {
        if (this.reporter.isCancelled()) {
            return;
        }
        if (!bean.exists() || !this.shouldValidateType(bean.getBeanClass())) {
            return;
        }
        String beanPath = null;
        if (!this.isAsYouTypeValidation()) {
            beanPath = bean.getSourcePath().toString();
            Collection<IScopeDeclaration> scopeDeclarations = bean.getScopeDeclarations();
            for (IScopeDeclaration scopeDeclaration : scopeDeclarations) {
                IScope scope = scopeDeclaration.getScope();
                if (!this.shouldValidateType(scope.getSourceType())) continue;
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, beanPath, scope.getSourcePath(), false);
            }
            this.addLinkedStereotypes(beanPath, bean);
            Collection<IQualifierDeclaration> qualifierDeclarations = bean.getQualifierDeclarations();
            for (IQualifierDeclaration iQualifierDeclaration : qualifierDeclarations) {
                IQualifier qualifier = iQualifierDeclaration.getQualifier();
                if (!this.shouldValidateType(qualifier.getSourceType())) continue;
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, beanPath, qualifier.getSourcePath(), false);
            }
        }
        this.validateTyped(bean);
        this.validateBeanScope(bean);
        this.validateNormalBeanScope(bean);
        if (bean instanceof IProducer) {
            this.validateProducer(context, (IProducer)bean);
        }
        Collection<IInjectionPoint> points = bean instanceof IClassBean ? ((IClassBean)bean).getInjectionPoints(false) : bean.getInjectionPoints();
        for (IInjectionPoint point : points) {
            IType type;
            if (!this.isAsYouTypeValidation() && (type = this.getTypeOfInjection(point)) != null && !type.isBinary()) {
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, beanPath, type.getPath(), false);
            }
            if (!point.exists()) continue;
            this.validateInjectionPoint(context, point);
        }
        if (bean instanceof IInterceptor) {
            this.validateInterceptor((IInterceptor)bean);
        }
        if (bean instanceof IDecorator) {
            this.validateDecorator(context, (IDecorator)bean);
        }
        if (bean instanceof IClassBean) {
            IClassBean classBean = (IClassBean)bean;
            if (!this.isAsYouTypeValidation()) {
                this.addLinkedInterceptorBindings(beanPath, classBean);
                Collection<IBeanMethod> collection = classBean.getAllMethods();
                for (IBeanMethod method : collection) {
                    this.addLinkedStereotypes(beanPath, method);
                    this.addLinkedInterceptorBindings(beanPath, method);
                }
            }
            this.validateClassBean(classBean);
        }
        this.validateSpecializingBean(bean);
        this.validateBeanName(context, bean);
    }

    private void validateBeanName(CDIValidationContext context, IBean bean) {
        String name = bean.getName();
        if (name != null && !name.startsWith("/")) {
            Collection<IBean> beans;
            if (!this.isAsYouTypeValidation()) {
                this.getValidationContext().addVariableNameForELValidation(SHORT_ID, name);
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, name, bean.getSourcePath(), true);
            }
            if ((beans = context.getCdiProject().getBeans(name, true)).size() > 1 && beans.contains(bean)) {
                IBean[] sortedBeans = beans.toArray(new IBean[beans.size()]);
                Arrays.sort(sortedBeans, new Comparator<IBean>(){

                    @Override
                    public int compare(IBean o1, IBean o2) {
                        return o1.getElementName().compareTo(o2.getElementName());
                    }
                });
                ITextSourceReference reference = bean.getNameLocation(true);
                HashSet<String> names = new HashSet<String>();
                String bName = bean.getElementName();
                names.add(bName);
                StringBuffer sb = new StringBuffer(bName);
                IBean[] iBeanArray = sortedBeans;
                int n = sortedBeans.length;
                int n2 = 0;
                while (n2 < n) {
                    IBean iBean = iBeanArray[n2];
                    if (!this.isAsYouTypeValidation()) {
                        this.getValidationContext().addLinkedCoreResource(SHORT_ID, name, iBean.getSourcePath(), true);
                    }
                    bName = iBean.getElementName();
                    if (bean != iBean && !names.contains(bName)) {
                        names.add(bName);
                        sb.append(", ").append(bName);
                    }
                    ++n2;
                }
                this.addProblem(MessageFormat.format(CDIValidationMessages.DUPLCICATE_EL_NAME, sb.toString()), CDIPreferences.AMBIGUOUS_EL_NAMES, reference, bean.getResource());
            } else if (name.indexOf(46) > 0) {
                StringTokenizer st = new StringTokenizer(name, ".", false);
                StringBuffer xName = new StringBuffer();
                while (st.hasMoreTokens()) {
                    String yName;
                    IStatus status;
                    if (xName.length() > 0) {
                        xName.append('.');
                    }
                    xName.append(st.nextToken());
                    if (!st.hasMoreTokens()) continue;
                    String xNameAsString = xName.toString();
                    Collection<IBean> xBeans = context.getCdiProject().getBeans(xNameAsString, true);
                    if (xBeans.isEmpty() || (status = JavaConventions.validateJavaTypeName((String)(yName = name.substring(xNameAsString.length() + 1)), (String)"1.6", (String)"1.6")).getSeverity() == 4) continue;
                    ITextSourceReference reference = bean.getNameLocation(true);
                    if (reference == null) {
                        reference = CDIUtil.getNamedDeclaration(bean);
                    }
                    this.addProblem(MessageFormat.format(CDIValidationMessages.UNRESOLVABLE_EL_NAME, name, yName, xNameAsString, xBeans.iterator().next().getElementName()), CDIPreferences.AMBIGUOUS_EL_NAMES, reference, bean.getResource());
                    break;
                }
            }
        }
    }

    protected boolean shouldCheckDuplicateMarkers() {
        return true;
    }

    private Set<String> getELNamesByResource(CDIValidationContext context, IPath resourcePath) {
        Collection<IBean> beans = context.getCdiProject().getBeans(resourcePath);
        if (beans.isEmpty()) {
            return Collections.emptySet();
        }
        Set<IBeanKeyProvider> ps = context.getCdiProject().getNature().getExtensionManager().getFeatures(IBeanKeyProvider.class);
        HashSet<String> result = new HashSet<String>();
        for (IBean bean : beans) {
            String name = bean.getName();
            if (name != null) {
                result.add(name);
            }
            for (IBeanKeyProvider p : ps) {
                String key = p.getKey(bean);
                if (key == null) continue;
                result.add(key);
            }
        }
        return result;
    }

    private IType getTypeOfInjection(IInjectionPoint injection) {
        IParametedType parametedType = injection.getType();
        return parametedType == null ? null : parametedType.getType();
    }

    private void addLinkedStereotypes(String beanPath, IStereotyped stereotyped) {
        if (!this.isAsYouTypeValidation()) {
            for (IStereotypeDeclaration stereotypeDeclaration : stereotyped.getStereotypeDeclarations()) {
                IStereotype stereotype = stereotypeDeclaration.getStereotype();
                if (!this.shouldValidateType(stereotype.getSourceType())) continue;
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, beanPath, stereotype.getSourcePath(), false);
            }
        }
    }

    private void addLinkedInterceptorBindings(String beanPath, IInterceptorBinded binded) {
        if (!this.isAsYouTypeValidation()) {
            for (IInterceptorBindingDeclaration bindingDeclaration : CDIUtil.getAllInterceptorBindingDeclaratios(binded)) {
                IInterceptorBinding binding = bindingDeclaration.getInterceptorBinding();
                if (!this.shouldValidateType(binding.getSourceType())) continue;
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, beanPath, binding.getSourcePath(), false);
            }
        }
    }

    private void validateClassBean(IClassBean bean) {
        this.validateInitializers(bean);
        this.validateDisposers(bean);
        this.validateObserves(bean);
        if (!(bean instanceof ISessionBean)) {
            this.validateManagedBean(bean);
        } else {
            this.validateSessionBean((ISessionBean)bean);
        }
        this.validateMixedClassBean(bean);
        this.validateConstructors(bean);
        this.validateInterceptorBindings(bean);
    }

    private void validateInterceptorBindings(IClassBean bean) {
        try {
            if (this.hasConflictedInterceptorBindings(bean)) {
                ITextSourceReference reference = CDIUtil.convertToSourceReference(bean.getBeanClass().getNameRange(), bean.getResource(), (IMember)bean.getBeanClass());
                this.addProblem(CDIValidationMessages.CONFLICTING_INTERCEPTOR_BINDINGS, CDIPreferences.CONFLICTING_INTERCEPTOR_BINDINGS, reference, bean.getResource());
            }
            for (IBeanMethod method : bean.getAllMethods()) {
                if (!this.hasConflictedInterceptorBindings(method)) continue;
                ITextSourceReference reference = CDIUtil.convertToSourceReference(method.getMethod().getNameRange(), bean.getResource(), (IMember)method.getMethod());
                this.addProblem(CDIValidationMessages.CONFLICTING_INTERCEPTOR_BINDINGS, CDIPreferences.CONFLICTING_INTERCEPTOR_BINDINGS, reference, bean.getResource());
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    private boolean hasConflictedInterceptorBindings(IInterceptorBinded binded) throws CoreException {
        Collection<IInterceptorBindingDeclaration> declarations = CDIUtil.getAllInterceptorBindingDeclaratios(binded);
        if (declarations.size() > 1) {
            HashMap<String, String> keys = new HashMap<String, String>();
            for (IInterceptorBindingDeclaration declaration : declarations) {
                IType type = declaration.getInterceptorBinding().getSourceType();
                if (type == null) continue;
                String name = type.getFullyQualifiedName();
                String key = CDIProject.getAnnotationDeclarationKey(declaration);
                String anotherKey = (String)keys.get(name);
                if (anotherKey != null) {
                    if (anotherKey.equals(key)) continue;
                    return true;
                }
                keys.put(name, key);
            }
        }
        return false;
    }

    private void validateSpecializingBean(IBean bean) {
        IBean specializedBean;
        IAnnotationDeclaration specializesDeclaration = bean.getSpecializesAnnotationDeclaration();
        if (specializesDeclaration != null) {
            if (bean instanceof IDecorator) {
                this.addProblem(CDIValidationMessages.DECORATOR_ANNOTATED_SPECIALIZES, CDIPreferences.INTERCEPTOR_ANNOTATED_SPECIALIZES, (ITextSourceReference)specializesDeclaration, bean.getResource(), 35);
            } else if (bean instanceof IInterceptor) {
                this.addProblem(CDIValidationMessages.INTERCEPTOR_ANNOTATED_SPECIALIZES, CDIPreferences.INTERCEPTOR_ANNOTATED_SPECIALIZES, (ITextSourceReference)specializesDeclaration, bean.getResource(), 34);
            }
        }
        if ((specializedBean = bean.getSpecializedBean()) != null) {
            IClassBean supperClassBean;
            Collection<? extends IClassBean> allSpecializingBeans;
            IAnnotationDeclaration nameDeclaration;
            if (!this.isAsYouTypeValidation() && this.shouldValidateType(specializedBean.getBeanClass())) {
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, bean.getSourcePath().toString(), specializedBean.getSourcePath(), false);
            }
            String beanClassName = bean.getBeanClass().getElementName();
            String beanName = bean instanceof IBeanMethod ? String.valueOf(beanClassName) + "." + ((IBeanMethod)((Object)bean)).getSourceMember().getElementName() + "()" : beanClassName;
            String specializingBeanClassName = specializedBean.getBeanClass().getElementName();
            String specializingBeanName = specializedBean instanceof IBeanMethod ? String.valueOf(specializingBeanClassName) + "." + ((IBeanMethod)((Object)specializedBean)).getSourceMember().getElementName() + "()" : specializingBeanClassName;
            HashSet<String> legalTypes = new HashSet<String>();
            for (IParametedType type : bean.getLegalTypes()) {
                if (type.getType() == null) continue;
                legalTypes.add(type.getType().getFullyQualifiedName());
            }
            TreeSet<String> missingTypesSet = new TreeSet<String>();
            for (IParametedType specializingType : specializedBean.getLegalTypes()) {
                if (legalTypes.contains(specializingType.getType().getFullyQualifiedName())) continue;
                missingTypesSet.add(specializingType.getType().getElementName());
            }
            StringBuffer missingTypes = new StringBuffer();
            for (String type : missingTypesSet) {
                if (missingTypes.length() > 0) {
                    missingTypes.append(", ");
                }
                missingTypes.append(type);
            }
            if (missingTypes.length() > 0) {
                this.addProblem(CDIValidationMessages.MISSING_TYPE_IN_SPECIALIZING_BEAN, CDIPreferences.MISSING_TYPE_IN_SPECIALIZING_BEAN, new String[]{beanName, specializingBeanName, missingTypes.toString()}, (ITextSourceReference)bean.getSpecializesAnnotationDeclaration(), bean.getResource());
            }
            if (specializedBean.getName() != null && (nameDeclaration = bean.getAnnotation("javax.inject.Named")) != null) {
                this.addProblem(CDIValidationMessages.CONFLICTING_NAME_IN_SPECIALIZING_BEAN, CDIPreferences.CONFLICTING_NAME_IN_SPECIALIZING_BEAN, new String[]{beanName, specializingBeanName}, (ITextSourceReference)nameDeclaration, bean.getResource());
            }
            if (bean.isEnabled() && specializedBean instanceof IClassBean && (allSpecializingBeans = (supperClassBean = (IClassBean)specializedBean).getSpecializingBeans()).size() > 1) {
                TreeSet<String> specializingBeanNames = new TreeSet<String>();
                for (IClassBean iClassBean : allSpecializingBeans) {
                    if (iClassBean == bean || !iClassBean.isEnabled()) continue;
                    specializingBeanNames.add(iClassBean.getElementName());
                    if (this.isAsYouTypeValidation() || !this.shouldValidateType(iClassBean.getBeanClass())) continue;
                    this.getValidationContext().addLinkedCoreResource(SHORT_ID, iClassBean.getSourcePath().toString(), bean.getSourcePath(), false);
                    this.getValidationContext().addLinkedCoreResource(SHORT_ID, bean.getSourcePath().toString(), iClassBean.getSourcePath(), false);
                }
                if (!specializingBeanNames.isEmpty() && specializesDeclaration != null) {
                    StringBuffer stringBuffer = new StringBuffer(bean.getElementName());
                    for (String name : specializingBeanNames) {
                        stringBuffer.append(", ").append(name);
                    }
                    this.addProblem(CDIValidationMessages.INCONSISTENT_SPECIALIZATION, CDIPreferences.INCONSISTENT_SPECIALIZATION, new String[]{stringBuffer.toString(), supperClassBean.getElementName()}, (ITextSourceReference)specializesDeclaration, bean.getResource());
                }
            }
        }
    }

    private void validateConstructors(IClassBean bean) {
        Collection<IBeanMethod> constructors = bean.getBeanConstructors();
        if (constructors.size() > 1) {
            ArrayList<IAnnotationDeclaration> injects = new ArrayList<IAnnotationDeclaration>();
            for (IBeanMethod constructor : constructors) {
                IAnnotationDeclaration inject = constructor.getAnnotation("javax.inject.Inject");
                if (inject == null) continue;
                injects.add(inject);
            }
            if (injects.size() > 1) {
                for (IAnnotationDeclaration inject : injects) {
                    this.addProblem(CDIValidationMessages.MULTIPLE_INJECTION_CONSTRUCTORS, CDIPreferences.MULTIPLE_INJECTION_CONSTRUCTORS, (ITextSourceReference)inject, bean.getResource(), 6);
                }
            }
        }
    }

    private void validateObserves(IClassBean bean) {
        Collection<IBeanMethod> observes = bean.getAllMethods();
        if (observes.isEmpty()) {
            return;
        }
        for (IBeanMethod observer : observes) {
            if (!observer.isObserver()) continue;
            List<IParameter> params = observer.getParameters();
            ArrayList<ITextSourceReference> declarations = new ArrayList<ITextSourceReference>();
            for (IParameter param : params) {
                ICompilationUnit unit;
                IJavaSourceReference declaration = param.getAnnotationPosition("javax.enterprise.event.Observes");
                if (declaration == null) continue;
                declarations.add((ITextSourceReference)declaration);
                if (bean.getScope() == null || !"javax.enterprise.context.Dependent".equals(bean.getScope().getSourceType().getFullyQualifiedName()) || (unit = observer.getMethod().getCompilationUnit()) == null) continue;
                try {
                    String source = unit.getSource();
                    ISourceRange unitRange = unit.getSourceRange();
                    int start = declaration.getStartPosition() - unitRange.getOffset();
                    int end = start + declaration.getLength();
                    int position = source.substring(start, end).indexOf("IF_EXISTS");
                    if (position <= 11) continue;
                    this.addProblem(CDIValidationMessages.ILLEGAL_CONDITIONAL_OBSERVER, CDIPreferences.ILLEGAL_CONDITIONAL_OBSERVER, (ITextSourceReference)declaration, bean.getResource());
                }
                catch (JavaModelException e) {
                    CDICorePlugin.getDefault().logError(e);
                }
            }
            if (declarations.size() > 1) {
                for (ITextSourceReference declaration : declarations) {
                    this.addProblem(CDIValidationMessages.MULTIPLE_OBSERVING_PARAMETERS, CDIPreferences.MULTIPLE_OBSERVING_PARAMETERS, declaration, bean.getResource(), 53);
                }
            }
            IAnnotationDeclaration injectDeclaration = observer.getAnnotation("javax.inject.Inject");
            try {
                if (injectDeclaration != null) {
                    String pref = observer.getMethod().isConstructor() ? CDIPreferences.CONSTRUCTOR_PARAMETER_ILLEGALLY_ANNOTATED : CDIPreferences.OBSERVER_ANNOTATED_INJECT;
                    String message = observer.getMethod().isConstructor() ? CDIValidationMessages.CONSTRUCTOR_PARAMETER_ANNOTATED_OBSERVES : CDIValidationMessages.OBSERVER_ANNOTATED_INJECT;
                    int messageId = observer.getMethod().isConstructor() ? 24 : 22;
                    this.addProblem(message, pref, (ITextSourceReference)injectDeclaration, bean.getResource(), messageId);
                    for (ITextSourceReference declaration : declarations) {
                        this.addProblem(message, pref, declaration, bean.getResource(), messageId);
                    }
                }
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
            }
            if (bean instanceof IDecorator) {
                for (ITextSourceReference declaration : declarations) {
                    this.addProblem(CDIValidationMessages.OBSERVER_IN_DECORATOR, CDIPreferences.OBSERVER_IN_INTERCEPTOR_OR_DECORATOR, declaration, bean.getResource(), 39);
                }
            } else if (bean instanceof IInterceptor) {
                for (ITextSourceReference declaration : declarations) {
                    this.addProblem(CDIValidationMessages.OBSERVER_IN_INTERCEPTOR, CDIPreferences.OBSERVER_IN_INTERCEPTOR_OR_DECORATOR, declaration, bean.getResource(), 40);
                }
            }
            this.validateSessionBeanMethod(bean, observer, declarations, CDIValidationMessages.ILLEGAL_OBSERVER_IN_SESSION_BEAN, CDIPreferences.ILLEGAL_OBSERVER_IN_SESSION_BEAN, 4);
        }
    }

    private void validateDisposers(IClassBean bean) {
        Collection<IBeanMethod> disposers = bean.getDisposers();
        if (disposers.isEmpty()) {
            return;
        }
        HashSet<IBeanMethod> boundDisposers = new HashSet<IBeanMethod>();
        for (IProducer producer : bean.getProducers()) {
            if (!(producer instanceof IProducerMethod) || !producer.exists()) continue;
            IProducerMethod producerMethod = (IProducerMethod)producer;
            Collection<IBeanMethod> disposerMethods = producer.getCDIProject().resolveDisposers(producerMethod);
            boundDisposers.addAll(disposerMethods);
            if (disposerMethods.size() <= 1) continue;
            for (IBeanMethod disposerMethod : disposerMethods) {
                Collection<ITextSourceReference> collection = CDIUtil.getAnnotationPossitions(disposerMethod, "javax.enterprise.inject.Disposes");
                for (ITextSourceReference iTextSourceReference : collection) {
                    this.addProblem(CDIValidationMessages.MULTIPLE_DISPOSERS_FOR_PRODUCER, CDIPreferences.MULTIPLE_DISPOSERS_FOR_PRODUCER, iTextSourceReference, bean.getResource(), 5);
                }
            }
        }
        for (IBeanMethod disposer : disposers) {
            if (!disposer.exists()) continue;
            List<IParameter> params = disposer.getParameters();
            ArrayList<ITextSourceReference> disposerDeclarations = new ArrayList<ITextSourceReference>();
            for (IParameter param : params) {
                IJavaSourceReference iJavaSourceReference = param.getAnnotationPosition("javax.enterprise.inject.Disposes");
                if (iJavaSourceReference == null || !param.exists()) continue;
                disposerDeclarations.add((ITextSourceReference)iJavaSourceReference);
            }
            if (disposerDeclarations.size() > 1) {
                for (ITextSourceReference declaration : disposerDeclarations) {
                    this.addProblem(CDIValidationMessages.MULTIPLE_DISPOSING_PARAMETERS, CDIPreferences.MULTIPLE_DISPOSING_PARAMETERS, declaration, bean.getResource(), 52);
                }
            }
            ArrayList<Object> declarations = new ArrayList<Object>();
            boolean observesExists = false;
            declarations.addAll(disposerDeclarations);
            for (IParameter iParameter : params) {
                IJavaSourceReference declaration = iParameter.getAnnotationPosition("javax.enterprise.event.Observes");
                if (declaration == null || !iParameter.exists()) continue;
                declarations.add(declaration);
                observesExists = true;
            }
            if (observesExists) {
                for (ITextSourceReference iTextSourceReference : declarations) {
                    this.addProblem(CDIValidationMessages.OBSERVER_PARAMETER_ILLEGALLY_ANNOTATED, CDIPreferences.OBSERVER_PARAMETER_ILLEGALLY_ANNOTATED, iTextSourceReference, bean.getResource(), 38);
                }
            }
            IAnnotationDeclaration iAnnotationDeclaration = disposer.getAnnotation("javax.inject.Inject");
            try {
                if (iAnnotationDeclaration != null) {
                    String string = disposer.getMethod().isConstructor() ? CDIPreferences.CONSTRUCTOR_PARAMETER_ILLEGALLY_ANNOTATED : CDIPreferences.DISPOSER_ANNOTATED_INJECT;
                    String message = disposer.getMethod().isConstructor() ? CDIValidationMessages.CONSTRUCTOR_PARAMETER_ANNOTATED_DISPOSES : CDIValidationMessages.DISPOSER_ANNOTATED_INJECT;
                    int messageId = disposer.getMethod().isConstructor() ? 25 : 23;
                    this.addProblem(message, string, (ITextSourceReference)iAnnotationDeclaration, bean.getResource(), messageId);
                    for (ITextSourceReference declaration : disposerDeclarations) {
                        this.addProblem(message, string, declaration, bean.getResource(), messageId);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                CDICorePlugin.getDefault().logError(javaModelException);
            }
            this.validateSessionBeanMethod(bean, disposer, disposerDeclarations, CDIValidationMessages.ILLEGAL_DISPOSER_IN_SESSION_BEAN, CDIPreferences.ILLEGAL_DISPOSER_IN_SESSION_BEAN, 3);
            if (bean instanceof IDecorator) {
                IDecorator iDecorator = (IDecorator)bean;
                IAnnotationDeclaration decoratorDeclaration = iDecorator.getDecoratorAnnotation();
                if (decoratorDeclaration == null) {
                    decoratorDeclaration = iDecorator.getNameLocation(true);
                }
                this.addProblem(CDIValidationMessages.DISPOSER_IN_DECORATOR, CDIPreferences.DISPOSER_IN_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)decoratorDeclaration, bean.getResource(), 29);
                for (ITextSourceReference declaration : disposerDeclarations) {
                    this.addProblem(CDIValidationMessages.DISPOSER_IN_DECORATOR, CDIPreferences.DISPOSER_IN_INTERCEPTOR_OR_DECORATOR, declaration, bean.getResource(), 29);
                }
            }
            if (bean instanceof IInterceptor) {
                IInterceptor iInterceptor = (IInterceptor)bean;
                IAnnotationDeclaration interceptorDeclaration = iInterceptor.getInterceptorAnnotation();
                if (interceptorDeclaration == null) {
                    interceptorDeclaration = iInterceptor.getNameLocation(true);
                }
                this.addProblem(CDIValidationMessages.DISPOSER_IN_INTERCEPTOR, CDIPreferences.DISPOSER_IN_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)interceptorDeclaration, bean.getResource(), 28);
                for (ITextSourceReference declaration : disposerDeclarations) {
                    this.addProblem(CDIValidationMessages.DISPOSER_IN_INTERCEPTOR, CDIPreferences.DISPOSER_IN_INTERCEPTOR_OR_DECORATOR, declaration, bean.getResource(), 28);
                }
            }
            if (boundDisposers.contains(disposer)) continue;
            for (ITextSourceReference iTextSourceReference : disposerDeclarations) {
                this.addProblem(CDIValidationMessages.NO_PRODUCER_MATCHING_DISPOSER, CDIPreferences.NO_PRODUCER_MATCHING_DISPOSER, iTextSourceReference, bean.getResource());
            }
        }
    }

    private void validateSessionBeanMethod(IClassBean bean, IBeanMethod method, Collection<ITextSourceReference> annotatedParams, String errorMessage, String preferencesKey, int id) {
        if (bean instanceof ISessionBean && annotatedParams != null) {
            IMethod iMethod = CDIUtil.getBusinessMethodDeclaration((SessionBean)bean, method);
            if (iMethod == null) {
                this.saveAllSuperTypesAsLinkedResources(bean);
                for (ITextSourceReference declaration : annotatedParams) {
                    String bindedErrorMessage = NLS.bind((String)errorMessage, (Object[])new String[]{method.getMethod().getElementName(), bean.getBeanClass().getElementName()});
                    this.addProblem(bindedErrorMessage, preferencesKey, declaration, bean.getResource(), id);
                }
            } else if (!this.isAsYouTypeValidation() && iMethod != method.getMethod() && !iMethod.isBinary()) {
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, bean.getSourcePath().toString(), iMethod.getResource().getFullPath(), false);
            }
        }
    }

    private void validateProducer(CDIValidationContext context, IProducer producer) {
        block39: {
            try {
                IAnnotationDeclaration sDeclaration;
                IClassBean classBean;
                String string;
                String typeString;
                IAnnotationDeclaration inject;
                int n;
                Collection<ITypeDeclaration> typeDeclarations = producer.getAllTypeDeclarations();
                String[] typeVariables = producer.getBeanClass().getTypeParameterSignatures();
                ITypeDeclaration typeDeclaration = null;
                ITextSourceReference typeDeclarationReference = null;
                if (!typeDeclarations.isEmpty()) {
                    typeDeclaration = typeDeclarations.iterator().next();
                    typeDeclarationReference = CDIUtil.convertToJavaSourceReference((ITextSourceReference)typeDeclaration, producer.getSourceMember());
                    String[] paramTypes = Signature.getTypeArguments((String)typeDeclaration.getSignature());
                    boolean variable = false;
                    String[] stringArray = paramTypes;
                    n = paramTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String paramType = stringArray[n2];
                        if (Signature.getTypeSignatureKind((String)paramType) == 5) {
                            if (producer instanceof IProducerField) {
                                this.addProblem(CDIValidationMessages.PRODUCER_FIELD_TYPE_HAS_WILDCARD, CDIPreferences.PRODUCER_METHOD_RETURN_TYPE_HAS_WILDCARD_OR_VARIABLE, typeDeclarationReference, producer.getResource());
                            } else {
                                this.addProblem(CDIValidationMessages.PRODUCER_METHOD_RETURN_TYPE_HAS_WILDCARD, CDIPreferences.PRODUCER_METHOD_RETURN_TYPE_HAS_WILDCARD_OR_VARIABLE, typeDeclarationReference, producer.getResource());
                            }
                        } else if (!variable && this.isTypeVariable(producer, Signature.toString((String)paramType), typeVariables)) {
                            variable = true;
                            IAnnotationDeclaration iAnnotationDeclaration = CDIUtil.getDifferentScopeDeclarationThanDepentend(producer);
                            if (iAnnotationDeclaration == null) break;
                            boolean field = producer instanceof IProducerField;
                            this.addProblem(field ? CDIValidationMessages.ILLEGAL_SCOPE_FOR_PRODUCER_FIELD : CDIValidationMessages.ILLEGAL_SCOPE_FOR_PRODUCER_METHOD, field ? CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN : CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN, (ITextSourceReference)iAnnotationDeclaration, producer.getResource());
                            break;
                        }
                        ++n2;
                    }
                }
                if ((inject = producer.getAnnotation("javax.inject.Inject")) != null) {
                    this.addProblem(CDIValidationMessages.PRODUCER_ANNOTATED_INJECT, CDIPreferences.PRODUCER_ANNOTATED_INJECT, (ITextSourceReference)inject, inject.getResource() != null ? inject.getResource() : producer.getResource(), 21);
                }
                if (producer instanceof IProducerField) {
                    IProducerField producerField = (IProducerField)producer;
                    if (producerField.getName() != null) {
                        String[] stringArray = RESOURCE_ANNOTATIONS;
                        int n3 = RESOURCE_ANNOTATIONS.length;
                        n = 0;
                        while (n < n3) {
                            String annotationType = stringArray[n];
                            IAnnotationDeclaration declaration = producerField.getAnnotation(annotationType);
                            if (declaration != null) {
                                IAnnotationDeclaration nameDeclaration = producerField.getAnnotation("javax.inject.Named");
                                if (nameDeclaration != null) {
                                    declaration = nameDeclaration;
                                }
                                this.addProblem(CDIValidationMessages.RESOURCE_PRODUCER_FIELD_SETS_EL_NAME, CDIPreferences.RESOURCE_PRODUCER_FIELD_SETS_EL_NAME, (ITextSourceReference)declaration, producer.getResource());
                            }
                            ++n;
                        }
                    }
                    if (typeVariables.length > 0) {
                        String typeSign2 = producerField.getField().getTypeSignature();
                        String typeString2 = Signature.toString((String)typeSign2);
                        String[] nameDeclaration = typeVariables;
                        int n2 = typeVariables.length;
                        int n4 = 0;
                        while (n4 < n2) {
                            String variableSig = nameDeclaration[n4];
                            String variableName = Signature.getTypeVariable((String)variableSig);
                            if (typeString2.equals(variableName)) {
                                this.addProblem(CDIValidationMessages.PRODUCER_FIELD_TYPE_IS_VARIABLE, CDIPreferences.PRODUCER_METHOD_RETURN_TYPE_HAS_WILDCARD_OR_VARIABLE, (ITextSourceReference)(typeDeclaration != null ? typeDeclarationReference : producer), producer.getResource());
                            }
                            ++n4;
                        }
                    }
                    if (producer.getClassBean() instanceof ISessionBean && !Flags.isStatic((int)producerField.getField().getFlags())) {
                        this.addProblem(CDIValidationMessages.ILLEGAL_PRODUCER_FIELD_IN_SESSION_BEAN, CDIPreferences.ILLEGAL_PRODUCER_METHOD_IN_SESSION_BEAN, (ITextSourceReference)producer.getProducesAnnotation(), producer.getResource(), 1);
                    }
                    break block39;
                }
                IProducerMethod producerMethod = (IProducerMethod)producer;
                List<IParameter> params = producerMethod.getParameters();
                ArrayList<Object> observesDeclarations = new ArrayList<Object>();
                ArrayList<Object> disposalDeclarations = new ArrayList<Object>();
                IAnnotationDeclaration producesDeclaration = producerMethod.getAnnotation("javax.enterprise.inject.Produces");
                if (producesDeclaration != null) {
                    observesDeclarations.add(producesDeclaration);
                    disposalDeclarations.add(producesDeclaration);
                }
                for (IParameter iParameter : params) {
                    IJavaSourceReference declaration = iParameter.getAnnotationPosition("javax.enterprise.inject.Disposes");
                    if (declaration != null) {
                        disposalDeclarations.add(declaration);
                    }
                    if ((declaration = iParameter.getAnnotationPosition("javax.enterprise.event.Observes")) == null) continue;
                    observesDeclarations.add(declaration);
                }
                if (observesDeclarations.size() > 1) {
                    for (ITextSourceReference iTextSourceReference : observesDeclarations) {
                        this.addProblem(CDIValidationMessages.PRODUCER_PARAMETER_ILLEGALLY_ANNOTATED_OBSERVES, CDIPreferences.PRODUCER_PARAMETER_ILLEGALLY_ANNOTATED, iTextSourceReference, producer.getResource(), 37);
                    }
                }
                if (disposalDeclarations.size() > 1) {
                    for (ITextSourceReference iTextSourceReference : disposalDeclarations) {
                        this.addProblem(CDIValidationMessages.PRODUCER_PARAMETER_ILLEGALLY_ANNOTATED_DISPOSES, CDIPreferences.PRODUCER_PARAMETER_ILLEGALLY_ANNOTATED, iTextSourceReference, producer.getResource(), 36);
                    }
                }
                if (this.isTypeVariable(producerMethod, typeString = Signature.toString((String)(string = producerMethod.getMethod().getReturnType())), typeVariables)) {
                    this.addProblem(CDIValidationMessages.PRODUCER_METHOD_RETURN_TYPE_IS_VARIABLE, CDIPreferences.PRODUCER_METHOD_RETURN_TYPE_HAS_WILDCARD_OR_VARIABLE, (ITextSourceReference)(typeDeclaration != null ? typeDeclarationReference : producer), producer.getResource());
                }
                if ((classBean = producer.getClassBean()) instanceof ISessionBean) {
                    IMethod method = CDIUtil.getBusinessMethodDeclaration((SessionBean)classBean, producerMethod);
                    if (method == null) {
                        String bindedErrorMessage = NLS.bind((String)CDIValidationMessages.ILLEGAL_PRODUCER_METHOD_IN_SESSION_BEAN, (Object[])new String[]{producerMethod.getMethod().getElementName(), producer.getBeanClass().getElementName()});
                        this.addProblem(bindedErrorMessage, CDIPreferences.ILLEGAL_PRODUCER_METHOD_IN_SESSION_BEAN, (ITextSourceReference)producer.getProducesAnnotation(), producer.getResource(), 2);
                        this.saveAllSuperTypesAsLinkedResources(classBean);
                    } else if (!this.isAsYouTypeValidation() && method != producerMethod.getMethod() && method.exists() && !method.isReadOnly()) {
                        this.getValidationContext().addLinkedCoreResource(SHORT_ID, classBean.getSourcePath().toString(), method.getResource().getFullPath(), false);
                    }
                }
                if ((sDeclaration = producerMethod.getSpecializesAnnotationDeclaration()) == null) break block39;
                if (Flags.isStatic((int)producerMethod.getMethod().getFlags())) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_PRODUCER_STATIC, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)sDeclaration, producer.getResource());
                    break block39;
                }
                IMethod superMethod = CDIUtil.getDirectOverridingMethodDeclaration(producerMethod);
                boolean overrides = false;
                if (superMethod != null) {
                    IType superType = superMethod.getDeclaringType();
                    if (superType.isBinary()) {
                        IAnnotation[] ants;
                        IAnnotation[] iAnnotationArray = ants = superMethod.getAnnotations();
                        int n3 = ants.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IAnnotation an = iAnnotationArray[n4];
                            if ("javax.enterprise.inject.Produces".equals(an.getElementName())) {
                                overrides = true;
                            }
                            ++n4;
                        }
                    } else {
                        Collection<IBean> beans = context.getCdiProject().getBeans(superType.getResource().getFullPath());
                        for (IBean iBean : beans) {
                            IProducerMethod prMethod;
                            if (!(iBean instanceof IProducerMethod) || !(prMethod = (IProducerMethod)iBean).getMethod().isSimilar(superMethod)) continue;
                            overrides = true;
                        }
                    }
                }
                if (!overrides) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_PRODUCER_OVERRIDE, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)sDeclaration, producer.getResource());
                }
                this.saveAllSuperTypesAsLinkedResources(producer.getClassBean());
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
            }
        }
    }

    private boolean isTypeVariable(IProducer producer, String type, String[] typeVariables) throws JavaModelException {
        int n;
        if (producer instanceof IProducerMethod) {
            ITypeParameter[] paramTypes;
            ITypeParameter[] iTypeParameterArray = paramTypes = ((IProducerMethod)producer).getMethod().getTypeParameters();
            int n2 = paramTypes.length;
            n = 0;
            while (n < n2) {
                ITypeParameter param = iTypeParameterArray[n];
                String variableName = param.getElementName();
                if (variableName.equals(type)) {
                    return true;
                }
                ++n;
            }
        }
        if (typeVariables.length > 0) {
            String[] stringArray = typeVariables;
            n = typeVariables.length;
            int n3 = 0;
            while (n3 < n) {
                String variableSig = stringArray[n3];
                String variableName = Signature.getTypeVariable((String)variableSig);
                if (type.equals(variableName)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private void saveAllSuperTypesAsLinkedResources(IBean bean) {
        if (!this.isAsYouTypeValidation()) {
            for (IParametedType type : bean.getAllTypes()) {
                IType superType = type.getType();
                if (superType == null || superType.isBinary() || superType.getResource() == null || superType == bean.getBeanClass()) continue;
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, bean.getSourcePath().toString(), superType.getResource().getFullPath(), false);
            }
        }
    }

    private void collectAllRelatedInjections(IFile validatingResource, Set<IPath> relatedResources) {
        if (!this.asYouTypeValidation) {
            CDIValidationContext context = this.getCDIContext((IResource)validatingResource);
            ICDIProject cdiProject = context.getCdiProject();
            this.collectAllRelatedInjectionsForBean(validatingResource, relatedResources);
            if ("beans.xml".equals(validatingResource.getName().toLowerCase())) {
                List<INodeReference> nodes = cdiProject.getAlternativeClasses();
                this.collectAllRelatedInjectionsForNode(nodes, relatedResources);
                nodes = cdiProject.getDecoratorClasses();
                this.collectAllRelatedInjectionsForNode(nodes, relatedResources);
                nodes = cdiProject.getInterceptorClasses();
                this.collectAllRelatedInjectionsForNode(nodes, relatedResources);
                Set<IPath> dd = this.getCDIContext((IResource)validatingResource).getDependencies().getDirectDependencies(validatingResource.getFullPath());
                if (dd != null) {
                    relatedResources.addAll(dd);
                }
            }
        }
    }

    private void collectAllRelatedResourcesFromPackageInfo(IFile validatingResource, Set<IPath> relatedResources) {
        if ("package-info.java".equals(validatingResource.getName())) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = validatingResource.getParent().members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IFile && validatingResource != member && "java".equalsIgnoreCase(member.getFileExtension())) {
                        IFile file = (IFile)member;
                        relatedResources.add(file.getFullPath());
                        this.collectAllRealtedCoreResources(file, relatedResources);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                CDICorePlugin.getDefault().logError(e);
            }
        }
    }

    private void collectAllRelatedInjectionsForNode(List<INodeReference> nodes, Set<IPath> relatedResources) {
        try {
            for (INodeReference node : nodes) {
                String className = node.getValue();
                IType type = EclipseJavaUtil.findType((IJavaProject)this.beansXmlValidator.getJavaProject(node.getResource()), (String)className);
                if (type == null || type.isBinary()) continue;
                IResource resource = type.getResource();
                if (type == null || !(resource instanceof IFile)) continue;
                this.collectAllRelatedInjectionsForBean((IFile)resource, relatedResources);
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    void collectAllRelatedInjectionsForBean(IFile validatingResource, Set<IPath> relatedResources) {
        block6: {
            ICompilationUnit unit;
            ICDIProject cdiProject;
            block7: {
                if (this.asYouTypeValidation) break block6;
                CDIValidationContext context = this.getCDIContext((IResource)validatingResource);
                cdiProject = context.getCdiProject();
                Collection<IBean> beans = cdiProject.getBeans(validatingResource.getFullPath());
                if (beans.isEmpty()) break block7;
                for (IBean bean : beans) {
                    for (IParametedType type : bean.getAllTypes()) {
                        IType superType = type.getType();
                        if (superType == null) continue;
                        this.collectAllRelatedInjectionsForType(cdiProject, superType, bean, relatedResources);
                    }
                }
                break block6;
            }
            if (!validatingResource.getName().toLowerCase().endsWith(".java") || (unit = EclipseUtil.getCompilationUnit((IFile)validatingResource)) == null) break block6;
            try {
                IType[] types;
                IType[] iTypeArray = types = unit.getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    ParametedType parametedType = ((CDIProject)cdiProject).getNature().getTypeFactory().newParametedType(type);
                    Collection allTypes = parametedType.getAllTypes();
                    for (IParametedType iParametedType : allTypes) {
                        IType t = iParametedType.getType();
                        if (t == null) continue;
                        this.collectAllRelatedInjectionsForType(cdiProject, t, null, relatedResources);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
            }
        }
    }

    private void collectAllRelatedInjectionsForType(ICDIProject cdiProject, IType type, IBean bean, Set<IPath> relatedResources) {
        for (IInjectionPoint injection : cdiProject.getInjections(type.getFullyQualifiedName())) {
            if (injection.getClassBean().getBeanClass().isBinary() || injection.getClassBean() == bean) continue;
            relatedResources.add(injection.getSourcePath());
        }
    }

    private boolean shouldIgnoreInjection(CDIValidationContext context, IType typeOfInjectionPoint, IInjectionPoint injection) {
        for (IInjectionPointValidatorFeature feature : context.getInjectionValidationFeatures()) {
            if (!feature.shouldIgnoreInjection(typeOfInjectionPoint, injection)) continue;
            return true;
        }
        return false;
    }

    private void validateInitializers(IClassBean bean) {
        for (IInitializerMethod initializer : bean.getInitializers()) {
            this.validateInitializerMethod(initializer);
        }
    }

    private void validateInitializerMethod(IInitializerMethod initializer) {
        IAnnotationDeclaration named = initializer.getAnnotation("javax.inject.Named");
        if (named != null) {
            boolean valueExists;
            boolean bl = valueExists = named.getMemberValue(null) != null;
            if (!valueExists) {
                this.addProblem(CDIValidationMessages.PARAM_INJECTION_DECLARES_EMPTY_NAME, CDIPreferences.PARAM_INJECTION_DECLARES_EMPTY_NAME, (ITextSourceReference)named, initializer.getResource(), 51);
            }
        }
        IAnnotationDeclaration declaration = initializer.getInjectAnnotation();
        if (CDIUtil.isMethodGeneric(initializer)) {
            this.addProblem(CDIValidationMessages.GENERIC_METHOD_ANNOTATED_INJECT, CDIPreferences.GENERIC_METHOD_ANNOTATED_INJECT, (ITextSourceReference)declaration, initializer.getResource());
        }
        if (CDIUtil.isMethodStatic(initializer)) {
            this.addProblem(CDIValidationMessages.STATIC_METHOD_ANNOTATED_INJECT, CDIPreferences.GENERIC_METHOD_ANNOTATED_INJECT, (ITextSourceReference)declaration, initializer.getResource());
        }
    }

    private void validateInjectionPoint(CDIValidationContext context, IInjectionPoint injection) {
        Object declaration;
        IAnnotationDeclaration named;
        ICDIProject cdiProject = context.getCdiProject();
        if (injection instanceof IInjectionPointParameter && injection.isAnnotationPresent("javax.enterprise.inject.Disposes")) {
            return;
        }
        if (injection instanceof IInjectionPointParameter && (named = injection.getAnnotation("javax.inject.Named")) != null) {
            boolean valueExists;
            Object value = named.getMemberValue(null);
            boolean bl = valueExists = value != null && value.toString().trim().length() > 0;
            if (!valueExists) {
                this.addProblem(CDIValidationMessages.PARAM_INJECTION_DECLARES_EMPTY_NAME, CDIPreferences.PARAM_INJECTION_DECLARES_EMPTY_NAME, (ITextSourceReference)named, injection.getResource(), 51);
            }
        }
        if ((declaration = injection.getInjectAnnotation()) == null && injection instanceof IInjectionPointParameter) {
            declaration = injection;
        }
        if (CDIUtil.isTypeVariable(injection, false)) {
            this.addProblem(CDIValidationMessages.INJECTION_TYPE_IS_VARIABLE, CDIPreferences.INJECTION_TYPE_IS_VARIABLE, (ITextSourceReference)declaration, injection.getResource());
        }
        if (declaration != null) {
            IType type;
            IInjectionPoint reference;
            block44: {
                Collection<IBean> beans = cdiProject.getBeans(true, injection);
                reference = injection instanceof IInjectionPointParameter ? injection : declaration;
                type = this.getTypeOfInjection(injection);
                if (!this.shouldIgnoreInjection(context, type, injection)) {
                    boolean instance;
                    boolean bl = instance = type != null && "javax.enterprise.inject.Instance".equals(type.getFullyQualifiedName());
                    if (!this.isAsYouTypeValidation()) {
                        String injectionFilePath = injection.getSourcePath().toString();
                        for (IBean bean : cdiProject.getBeans(false, injection)) {
                            if (!this.shouldValidateType(bean.getBeanClass())) continue;
                            try {
                                this.getValidationContext().addLinkedCoreResource(SHORT_ID, injectionFilePath, bean.getSourcePath(), false);
                            }
                            catch (NullPointerException e) {
                                throw new RuntimeException("bean exists=" + bean.getBeanClass().exists() + " resource= " + bean.getResource() + " injection= " + injection.getSourcePath(), e);
                            }
                            for (IParametedType parametedType : bean.getAllTypes()) {
                                IType beanType = parametedType.getType();
                                if (beanType == null || beanType.isBinary()) continue;
                                this.getValidationContext().addLinkedCoreResource(SHORT_ID, injectionFilePath, beanType.getPath(), false);
                            }
                        }
                    }
                    if (type != null && beans.isEmpty() && !instance) {
                        this.addProblem(CDIValidationMessages.UNSATISFIED_INJECTION_POINTS, CDIPreferences.UNSATISFIED_OR_AMBIGUOUS_INJECTION_POINTS, (ITextSourceReference)reference, injection.getResource(), 7);
                    } else if (beans.size() > 1 && !instance) {
                        this.addProblem(CDIValidationMessages.AMBIGUOUS_INJECTION_POINTS, CDIPreferences.UNSATISFIED_OR_AMBIGUOUS_INJECTION_POINTS, (ITextSourceReference)reference, injection.getResource(), 8);
                    } else if (beans.size() == 1) {
                        int n;
                        IMethod[] methods;
                        IBean bean = beans.iterator().next();
                        if (cdiProject.getVersion() == CDIVersion.CDI_1_0 && bean.isNullable() && injection.getType() != null && injection.getType().isPrimitive()) {
                            this.addProblem(CDIValidationMessages.INJECT_RESOLVES_TO_NULLABLE_BEAN, CDIPreferences.INJECT_RESOLVES_TO_NULLABLE_BEAN, (ITextSourceReference)reference, injection.getResource());
                        }
                        if (bean.getScope() != null && bean.getScope().isNorlmalScope() && injection.getType() != null) {
                            String typeSignature = injection.getType().getSignature();
                            int kind = Signature.getTypeSignatureKind((String)typeSignature);
                            if (kind == 4) {
                                this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_ARRAY_TYPE, injection.getType().getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, (ITextSourceReference)reference, injection.getResource());
                            } else if (injection.getType().isPrimitive()) {
                                this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_PRIMITIVE_TYPE, injection.getType().getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, (ITextSourceReference)reference, injection.getResource());
                            } else if (injection.getType().getType().exists()) {
                                try {
                                    if (Flags.isFinal((int)injection.getType().getType().getFlags())) {
                                        this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_FINAL_TYPE, injection.getType().getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, (ITextSourceReference)reference, injection.getResource());
                                    } else {
                                        methods = injection.getType().getType().getMethods();
                                        boolean hasDefaultConstructor = false;
                                        boolean hasConstructor = false;
                                        IMethod[] iMethodArray = methods;
                                        int n2 = methods.length;
                                        n = 0;
                                        while (n < n2) {
                                            IMethod method = iMethodArray[n];
                                            hasConstructor = hasConstructor || method.isConstructor();
                                            boolean bl2 = hasDefaultConstructor = hasDefaultConstructor || method.isConstructor() && !Flags.isPrivate((int)method.getFlags()) && method.getParameterNames().length == 0;
                                            if (Flags.isFinal((int)method.getFlags())) {
                                                this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_TYPE_WITH_FM, injection.getType().getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, (ITextSourceReference)reference, injection.getResource());
                                                hasDefaultConstructor = true;
                                                break;
                                            }
                                            ++n;
                                        }
                                        if (!hasDefaultConstructor && hasConstructor) {
                                            this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_TYPE_WITH_NPC, injection.getType().getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, (ITextSourceReference)reference, injection.getResource());
                                        }
                                    }
                                }
                                catch (JavaModelException e) {
                                    CDICorePlugin.getDefault().logError(e);
                                }
                            }
                        }
                        if (injection.getClassBean() instanceof IDecorator && injection.isDelegate() && bean instanceof IClassBean && bean.getBeanClass().exists()) {
                            try {
                                IType beanClass = bean.getBeanClass();
                                if (Flags.isFinal((int)beanClass.getFlags())) {
                                    this.addProblem(MessageFormat.format(CDIValidationMessages.DECORATOR_RESOLVES_TO_FINAL_CLASS, bean.getElementName()), CDIPreferences.DECORATOR_RESOLVES_TO_FINAL_BEAN, (ITextSourceReference)reference, injection.getResource());
                                    break block44;
                                }
                                IType decoratorClass = injection.getClassBean().getBeanClass();
                                methods = decoratorClass.getMethods();
                                boolean reported = false;
                                if (methods == null) break block44;
                                IMethod[] iMethodArray = methods;
                                n = methods.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    IMethod[] beanMethods;
                                    IMethod method = iMethodArray[n3];
                                    if (!Flags.isPrivate((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags()) && (beanMethods = beanClass.findMethods(method)) != null) {
                                        IMethod[] iMethodArray2 = beanMethods;
                                        int n4 = beanMethods.length;
                                        int n5 = 0;
                                        while (n5 < n4) {
                                            IMethod beanMethod = iMethodArray2[n5];
                                            int flags = beanMethod.getFlags();
                                            if (!Flags.isPrivate((int)flags) && !Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                                                String methodName = Signature.toString((String)beanMethod.getSignature(), (String)beanMethod.getElementName(), (String[])beanMethod.getParameterNames(), (boolean)false, (boolean)false);
                                                this.addProblem(MessageFormat.format(CDIValidationMessages.DECORATOR_RESOLVES_TO_FINAL_METHOD, bean.getElementName(), methodName), CDIPreferences.DECORATOR_RESOLVES_TO_FINAL_BEAN, (ITextSourceReference)reference, injection.getResource());
                                                reported = true;
                                                break;
                                            }
                                            ++n5;
                                        }
                                        if (reported) break;
                                    }
                                    ++n3;
                                }
                            }
                            catch (JavaModelException e) {
                                CDICorePlugin.getDefault().logError(e);
                            }
                        }
                    }
                }
            }
            if (type != null && "javax.enterprise.inject.spi.InjectionPoint".equals(type.getFullyQualifiedName())) {
                IScope beanScope = injection.getBean().getScope();
                if (injection.hasDefaultQualifier() && beanScope != null && !"javax.enterprise.context.Dependent".equals(beanScope.getSourceType().getFullyQualifiedName())) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SCOPE_WHEN_TYPE_INJECTIONPOINT_IS_INJECTED, CDIPreferences.ILLEGAL_SCOPE_WHEN_TYPE_INJECTIONPOINT_IS_INJECTED, (ITextSourceReference)reference, injection.getResource());
                }
            }
        }
        if (!(injection.getClassBean() instanceof IDecorator) && injection.isDelegate()) {
            ITextSourceReference reference = injection.getDelegateAnnotation();
            this.addProblem(CDIValidationMessages.ILLEGAL_BEAN_DECLARING_DELEGATE, CDIPreferences.ILLEGAL_BEAN_DECLARING_DELEGATE, reference, injection.getResource());
        }
    }

    private void validateNormalBeanScope(IBean bean) {
        if (bean.getScope() != null && bean.getScope().isNorlmalScope()) {
            ITextSourceReference reference = null;
            Collection<IScopeDeclaration> scopes = bean.getScopeDeclarations();
            reference = !scopes.isEmpty() ? (ITextSourceReference)scopes.iterator().next() : bean.getNameLocation(false);
            if (reference == null) {
                return;
            }
            for (IParametedType type : bean.getLegalTypes()) {
                String typeSignature = type.getSignature();
                int kind = Signature.getTypeSignatureKind((String)typeSignature);
                if (kind == 4) {
                    if ("Object[]".equals(type.getSimpleName()) && bean.getLegalTypes().size() > 1) continue;
                    this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_ARRAY_TYPE_2, type.getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, reference, bean.getResource());
                    continue;
                }
                if (type.isPrimitive()) {
                    this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_PRIMITIVE_TYPE_2, type.getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, reference, bean.getResource());
                    continue;
                }
                if (!type.getType().exists() || "java.lang.Object".equals(type.getType().getFullyQualifiedName())) continue;
                try {
                    if (Flags.isFinal((int)type.getType().getFlags())) {
                        this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_FINAL_TYPE_2, type.getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, reference, bean.getResource());
                        continue;
                    }
                    IMethod[] methods = type.getType().getMethods();
                    boolean hasDefaultConstructor = false;
                    boolean hasConstructor = false;
                    IMethod[] iMethodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        hasConstructor = hasConstructor || method.isConstructor();
                        boolean bl = hasDefaultConstructor = hasDefaultConstructor || method.isConstructor() && !Flags.isPrivate((int)method.getFlags()) && method.getParameterNames().length == 0;
                        if (Flags.isFinal((int)method.getFlags())) {
                            this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_TYPE_WITH_FM_2, type.getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, reference, bean.getResource());
                            hasDefaultConstructor = true;
                            break;
                        }
                        ++n2;
                    }
                    if (hasDefaultConstructor || !hasConstructor) continue;
                    this.addProblem(MessageFormat.format(CDIValidationMessages.UNPROXYABLE_BEAN_TYPE_WITH_NPC_2, type.getSimpleName(), bean.getElementName()), CDIPreferences.UNPROXYABLE_BEAN_TYPE, reference, bean.getResource());
                }
                catch (JavaModelException e) {
                    CDICorePlugin.getDefault().logError(e);
                }
            }
        }
    }

    private void validateMixedClassBean(IClassBean bean) {
        IAnnotationDeclaration sessionDeclaration = CDIUtil.getSessionDeclaration(bean);
        IAnnotationDeclaration decoratorDeclaration = bean.getAnnotation("javax.decorator.Decorator");
        IAnnotationDeclaration interceptorDeclaration = bean.getAnnotation("javax.interceptor.Interceptor");
        if (sessionDeclaration != null) {
            if (decoratorDeclaration != null) {
                this.addProblem(CDIValidationMessages.SESSION_BEAN_ANNOTATED_DECORATOR, CDIPreferences.SESSION_BEAN_ANNOTATED_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)sessionDeclaration, bean.getResource(), 42);
                this.addProblem(CDIValidationMessages.SESSION_BEAN_ANNOTATED_DECORATOR, CDIPreferences.SESSION_BEAN_ANNOTATED_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)decoratorDeclaration, bean.getResource(), 42);
            }
            if (interceptorDeclaration != null) {
                this.addProblem(CDIValidationMessages.SESSION_BEAN_ANNOTATED_INTERCEPTOR, CDIPreferences.SESSION_BEAN_ANNOTATED_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)sessionDeclaration, bean.getResource(), 41);
                this.addProblem(CDIValidationMessages.SESSION_BEAN_ANNOTATED_INTERCEPTOR, CDIPreferences.SESSION_BEAN_ANNOTATED_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)interceptorDeclaration, bean.getResource(), 41);
            }
        }
    }

    private void validateSessionBean(ISessionBean bean) {
        IAnnotationDeclaration specializesDeclaration;
        IAnnotationDeclaration declaration = CDIUtil.getDifferentScopeDeclarationThanDepentend(bean);
        if (declaration != null) {
            IType type = bean.getBeanClass();
            try {
                String[] typeVariables = type.getTypeParameterSignatures();
                if (typeVariables.length > 0) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SCOPE_FOR_SESSION_BEAN_WITH_GENERIC_TYPE, CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN, (ITextSourceReference)declaration, bean.getResource());
                } else if (bean.isStateless()) {
                    if (declaration != null) {
                        this.addProblem(CDIValidationMessages.ILLEGAL_SCOPE_FOR_STATELESS_SESSION_BEAN, CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN, (ITextSourceReference)declaration, bean.getResource());
                    }
                } else if (bean.isSingleton()) {
                    if (declaration != null) {
                        declaration = CDIUtil.getDifferentScopeDeclarationThanApplicationScoped(bean);
                    }
                    if (declaration != null) {
                        this.addProblem(CDIValidationMessages.ILLEGAL_SCOPE_FOR_SINGLETON_SESSION_BEAN, CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN, (ITextSourceReference)declaration, bean.getResource());
                    }
                }
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
            }
        }
        if ((specializesDeclaration = bean.getSpecializesAnnotationDeclaration()) != null) {
            this.saveAllSuperTypesAsLinkedResources(bean);
            IBean sBean = bean.getSpecializedBean();
            if (sBean == null) {
                this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_SESSION_BEAN, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)specializesDeclaration, bean.getResource());
            } else if (!CDIUtil.isSessionBean(sBean)) {
                this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_SESSION_BEAN, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)specializesDeclaration, bean.getResource());
            }
        }
    }

    private void validateManagedBean(IClassBean bean) {
        IAnnotationDeclaration specializesDeclaration;
        IAnnotationDeclaration declaration;
        IAnnotationDeclaration decorator = bean.getAnnotation("javax.decorator.Decorator");
        IAnnotationDeclaration interceptor = bean.getAnnotation("javax.interceptor.Interceptor");
        if (decorator != null && interceptor != null) {
            this.addProblem(CDIValidationMessages.BOTH_INTERCEPTOR_AND_DECORATOR, CDIPreferences.BOTH_INTERCEPTOR_AND_DECORATOR, (ITextSourceReference)decorator, bean.getResource());
            this.addProblem(CDIValidationMessages.BOTH_INTERCEPTOR_AND_DECORATOR, CDIPreferences.BOTH_INTERCEPTOR_AND_DECORATOR, (ITextSourceReference)interceptor, bean.getResource());
        }
        if ((declaration = CDIUtil.getDifferentScopeDeclarationThanDepentend(bean)) != null) {
            IType type = bean.getBeanClass();
            try {
                IField[] fields;
                IField[] iFieldArray = fields = type.getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (Flags.isPublic((int)field.getFlags()) && !Flags.isStatic((int)field.getFlags())) {
                        ITextSourceReference fieldReference = CDIUtil.convertToSourceReference(field.getNameRange(), bean.getResource(), (IMember)field);
                        this.addProblem(CDIValidationMessages.ILLEGAL_SCOPE_FOR_MANAGED_BEAN_WITH_PUBLIC_FIELD, CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN, fieldReference, bean.getResource(), 10);
                    }
                    ++n2;
                }
                String[] typeVariables = type.getTypeParameterSignatures();
                if (typeVariables.length > 0) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SCOPE_FOR_MANAGED_BEAN_WITH_GENERIC_TYPE, CDIPreferences.ILLEGAL_SCOPE_FOR_BEAN, (ITextSourceReference)declaration, bean.getResource());
                }
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
            }
        }
        if ((specializesDeclaration = bean.getSpecializesAnnotationDeclaration()) != null) {
            this.saveAllSuperTypesAsLinkedResources(bean);
            IBean sBean = bean.getSpecializedBean();
            if (sBean != null) {
                if (sBean instanceof ISessionBean || sBean.getAnnotation("javax.ejb.Stateless") != null || sBean.getAnnotation("javax.ejb.Singleton") != null) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_MANAGED_BEAN, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)specializesDeclaration, bean.getResource());
                } else if (sBean instanceof ClassBean && !((ClassBean)sBean).getDefinition().hasBeanConstructor()) {
                    this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_MANAGED_BEAN, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)specializesDeclaration, bean.getResource());
                }
            } else {
                this.addProblem(CDIValidationMessages.ILLEGAL_SPECIALIZING_MANAGED_BEAN, CDIPreferences.ILLEGAL_SPECIALIZING_BEAN, (ITextSourceReference)specializesDeclaration, bean.getResource());
            }
        }
        try {
            boolean passivatingScope;
            IAnnotationDeclaration normalScopeDeclaration;
            IScope scope;
            ITextSourceReference reference;
            Collection bindings = bean.getInterceptorBindings();
            if (!bindings.isEmpty()) {
                if (Flags.isFinal((int)bean.getBeanClass().getFlags())) {
                    ITextSourceReference reference2 = CDIUtil.convertToSourceReference(bean.getBeanClass().getNameRange(), bean.getResource(), (IMember)bean.getBeanClass());
                    this.addProblem(CDIValidationMessages.ILLEGAL_INTERCEPTOR_BINDING_CLASS, CDIPreferences.ILLEGAL_INTERCEPTOR_BINDING_METHOD, reference2, bean.getResource());
                } else {
                    IMethod[] methods = bean.getBeanClass().getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        int flags = methods[i].getFlags();
                        if (Flags.isFinal((int)flags) && !Flags.isStatic((int)flags) && !Flags.isPrivate((int)flags)) {
                            ITextSourceReference reference3 = CDIUtil.convertToSourceReference(methods[i].getNameRange(), bean.getResource(), (IMember)methods[i]);
                            this.addProblem(CDIValidationMessages.ILLEGAL_INTERCEPTOR_BINDING_METHOD, CDIPreferences.ILLEGAL_INTERCEPTOR_BINDING_METHOD, reference3, bean.getResource());
                        }
                        ++i;
                    }
                }
            } else {
                for (IBeanMethod method : bean.getAllMethods()) {
                    if (method.getInterceptorBindings().isEmpty()) continue;
                    if (Flags.isFinal((int)bean.getBeanClass().getFlags())) {
                        ITextSourceReference reference4 = CDIUtil.convertToSourceReference(bean.getBeanClass().getNameRange(), bean.getResource(), (IMember)bean.getBeanClass());
                        this.addProblem(CDIValidationMessages.ILLEGAL_INTERCEPTOR_BINDING_CLASS, CDIPreferences.ILLEGAL_INTERCEPTOR_BINDING_METHOD, reference4, bean.getResource());
                        continue;
                    }
                    IMethod sourceMethod = method.getMethod();
                    int flags = sourceMethod.getFlags();
                    if (!Flags.isFinal((int)flags) || Flags.isStatic((int)flags) || Flags.isPrivate((int)flags)) continue;
                    reference = CDIUtil.convertToSourceReference(sourceMethod.getNameRange(), bean.getResource(), (IMember)sourceMethod);
                    this.addProblem(CDIValidationMessages.ILLEGAL_INTERCEPTOR_BINDING_METHOD, CDIPreferences.ILLEGAL_INTERCEPTOR_BINDING_METHOD, reference, bean.getResource());
                }
            }
            if (bean.getScopeDeclarations().size() < 2 && (scope = bean.getScope()) != null && scope.isNorlmalScope() && (normalScopeDeclaration = scope.getAnnotationDeclaration("javax.enterprise.context.NormalScope")) != null && (passivatingScope = "true".equalsIgnoreCase("" + normalScopeDeclaration.getMemberValue("passivating")))) {
                boolean passivatingCapable = false;
                for (IParametedType type : bean.getAllTypes()) {
                    if (!"java.io.Serializable".equals(type.getType().getFullyQualifiedName())) continue;
                    passivatingCapable = true;
                    break;
                }
                if (!passivatingCapable) {
                    reference = CDIUtil.convertToSourceReference(bean.getBeanClass().getNameRange(), bean.getResource(), (IMember)bean.getBeanClass());
                    this.addProblem(MessageFormat.format(CDIValidationMessages.NOT_PASSIVATION_CAPABLE_BEAN, bean.getElementName(), scope.getSourceType().getElementName()), CDIPreferences.NOT_PASSIVATION_CAPABLE_BEAN, reference, bean.getResource(), 9);
                }
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    private void validateInterceptor(IInterceptor interceptor) {
        IAnnotationDeclaration declaration;
        if (interceptor.getName() != null) {
            declaration = interceptor.getAnnotation("javax.inject.Named");
            if (declaration == null) {
                declaration = interceptor.getAnnotation("javax.interceptor.Interceptor");
            }
            if (declaration == null) {
                declaration = CDIUtil.getNamedStereotypeDeclaration(interceptor);
            }
            this.addProblem(CDIValidationMessages.INTERCEPTOR_HAS_NAME, CDIPreferences.INTERCEPTOR_OR_DECORATOR_HAS_NAME, (ITextSourceReference)declaration, interceptor.getResource(), 31);
        }
        if (interceptor.isAlternative()) {
            declaration = interceptor.getAlternativeDeclaration();
            if (declaration == null) {
                declaration = interceptor.getInterceptorAnnotation();
            }
            if (declaration == null) {
                declaration = interceptor.getNameLocation(true);
            }
            this.addProblem(CDIValidationMessages.INTERCEPTOR_IS_ALTERNATIVE, CDIPreferences.INTERCEPTOR_OR_DECORATOR_IS_ALTERNATIVE, (ITextSourceReference)declaration, interceptor.getResource());
        }
        for (IProducer producer : interceptor.getProducers()) {
            this.addProblem(CDIValidationMessages.PRODUCER_IN_INTERCEPTOR, CDIPreferences.PRODUCER_IN_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)producer.getProducesAnnotation(), interceptor.getResource(), 26);
        }
        Collection bindings = interceptor.getInterceptorBindings();
        if (bindings.isEmpty()) {
            IAnnotationDeclaration declaration2 = interceptor.getAnnotation("javax.interceptor.Interceptor");
            if (declaration2 != null) {
                this.addProblem(CDIValidationMessages.MISSING_INTERCEPTOR_BINDING, CDIPreferences.MISSING_INTERCEPTOR_BINDING, (ITextSourceReference)declaration2, interceptor.getResource());
            }
        } else {
            for (IInterceptorBinding binding : bindings) {
                Object[] values;
                Object value;
                boolean markedAsWrong = false;
                IAnnotationDeclaration target = binding.getAnnotationDeclaration("java.lang.annotation.Target");
                if (target != null && (value = target.getMemberValue(null)) instanceof Object[] && (values = (Object[])value).length > 1) {
                    for (IBeanMethod method : interceptor.getAllMethods()) {
                        if (!method.isLifeCycleCallbackMethod()) continue;
                        IAnnotationDeclaration declaration3 = CDIUtil.getAnnotationDeclaration((IAnnotated)interceptor, binding);
                        if (declaration3 == null) {
                            declaration3 = interceptor.getInterceptorAnnotation();
                        }
                        this.addProblem(CDIValidationMessages.ILLEGAL_LIFECYCLE_CALLBACK_INTERCEPTOR_BINDING, CDIPreferences.ILLEGAL_LIFECYCLE_CALLBACK_INTERCEPTOR_BINDING, (ITextSourceReference)declaration3, interceptor.getResource());
                        markedAsWrong = true;
                        break;
                    }
                }
                if (markedAsWrong) break;
            }
        }
    }

    private void validateDecorator(CDIValidationContext context, IDecorator decorator) {
        IType delegateType;
        IParametedType iParametedType;
        IAnnotationDeclaration declaration;
        if (decorator.getName() != null) {
            declaration = decorator.getAnnotation("javax.inject.Named");
            if (declaration == null) {
                declaration = decorator.getAnnotation("javax.decorator.Decorator");
            }
            if (declaration == null) {
                declaration = CDIUtil.getNamedStereotypeDeclaration(decorator);
            }
            this.addProblem(CDIValidationMessages.DECORATOR_HAS_NAME, CDIPreferences.INTERCEPTOR_OR_DECORATOR_HAS_NAME, (ITextSourceReference)declaration, decorator.getResource(), 32);
        }
        if (decorator.isAlternative()) {
            declaration = decorator.getAlternativeDeclaration();
            if (declaration == null) {
                declaration = decorator.getDecoratorAnnotation();
            }
            if (declaration == null) {
                declaration = decorator.getNameLocation(true);
            }
            this.addProblem(CDIValidationMessages.DECORATOR_IS_ALTERNATIVE, CDIPreferences.INTERCEPTOR_OR_DECORATOR_IS_ALTERNATIVE, (ITextSourceReference)declaration, decorator.getResource());
        }
        for (IProducer producer : decorator.getProducers()) {
            this.addProblem(CDIValidationMessages.PRODUCER_IN_DECORATOR, CDIPreferences.PRODUCER_IN_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)producer.getProducesAnnotation(), decorator.getResource(), 27);
        }
        HashSet<ITextSourceReference> delegates = new HashSet<ITextSourceReference>();
        IInjectionPoint delegate = null;
        for (IInjectionPoint iInjectionPoint : decorator.getInjectionPoints(true)) {
            ITextSourceReference delegateAnnotation = iInjectionPoint.getDelegateAnnotation();
            if (delegateAnnotation == null) continue;
            if (iInjectionPoint instanceof IInjectionPointField) {
                delegate = iInjectionPoint;
                delegates.add(delegateAnnotation);
            }
            if (!(iInjectionPoint instanceof IInjectionPointParameter)) continue;
            if (((IInjectionPointParameter)iInjectionPoint).getBeanMethod().getAnnotation("javax.enterprise.inject.Produces") == null) {
                delegate = iInjectionPoint;
                delegates.add(delegateAnnotation);
                continue;
            }
            this.addProblem(CDIValidationMessages.ILLEGAL_INJECTION_POINT_DELEGATE, CDIPreferences.ILLEGAL_INJECTION_POINT_DELEGATE, delegateAnnotation, decorator.getResource());
        }
        if (delegates.size() > 1) {
            for (ITextSourceReference iTextSourceReference : delegates) {
                this.addProblem(CDIValidationMessages.MULTIPLE_DELEGATE, CDIPreferences.MULTIPLE_OR_MISSING_DELEGATE, iTextSourceReference, decorator.getResource());
            }
        } else if (delegates.isEmpty()) {
            IAnnotationDeclaration iAnnotationDeclaration = decorator.getDecoratorAnnotation();
            this.addProblem(CDIValidationMessages.MISSING_DELEGATE, CDIPreferences.MULTIPLE_OR_MISSING_DELEGATE, (ITextSourceReference)iAnnotationDeclaration, decorator.getResource());
        }
        if (delegate != null && (iParametedType = delegate.getType()) != null && (delegateType = iParametedType.getType()) != null && !this.checkTheOnlySuper(context, decorator, iParametedType)) {
            List<String> supers = null;
            if (!this.isAsYouTypeValidation() && this.shouldValidateType(delegateType)) {
                this.getValidationContext().addLinkedCoreResource(SHORT_ID, decorator.getSourcePath().toString(), delegateType.getResource().getFullPath(), false);
            }
            for (IParametedType decoratedParametedType : decorator.getDecoratedTypes()) {
                String decoratedTypeName;
                IType decoratedType = decoratedParametedType.getType();
                if (decoratedType == null) continue;
                if (!this.isAsYouTypeValidation() && this.shouldValidateType(decoratedType)) {
                    this.getValidationContext().addLinkedCoreResource(SHORT_ID, decorator.getSourcePath().toString(), decoratedType.getResource().getFullPath(), false);
                }
                if ((decoratedTypeName = decoratedType.getFullyQualifiedName()).equals(decorator.getBeanClass().getFullyQualifiedName()) || decoratedTypeName.equals("java.lang.Object")) continue;
                if (supers == null) {
                    supers = this.getSuppers(iParametedType);
                }
                if (supers.contains(decoratedParametedType.getSignature())) continue;
                ITextSourceReference declaration3 = delegate.getDelegateAnnotation();
                if (iParametedType instanceof ITypeDeclaration) {
                    declaration3 = CDIUtil.convertToJavaSourceReference((ITextSourceReference)((ITypeDeclaration)iParametedType), delegate.getSourceMember());
                }
                String typeName = Signature.getSignatureSimpleName((String)decoratedParametedType.getSignature());
                this.addProblem(MessageFormat.format(CDIValidationMessages.DELEGATE_HAS_ILLEGAL_TYPE, typeName), CDIPreferences.DELEGATE_HAS_ILLEGAL_TYPE, declaration3, decorator.getResource());
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkTheOnlySuper(CDIValidationContext context, IDecorator decorator, IParametedType delegatedType) {
        ICDIProject cdiProject = context.getCdiProject();
        try {
            String superClassSignature = decorator.getBeanClass().getSuperclassTypeSignature();
            String[] superInterfaceSignatures = decorator.getBeanClass().getSuperInterfaceTypeSignatures();
            if (superClassSignature == null) {
                if (superInterfaceSignatures.length == 0) {
                    return true;
                }
                if (superInterfaceSignatures.length > 1) {
                    return false;
                }
                ParametedType superType = cdiProject.getNature().getTypeFactory().getParametedType((IMember)decorator.getBeanClass(), superInterfaceSignatures[0]);
                if (superType == null) {
                    return true;
                }
                boolean bl = superType.getSignature().equals(delegatedType.getSignature());
                return bl;
            }
            if (superInterfaceSignatures.length > 0) {
                return false;
            }
            ParametedType superType = cdiProject.getNature().getTypeFactory().getParametedType((IMember)decorator.getBeanClass(), superClassSignature);
            if (superType == null) return true;
            superType.getSignature().equals(delegatedType.getSignature());
            return true;
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return true;
    }

    private List<String> getSuppers(IParametedType type) {
        ArrayList<String> signatures = new ArrayList<String>();
        for (IParametedType superType : ((ParametedType)type).getAllTypes()) {
            signatures.add(superType.getSignature());
        }
        signatures.add(type.getSignature());
        return signatures;
    }

    private void validateTyped(IBean bean) {
        Collection<ITypeDeclaration> typedDeclarations = bean.getRestrictedTypeDeclaratios();
        if (!typedDeclarations.isEmpty()) {
            this.saveAllSuperTypesAsLinkedResources(bean);
            HashSet<String> allTypeNames = new HashSet<String>();
            for (IParametedType type : bean.getAllTypes()) {
                if (type.getType() == null) continue;
                allTypeNames.add(type.getType().getFullyQualifiedName());
            }
            for (ITypeDeclaration typedDeclaration : typedDeclarations) {
                IType typedType = typedDeclaration.getType();
                if (typedType == null || allTypeNames.contains(typedType.getFullyQualifiedName())) continue;
                IType e = bean instanceof IJavaReference ? ((IJavaReference)bean).getSourceMember() : bean.getBeanClass();
                ITextSourceReference typedDeclarationReference = CDIUtil.convertToJavaSourceReference((ITextSourceReference)typedDeclaration, (IMember)e);
                String message = CDIValidationMessages.ILLEGAL_TYPE_IN_TYPED_DECLARATION;
                this.addProblem(message, CDIPreferences.ILLEGAL_TYPE_IN_TYPED_DECLARATION, typedDeclarationReference, bean.getResource());
            }
        }
    }

    private void validateBeanScope(IBean bean) {
        IAnnotationDeclaration scopeOrStereotypeDeclaration;
        Collection<IStereotypeDeclaration> stereotypeDeclarations;
        Collection<IScopeDeclaration> scopes = bean.getScopeDeclarations();
        if (scopes.size() > 1) {
            String message = bean instanceof IClassBean ? CDIValidationMessages.MULTIPLE_SCOPE_TYPE_ANNOTATIONS_IN_BEAN_CLASS : (bean instanceof IProducerField ? CDIValidationMessages.MULTIPLE_SCOPE_TYPE_ANNOTATIONS_IN_PRODUCER_FIELD : (bean instanceof IProducerMethod ? CDIValidationMessages.MULTIPLE_SCOPE_TYPE_ANNOTATIONS_IN_PRODUCER_METHOD : CDIValidationMessages.MULTIPLE_SCOPE_TYPE_ANNOTATIONS));
            for (IScopeDeclaration scope : scopes) {
                this.addProblem(message, CDIPreferences.MULTIPLE_SCOPE_TYPE_ANNOTATIONS, (ITextSourceReference)scope, bean.getResource());
            }
        }
        if (!(stereotypeDeclarations = bean.getStereotypeDeclarations()).isEmpty() && scopes.isEmpty()) {
            HashMap<String, IStereotypeDeclaration> declarationMap = new HashMap<String, IStereotypeDeclaration>();
            for (IStereotypeDeclaration stereotypeDeclaration : stereotypeDeclarations) {
                IStereotype stereotype = stereotypeDeclaration.getStereotype();
                IScope scope = stereotype.getScope();
                if (scope == null) continue;
                declarationMap.put(scope.getSourceType().getFullyQualifiedName(), stereotypeDeclaration);
            }
            if (declarationMap.size() > 1) {
                for (IStereotypeDeclaration stereotypeDeclaration : declarationMap.values()) {
                    this.addProblem(CDIValidationMessages.MISSING_SCOPE_WHEN_THERE_IS_NO_DEFAULT_SCOPE, CDIPreferences.MISSING_SCOPE_WHEN_THERE_IS_NO_DEFAULT_SCOPE, (ITextSourceReference)stereotypeDeclaration, bean.getResource());
                }
            }
        }
        boolean interceptor = bean instanceof IInterceptor;
        boolean decorator = bean instanceof IDecorator;
        if ((interceptor || decorator) && (scopeOrStereotypeDeclaration = CDIUtil.getDifferentScopeDeclarationThanDepentend(bean)) != null) {
            String message = interceptor ? CDIValidationMessages.ILLEGAL_SCOPE_FOR_INTERCEPTOR : CDIValidationMessages.ILLEGAL_SCOPE_FOR_DECORATOR;
            this.addProblem(message, CDIPreferences.ILLEGAL_SCOPE_FOR_INTERCEPTOR_OR_DECORATOR, (ITextSourceReference)scopeOrStereotypeDeclaration, bean.getResource());
        }
    }

    boolean shouldValidateResourceOfElement(IResource resource) {
        if (resource instanceof IFile && !this.shouldBeValidated((IFile)resource)) {
            return false;
        }
        return resource != null && resource.exists() && resource.getName().toLowerCase().endsWith(".java");
    }

    boolean shouldValidateType(IType type) {
        return type.exists() && !type.isReadOnly();
    }

    private void validateStereotype(IStereotype stereotype) {
        IAnnotationDeclaration typedDeclaration;
        IAnnotationDeclaration location;
        Object name;
        if (stereotype == null) {
            return;
        }
        IResource resource = stereotype.getResource();
        if (!this.shouldValidateResourceOfElement(resource)) {
            return;
        }
        this.addLinkedStereotypes(stereotype.getSourcePath().toString(), stereotype);
        List as = stereotype.getAnnotationDeclarations();
        IAnnotationDeclaration nameDeclaration = stereotype.getNameDeclaration();
        if (nameDeclaration != null && (name = nameDeclaration.getMemberValue(null)) != null && name.toString().length() > 0) {
            location = nameDeclaration;
            this.addProblem(CDIValidationMessages.STEREOTYPE_DECLARES_NON_EMPTY_NAME, CDIPreferences.STEREOTYPE_DECLARES_NON_EMPTY_NAME, (ITextSourceReference)location, resource, 30);
        }
        if ((typedDeclaration = stereotype.getAnnotationDeclaration("javax.enterprise.inject.Typed")) != null) {
            location = typedDeclaration;
            this.addProblem(CDIValidationMessages.STEREOTYPE_IS_ANNOTATED_TYPED, CDIPreferences.STEREOTYPE_IS_ANNOTATED_TYPED, (ITextSourceReference)location, resource, 33);
        }
        for (IAnnotationDeclaration a : as) {
            if (!(a instanceof IQualifierDeclaration) || a == nameDeclaration) continue;
            IAnnotationDeclaration location2 = a;
            this.addProblem(CDIValidationMessages.ILLEGAL_QUALIFIER_IN_STEREOTYPE, CDIPreferences.ILLEGAL_QUALIFIER_IN_STEREOTYPE, (ITextSourceReference)location2, resource);
        }
        Collection<IScopeDeclaration> scopeDeclarations = stereotype.getScopeDeclarations();
        if (scopeDeclarations.size() > 1) {
            for (IScopeDeclaration scope : scopeDeclarations) {
                this.addProblem(CDIValidationMessages.STEREOTYPE_DECLARES_MORE_THAN_ONE_SCOPE, CDIPreferences.STEREOTYPE_DECLARES_MORE_THAN_ONE_SCOPE, (ITextSourceReference)scope, stereotype.getResource());
            }
        }
        try {
            this.annotationValidator.validateStereotypeAnnotationTypeAnnotations(stereotype, resource);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    boolean shouldValidateAnnotation(ICDIAnnotation annotation) {
        return annotation != null && annotation.getSourceType() != null && this.shouldValidateType(annotation.getSourceType());
    }

    private void validateInterceptorBinding(IInterceptorBinding binding) {
        if (binding == null || !this.shouldValidateAnnotation(binding)) {
            return;
        }
        this.addLinkedInterceptorBindings(binding.getSourcePath().toString(), binding);
        this.validateAnnotationMembers(binding, CDIValidationMessages.MISSING_NONBINDING_FOR_ARRAY_VALUE_IN_INTERCEPTOR_BINDING_TYPE_MEMBER, CDIValidationMessages.MISSING_NONBINDING_FOR_ANNOTATION_VALUE_IN_INTERCEPTOR_BINDING_TYPE_MEMBER, CDIPreferences.MISSING_NONBINDING_IN_INTERCEPTOR_BINDING_TYPE_MEMBER, 20, 19);
        try {
            this.annotationValidator.validateInterceptorBindingAnnotationTypeAnnotations(binding);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    private void validateQualifier(IQualifier qualifier) {
        if (qualifier == null) {
            return;
        }
        IResource resource = qualifier.getResource();
        if (!this.shouldValidateResourceOfElement(resource)) {
            return;
        }
        this.validateAnnotationMembers(qualifier, CDIValidationMessages.MISSING_NONBINDING_FOR_ARRAY_VALUE_IN_QUALIFIER_TYPE_MEMBER, CDIValidationMessages.MISSING_NONBINDING_FOR_ANNOTATION_VALUE_IN_QUALIFIER_TYPE_MEMBER, CDIPreferences.MISSING_NONBINDING_IN_QUALIFIER_TYPE_MEMBER, 18, 17);
        try {
            this.annotationValidator.validateQualifierAnnotationTypeAnnotations(qualifier, resource);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    void validateAnnotationMembers(ICDIAnnotation annotation, String arrayMessageErrorKey, String annotationValueErrorKey, String preferencesKey, int arrayMessageId, int annotationValueId) {
        IType type = annotation.getSourceType();
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                String returnTypeSignature = method.getReturnType();
                int kind = Signature.getTypeSignatureKind((String)returnTypeSignature);
                if (kind == 4) {
                    if (!annotation.getNonBindingMethods().contains(method)) {
                        ITextSourceReference reference = CDIUtil.convertToSourceReference(method.getNameRange(), annotation.getResource(), (IMember)method);
                        this.addProblem(arrayMessageErrorKey, preferencesKey, reference, annotation.getResource(), arrayMessageId);
                    }
                } else if (kind == 1) {
                    IType memberType;
                    String typeName = Signature.getSignatureSimpleName((String)returnTypeSignature);
                    String packageName = Signature.getSignatureQualifier((String)returnTypeSignature);
                    typeName = packageName.length() > 0 ? String.valueOf(packageName) + "." + typeName : EclipseJavaUtil.resolveType((IType)type, (String)typeName);
                    if (typeName != null && (memberType = type.getJavaProject().findType(typeName)) != null && memberType.isAnnotation() && !annotation.getNonBindingMethods().contains(method)) {
                        ITextSourceReference reference = CDIUtil.convertToSourceReference(method.getNameRange(), annotation.getResource(), (IMember)method);
                        this.addProblem(annotationValueErrorKey, preferencesKey, reference, annotation.getResource(), annotationValueId);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    protected String getMessageBundleName() {
        return BUNDLE_NAME;
    }

    protected boolean shouldCleanAllAnnotations() {
        return true;
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new CDIPreferenceInfo());
    }

    class CDIPreferenceInfo
    implements IPreferenceInfo {
        CDIPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return CDICoreValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return CDICoreValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.cdi.core";
        }
    }

    public static class CDIValidationContext {
        private ICDIProject cdiProject;
        private IProject project;
        private Dependencies dependencies;
        private Set<IValidatorFeature> extensions;
        private Set<IInjectionPointValidatorFeature> injectionValidationFeatures;

        public CDIValidationContext(IProject project, ICDIProject cdiProject) {
            this.project = project;
            this.cdiProject = cdiProject;
            this.dependencies = new Dependencies();
            this.extensions = Collections.emptySet();
            this.injectionValidationFeatures = cdiProject.getNature().getExtensionManager().getFeatures(IInjectionPointValidatorFeature.class);
        }

        public CDIValidationContext(IProject project) {
            this.project = project;
            CDICoreNature nature = CDICorePlugin.getCDI(project, true);
            this.cdiProject = nature.getDelegate();
            this.dependencies = nature.getDefinitions().getAllDependencies();
            this.extensions = nature.getExtensionManager().getValidatorFeatures();
            this.injectionValidationFeatures = nature.getExtensionManager().getFeatures(IInjectionPointValidatorFeature.class);
        }

        public ICDIProject getCdiProject() {
            return this.cdiProject;
        }

        public IProject getProject() {
            return this.project;
        }

        public Dependencies getDependencies() {
            return this.dependencies;
        }

        public Set<IValidatorFeature> getExtensions() {
            return this.extensions;
        }

        public Set<IInjectionPointValidatorFeature> getInjectionValidationFeatures() {
            return this.injectionValidationFeatures;
        }
    }
}

