/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.cdi.core.CDICoreMessages;

public abstract class AbstractCDIProcessor
extends RenameProcessor {
    private static final RefactoringParticipant[] EMPTY_REF_PARTICIPANT = new RefactoringParticipant[0];
    protected RefactoringStatus status;
    protected CompositeChange rootChange;
    private String label;

    public AbstractCDIProcessor(String label) {
        this.label = label;
    }

    public String getProcessorName() {
        return this.label;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REF_PARTICIPANT;
    }

    public String getLabel() {
        return this.label;
    }

    protected boolean isFileCorrect(IFile file) {
        if (file == null) {
            this.status.addFatalError(CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_FILE_NOT_FOUND);
            return false;
        }
        if (!file.isSynchronized(0)) {
            this.status.addFatalError(NLS.bind((String)CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_OUT_OF_SYNC_PROJECT, (Object)file.getProject().getFullPath().toString()));
            return false;
        }
        if (file.isPhantom()) {
            this.status.addFatalError(NLS.bind((String)CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_PHANTOM_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        if (file.isReadOnly()) {
            this.status.addFatalError(NLS.bind((String)CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        return true;
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

