/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.project.facet;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.jboss.tools.cdi.core.CDIUtil;

public class CDIFacetedProjectListener
implements IFacetedProjectListener {
    static HashMap<String, String> minimalVersions = new HashMap();

    static {
        minimalVersions.put("jst.web", "3.1");
        minimalVersions.put("jst.ejb", "3.2");
        minimalVersions.put("jst.utility", null);
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.PRE_INSTALL && event instanceof IProjectFacetActionEvent) {
            IProjectFacetVersion version;
            IProject project = event.getProject().getProject();
            IProjectFacet facet = ((IProjectFacetActionEvent)event).getProjectFacet();
            if (this.isCDIRequired(facet, version = ((IProjectFacetActionEvent)event).getProjectFacetVersion())) {
                CDIUtil.enableCDI(project, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    boolean isCDIRequired(IProjectFacet facet, IProjectFacetVersion version) {
        if (!minimalVersions.containsKey(facet.getId())) {
            return false;
        }
        String minimalVersionId = minimalVersions.get(facet.getId());
        if (version != null && minimalVersionId != null) {
            IProjectFacetVersion minimalVersion = facet.getVersion(minimalVersionId);
            return minimalVersion != null && minimalVersion.compareTo((Object)version) <= 0;
        }
        return true;
    }
}

