/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IObserverMethod;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.internal.core.impl.CDIAnnotationElement;
import org.jboss.tools.cdi.internal.core.impl.CDIElement;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.DecoratorBean;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBean;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBindingElement;
import org.jboss.tools.cdi.internal.core.impl.QualifierElement;
import org.jboss.tools.cdi.internal.core.impl.ScopeElement;
import org.jboss.tools.cdi.internal.core.impl.SessionBean;
import org.jboss.tools.cdi.internal.core.impl.StereotypeElement;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.CDIBuilderDelegate;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.internal.core.scanner.ImplementationCollector;
import org.jboss.tools.cdi.internal.core.scanner.lib.BeanArchiveDetector;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.java.IJavaReference;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.text.INodeReference;

public class CDIProjectAsYouType
implements ICDIProject,
ICDIElement {
    ICDIProject project;
    IFile file;
    Collection<IBean> beans = new ArrayList<IBean>();
    StereotypeElement stereotype;
    QualifierElement qualifier;
    ScopeElement scope;
    IInterceptorBinding interceptorBinding;

    public CDIProjectAsYouType(ICDIProject project, IFile file) {
        ICDIProject p;
        if (file.getProject() != project.getNature().getProject() && (p = CDICorePlugin.getCDIProject(file.getProject(), true)) != null) {
            project = p;
        }
        this.project = project;
        this.file = file;
        try {
            this.build();
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        p = ((CDIProject)project).getModifiedCopy(file, this.beans);
        if (p != null) {
            this.project = p;
        }
    }

    @Override
    public CDIVersion getVersion() {
        return this.project.getVersion();
    }

    private void build() throws CoreException {
        ICompilationUnit unit;
        DefinitionContext context = this.project.getNature().getDefinitions().getCleanCopy();
        FileSet fileSet = new FileSet();
        if (this.file.getName().endsWith(".java") && (unit = this.findCompilationUnit()) != null) {
            if (this.file.getName().equals("package-info.java")) {
                IPackageDeclaration[] pkg = unit.getPackageDeclarations();
                if (pkg != null && pkg.length > 0) {
                    fileSet.add(this.file.getFullPath(), pkg[0]);
                }
            } else {
                IType[] ts = unit.getTypes();
                if (this.getNature().getBeanDiscoveryMode() == 1) {
                    ts = new IType[]{};
                }
                if (ts.length > 0 && this.getNature().getBeanDiscoveryMode() == 2) {
                    ts = BeanArchiveDetector.getAnnotatedTypes(ts, this.getNature());
                }
                fileSet.add(this.file.getFullPath(), ts);
            }
        }
        CDIBuilderDelegate builder = new CDIBuilderDelegate();
        builder.build(fileSet, context);
        this.rebuildAnnotationTypes(context.getAllAnnotations());
        this.rebuildBeans(context.getTypeDefinitions());
    }

    private ICompilationUnit findCompilationUnit() {
        IWorkbench workbench = CommonPlugin.getDefault().getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                if (window.getShell() != null) {
                    IWorkbenchPage[] pages;
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] rs;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = rs = page.getEditorReferences();
                        int n5 = rs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IWorkingCopyManager manager;
                            ICompilationUnit unit;
                            IFile file;
                            IEditorReference r = iEditorReferenceArray[n6];
                            IEditorPart part = r.getEditor(false);
                            if (part != null && (file = this.getFile(part)) != null && file.equals((Object)this.file) && part instanceof CompilationUnitEditor && (unit = (manager = JavaUI.getWorkingCopyManager()).getWorkingCopy(part.getEditorInput())) != null) {
                                try {
                                    unit.reconcile(0, false, null, null);
                                }
                                catch (JavaModelException e) {
                                    CDICorePlugin.getDefault().logError(e);
                                }
                                return unit;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private IFile getFile(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    synchronized void rebuildAnnotationTypes(List<AnnotationDefinition> ds) {
        for (AnnotationDefinition d : ds) {
            CDIAnnotationElement s;
            if (d.getResource() == null || !d.getResource().getFullPath().equals((Object)this.file.getFullPath())) continue;
            if ((d.getKind() & 8) > 0) {
                s = new StereotypeElement();
                this.initAnnotationElement(s, d);
                this.stereotype = s;
            }
            if ((d.getKind() & 0x10) > 0) {
                s = new InterceptorBindingElement();
                this.initAnnotationElement(s, d);
                this.interceptorBinding = s;
            }
            if ((d.getKind() & 4) > 0) {
                s = new QualifierElement();
                this.initAnnotationElement(s, d);
                this.qualifier = s;
            }
            if ((d.getKind() & 0x20) <= 0) continue;
            s = new ScopeElement();
            this.initAnnotationElement(s, d);
            this.scope = s;
        }
    }

    private void initAnnotationElement(CDIAnnotationElement s, AnnotationDefinition d) {
        s.setDefinition(d);
        s.setParent((CDIElement)((Object)this.project));
        IPath r = d.getType().getPath();
        if (r != null) {
            s.setSourcePath(r);
        }
    }

    void rebuildBeans(List<TypeDefinition> typeDefinitions) {
        ArrayList<IBean> beans = new ArrayList<IBean>();
        HashSet<IType> newAllTypes = new HashSet<IType>();
        for (TypeDefinition d : typeDefinitions) {
            newAllTypes.add(d.getType());
        }
        HashMap<TypeDefinition, InterceptorBean> newDefinitionToClassbeans = new HashMap<TypeDefinition, InterceptorBean>();
        HashMap<IType, ClassBean> newClassBeans = new HashMap<IType, ClassBean>();
        ImplementationCollector ic = new ImplementationCollector(typeDefinitions);
        for (TypeDefinition typeDefinition : typeDefinitions) {
            ClassBean bean = null;
            bean = typeDefinition.getInterceptorAnnotation() != null || ic.isInterceptor(typeDefinition.getType()) ? new InterceptorBean() : (typeDefinition.getDecoratorAnnotation() != null || ic.isDecorator(typeDefinition.getType()) ? new DecoratorBean() : (typeDefinition.getStatefulAnnotation() != null || typeDefinition.getStatelessAnnotation() != null || typeDefinition.getSingletonAnnotation() != null ? new SessionBean() : new ClassBean()));
            bean.setParent(this);
            bean.setDefinition(typeDefinition);
            newDefinitionToClassbeans.put(typeDefinition, (InterceptorBean)bean);
            String typeName = typeDefinition.getType().getFullyQualifiedName();
            if (typeDefinition.isVetoed()) continue;
            if (typeDefinition.hasBeanConstructor()) {
                beans.add(bean);
                newClassBeans.put(typeDefinition.getType(), bean);
            } else {
                beans.add(bean);
            }
            for (IProducer producer : bean.getProducers()) {
                beans.add(producer);
            }
        }
        for (IClassBean iClassBean : newClassBeans.values()) {
            ParametedType s = ((ClassBean)iClassBean).getSuperType();
            if (s == null || s.getType() == null) continue;
            IClassBean superClassBean = (IClassBean)newClassBeans.get(s.getType());
            if (superClassBean == null) {
                superClassBean = this.project.getBeanClass(s.getType());
            }
            if (!(iClassBean instanceof ClassBean)) continue;
            ((ClassBean)iClassBean).setSuperClassBean(superClassBean);
        }
        for (IBean iBean : beans) {
            this.addBean(iBean);
        }
    }

    public void addBean(IBean bean) {
        this.beans.add(bean);
    }

    @Override
    public IBean[] getBeans() {
        return this.project.getBeans();
    }

    @Override
    public Collection<IBean> getNamedBeans(boolean attemptToResolveAmbiguousNames) {
        return this.project.getNamedBeans(attemptToResolveAmbiguousNames);
    }

    @Override
    public Collection<IBean> getBeans(String name, boolean attemptToResolveAmbiguousNames) {
        return this.project.getBeans(name, attemptToResolveAmbiguousNames);
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, IParametedType beanType, IQualifierDeclaration ... qualifiers) {
        return this.project.getBeans(attemptToResolveAmbiguousDependency, beanType, qualifiers);
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, IParametedType beanType, IType ... qualifiers) {
        return this.project.getBeans(attemptToResolveAmbiguousDependency, beanType, qualifiers);
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, String fullyQualifiedBeanType, String ... fullyQualifiedQualifiersTypes) {
        return this.project.getBeans(attemptToResolveAmbiguousDependency, fullyQualifiedBeanType, fullyQualifiedQualifiersTypes);
    }

    @Override
    public Collection<IBean> getBeans(boolean attemptToResolveAmbiguousDependency, IInjectionPoint injectionPoint) {
        return this.project.getBeans(attemptToResolveAmbiguousDependency, injectionPoint);
    }

    @Override
    public IClassBean getBeanClass(IType type) {
        return this.project.getBeanClass(type);
    }

    @Override
    public Collection<IBean> getBeans(IPath path) {
        if (path.equals((Object)this.file.getFullPath())) {
            return this.beans;
        }
        return this.project.getBeans(path);
    }

    @Override
    public Collection<IBean> getBeans(IJavaElement element) {
        if (element.getResource() != null && element.getResource().getFullPath().equals((Object)this.file.getFullPath())) {
            HashSet<IBean> result = new HashSet<IBean>();
            for (IBean bean : this.beans) {
                if (!(bean instanceof IJavaReference) || !((IJavaReference)bean).getSourceMember().equals(element)) continue;
                result.add(bean);
            }
            return result;
        }
        return this.project.getBeans(element);
    }

    @Override
    public IQualifier[] getQualifiers() {
        return this.project.getQualifiers();
    }

    @Override
    public IStereotype[] getStereotypes() {
        return this.project.getStereotypes();
    }

    @Override
    public IBean[] getAlternatives() {
        return this.project.getAlternatives();
    }

    @Override
    public IDecorator[] getDecorators() {
        return this.project.getDecorators();
    }

    @Override
    public IInterceptor[] getInterceptors() {
        return this.project.getInterceptors();
    }

    @Override
    public IStereotype getStereotype(String qualifiedName) {
        return this.project.getStereotype(qualifiedName);
    }

    @Override
    public IStereotype getStereotype(IPath path) {
        if (path.equals((Object)this.file.getFullPath())) {
            return this.stereotype;
        }
        return this.project.getStereotype(path);
    }

    @Override
    public IStereotype getStereotype(IType type) {
        return this.getStereotype(type.getPath());
    }

    @Override
    public IInterceptorBinding[] getInterceptorBindings() {
        return this.project.getInterceptorBindings();
    }

    @Override
    public IInterceptorBinding getInterceptorBinding(String qualifiedName) {
        return this.project.getInterceptorBinding(qualifiedName);
    }

    @Override
    public IInterceptorBinding getInterceptorBinding(IPath path) {
        if (path.equals((Object)this.file.getFullPath())) {
            return this.interceptorBinding;
        }
        return this.project.getInterceptorBinding(path);
    }

    @Override
    public IQualifier getQualifier(String qualifiedName) {
        return this.project.getQualifier(qualifiedName);
    }

    @Override
    public IQualifier getQualifier(IPath path) {
        if (path.equals((Object)this.file.getFullPath())) {
            return this.qualifier;
        }
        return this.project.getQualifier(path);
    }

    @Override
    public Collection<String> getScopeNames() {
        return this.project.getScopeNames();
    }

    @Override
    public IScope getScope(String qualifiedName) {
        return this.project.getScope(qualifiedName);
    }

    @Override
    public IScope getScope(IPath path) {
        if (path.equals((Object)this.file.getFullPath())) {
            return this.scope;
        }
        return this.project.getScope(path);
    }

    @Override
    public Collection<IObserverMethod> resolveObserverMethods(IInjectionPoint injectionPoint) {
        return this.project.resolveObserverMethods(injectionPoint);
    }

    @Override
    public Collection<IInjectionPoint> findObservedEvents(IParameter observedEventParameter) {
        return this.project.findObservedEvents(observedEventParameter);
    }

    @Override
    public Collection<IBean> resolve(Collection<IBean> beans) {
        return this.project.resolve(beans);
    }

    @Override
    public Collection<IBeanMethod> resolveDisposers(IProducerMethod producer) {
        return this.project.resolveDisposers(producer);
    }

    @Override
    public boolean isScope(IType annotationType) {
        return this.project.isScope(annotationType);
    }

    @Override
    public boolean isNormalScope(IType annotationType) {
        return this.project.isNormalScope(annotationType);
    }

    @Override
    public boolean isPassivatingScope(IType annotationType) {
        return this.project.isPassivatingScope(annotationType);
    }

    @Override
    public boolean isQualifier(IType annotationType) {
        return this.project.isQualifier(annotationType);
    }

    @Override
    public boolean isStereotype(IType annotationType) {
        return this.project.isStereotype(annotationType);
    }

    @Override
    public List<INodeReference> getAlternativeClasses() {
        return this.project.getAlternativeClasses();
    }

    @Override
    public List<INodeReference> getAlternativeStereotypes() {
        return this.project.getAlternativeStereotypes();
    }

    @Override
    public List<INodeReference> getAlternatives(String fullyQualifiedTypeName) {
        return this.project.getAlternatives(fullyQualifiedTypeName);
    }

    @Override
    public List<INodeReference> getDecoratorClasses() {
        return this.project.getDecoratorClasses();
    }

    @Override
    public List<INodeReference> getDecoratorClasses(String fullyQualifiedTypeName) {
        return this.project.getDecoratorClasses(fullyQualifiedTypeName);
    }

    @Override
    public List<INodeReference> getInterceptorClasses() {
        return this.project.getInterceptorClasses();
    }

    @Override
    public List<INodeReference> getInterceptorClasses(String fullyQualifiedTypeName) {
        return this.project.getInterceptorClasses(fullyQualifiedTypeName);
    }

    @Override
    public Collection<IInjectionPoint> getInjections(String fullyQualifiedTypeName) {
        return this.project.getInjections(fullyQualifiedTypeName);
    }

    @Override
    public CDICoreNature getNature() {
        return this.project.getNature();
    }

    @Override
    public void setNature(CDICoreNature n) {
    }

    @Override
    public void update(boolean updateDependent) {
    }

    @Override
    public ICDIProject getCDIProject() {
        return this;
    }

    @Override
    public ICDIProject getDeclaringProject() {
        return ((ICDIElement)((Object)this.project)).getDeclaringProject();
    }

    @Override
    public IPath getSourcePath() {
        return this.getResource().getFullPath();
    }

    @Override
    public IResource getResource() {
        return this.getNature().getProject();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getElementName() {
        return this.getNature().getProject().getName();
    }

    @Override
    public boolean isTypeAlternative(String qualifiedName) {
        return this.project.isTypeAlternative(qualifiedName);
    }

    @Override
    public boolean isStereotypeAlternative(String qualifiedName) {
        return this.project.isStereotypeAlternative(qualifiedName);
    }

    @Override
    public boolean isClassAlternativeActivated(String fullQualifiedTypeName) {
        return this.project.isClassAlternativeActivated(fullQualifiedTypeName);
    }

    @Override
    public int getId() {
        return ((ICDIElement)((Object)this.project)).getId();
    }
}

