/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.builder.BuildDebugHook;
import org.eclipse.m2e.core.internal.builder.BuildProblemInfo;
import org.eclipse.m2e.core.internal.builder.DeltaProvider;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant2;
import org.eclipse.m2e.core.internal.builder.MavenBuilder;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.AbstractEclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.EclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.EclipseEmptyBuildContext;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.EclipseIncrementalBuildContext;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class MavenBuilderImpl {
    private static Logger log = LoggerFactory.getLogger(MavenBuilderImpl.class);
    public static QualifiedName BUILD_CONTEXT_KEY = new QualifiedName("org.eclipse.m2e.core", "BuildContext");
    private static final String BUILD_PARTICIPANT_ID_ATTR_NAME = "buildParticipantId";
    private final DeltaProvider deltaProvider;

    public MavenBuilderImpl(DeltaProvider deltaProvider) {
        this.deltaProvider = deltaProvider;
    }

    public MavenBuilderImpl() {
        this(new DeltaProvider(){

            @Override
            public IResourceDelta getDelta(IProject project) {
                return null;
            }
        });
    }

    public Set<IProject> build(MavenSession session, IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IProgressMonitor monitor) throws CoreException {
        LinkedHashMap<Throwable, MojoExecutionKey> buildErrors;
        AbstractEclipseBuildContext buildContext;
        IProject project;
        MavenProject mavenProject;
        HashSet<IProject> dependencies;
        Collection<BuildDebugHook> debugHooks;
        block20: {
            debugHooks = MavenBuilder.getDebugHooks();
            dependencies = new HashSet<IProject>();
            mavenProject = projectFacade.getMavenProject();
            project = projectFacade.getProject();
            IResourceDelta delta = this.getDeltaProvider().getDelta(project);
            HashMap<String, Object> contextState = (HashMap<String, Object>)project.getSessionProperty(BUILD_CONTEXT_KEY);
            if (delta != null && contextState != null && (10 == kind || 9 == kind)) {
                buildContext = new EclipseIncrementalBuildContext(delta, contextState);
            } else {
                contextState = new HashMap<String, Object>();
                project.setSessionProperty(BUILD_CONTEXT_KEY, contextState);
                buildContext = 65536 == kind ? new EclipseEmptyBuildContext(project, contextState) : new EclipseBuildContext(project, contextState);
            }
            this.debugBuildStart(debugHooks, projectFacade, kind, args, participants, delta, monitor);
            buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
            ThreadBuildContext.setThreadBuildContext((BuildContext)buildContext);
            MavenProjectMutableState snapshot = MavenProjectMutableState.takeSnapshot(mavenProject);
            try {
                try {
                    for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : participants.entrySet()) {
                        MojoExecutionKey mojoExecutionKey = entry.getKey();
                        for (InternalBuildParticipant internalBuildParticipant : entry.getValue()) {
                            LinkedHashSet<File> debugRefreshFiles;
                            block18: {
                                debugRefreshFiles = !debugHooks.isEmpty() ? new LinkedHashSet<File>(buildContext.getFiles()) : null;
                                log.debug("Executing build participant {} for plugin execution {}", (Object)internalBuildParticipant.getClass().getName(), (Object)mojoExecutionKey.toString());
                                String stringMojoExecutionKey = mojoExecutionKey.getKeyString();
                                buildContext.setCurrentBuildParticipantId(String.valueOf(stringMojoExecutionKey) + "-" + internalBuildParticipant.getClass().getName());
                                internalBuildParticipant.setMavenProjectFacade(projectFacade);
                                internalBuildParticipant.setGetDeltaCallback(this.getDeltaProvider());
                                internalBuildParticipant.setSession(session);
                                internalBuildParticipant.setBuildContext(buildContext);
                                if (internalBuildParticipant instanceof InternalBuildParticipant2) {
                                    ((InternalBuildParticipant2)internalBuildParticipant).setArgs(args);
                                }
                                long executionStartTime = System.currentTimeMillis();
                                try {
                                    try {
                                        Set<IProject> sub;
                                        if (this.isApplicable(internalBuildParticipant, kind, delta) && (sub = internalBuildParticipant.build(kind, monitor)) != null) {
                                            dependencies.addAll(sub);
                                        }
                                    }
                                    catch (Exception e) {
                                        log.debug("Exception in build participant {}", (Object)internalBuildParticipant.getClass().getName(), (Object)e);
                                        buildErrors.put(e, mojoExecutionKey);
                                        log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{internalBuildParticipant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                        internalBuildParticipant.setMavenProjectFacade(null);
                                        internalBuildParticipant.setGetDeltaCallback(null);
                                        internalBuildParticipant.setSession(null);
                                        internalBuildParticipant.setBuildContext(null);
                                        if (internalBuildParticipant instanceof InternalBuildParticipant2) {
                                            ((InternalBuildParticipant2)internalBuildParticipant).setArgs(Collections.<String, String>emptyMap());
                                        }
                                        this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                        break block18;
                                    }
                                }
                                catch (Throwable throwable) {
                                    log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{internalBuildParticipant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                    internalBuildParticipant.setMavenProjectFacade(null);
                                    internalBuildParticipant.setGetDeltaCallback(null);
                                    internalBuildParticipant.setSession(null);
                                    internalBuildParticipant.setBuildContext(null);
                                    if (internalBuildParticipant instanceof InternalBuildParticipant2) {
                                        ((InternalBuildParticipant2)internalBuildParticipant).setArgs(Collections.<String, String>emptyMap());
                                    }
                                    this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                    throw throwable;
                                }
                                log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{internalBuildParticipant.getClass().getName(), mojoExecutionKey.toString(), System.currentTimeMillis() - executionStartTime});
                                internalBuildParticipant.setMavenProjectFacade(null);
                                internalBuildParticipant.setGetDeltaCallback(null);
                                internalBuildParticipant.setSession(null);
                                internalBuildParticipant.setBuildContext(null);
                                if (internalBuildParticipant instanceof InternalBuildParticipant2) {
                                    ((InternalBuildParticipant2)internalBuildParticipant).setArgs(Collections.<String, String>emptyMap());
                                }
                                this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                            }
                            this.debugBuildParticipant(debugHooks, projectFacade, mojoExecutionKey, (AbstractBuildParticipant)internalBuildParticipant, this.diff(debugRefreshFiles, buildContext.getFiles()), monitor);
                        }
                    }
                }
                catch (Exception e) {
                    buildErrors.put(e, null);
                    snapshot.restore(mavenProject);
                    ThreadBuildContext.setThreadBuildContext(null);
                    break block20;
                }
            }
            catch (Throwable throwable) {
                snapshot.restore(mavenProject);
                ThreadBuildContext.setThreadBuildContext(null);
                throw throwable;
            }
            snapshot.restore(mavenProject);
            ThreadBuildContext.setThreadBuildContext(null);
        }
        this.refreshResources(project, buildContext, monitor);
        MavenExecutionResult result = session.getResult();
        this.processBuildResults(project, mavenProject, result, buildContext, buildErrors);
        this.debugBuildEnd(debugHooks, projectFacade, buildContext, monitor);
        return dependencies;
    }

    private void debugBuildParticipant(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, MojoExecutionKey mojoExecutionKey, AbstractBuildParticipant participant, Set<File> files, IProgressMonitor monitor) {
        for (BuildDebugHook hook : hooks) {
            hook.buildParticipant(projectFacade, mojoExecutionKey, participant, files, monitor);
        }
    }

    private Set<File> diff(Set<File> before, Set<File> after) {
        if (before == null) {
            return after;
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>(after);
        result.removeAll(before);
        return result;
    }

    private void debugBuildStart(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IResourceDelta delta, IProgressMonitor monitor) {
        for (BuildDebugHook hook : hooks) {
            hook.buildStart(projectFacade, kind, args, participants, delta, monitor);
        }
    }

    private void debugBuildEnd(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, AbstractEclipseBuildContext buildContext, IProgressMonitor monitor) {
        Iterator<BuildDebugHook> iterator = hooks.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    protected boolean isApplicable(InternalBuildParticipant participant, int kind, IResourceDelta delta) {
        return 6 == kind || delta != null || participant.callOnEmptyDelta();
    }

    private void processMavenSessionErrors(MavenSession session, MojoExecutionKey mojoExecutionKey, Map<Throwable, MojoExecutionKey> buildErrors) {
        MavenExecutionResult result = session.getResult();
        if (result.hasExceptions()) {
            for (Throwable e : result.getExceptions()) {
                buildErrors.put(e, mojoExecutionKey);
            }
            result.getExceptions().clear();
        }
    }

    private void refreshResources(IProject project, AbstractEclipseBuildContext buildContext, IProgressMonitor monitor) throws CoreException {
        for (File file : buildContext.getFiles()) {
            IPath path = MavenBuilderImpl.getProjectRelativePath(project, file);
            if (path == null) {
                log.debug("Could not get relative path for file: ", (Object)file.getAbsoluteFile());
                continue;
            }
            Object resource = !file.exists() ? project.findMember(path) : (file.isDirectory() ? project.getFolder(path) : project.getFile(path));
            if (resource == null) continue;
            this.workaroundBug368376((IResource)resource, monitor);
            resource.refreshLocal(2, monitor);
        }
    }

    void workaroundBug368376(IResource resource, IProgressMonitor monitor) throws CoreException {
        LinkedList<IContainer> parents = new LinkedList<IContainer>();
        IContainer parent2 = resource.getParent();
        while (parent2 != null && !parent2.isSynchronized(0)) {
            parents.add(0, parent2);
            parent2 = parent2.getParent();
        }
        for (IContainer parent2 : parents) {
            parent2.refreshLocal(1, monitor);
        }
    }

    public static IPath getProjectRelativePath(IProject project, File file) {
        if (project == null || file == null) {
            return null;
        }
        IPath projectPath = project.getLocation();
        if (projectPath == null) {
            return null;
        }
        Path filePath = new Path(file.getAbsolutePath());
        if (!projectPath.isPrefixOf((IPath)filePath)) {
            return null;
        }
        return filePath.removeFirstSegments(projectPath.segmentCount());
    }

    /*
     * WARNING - void declaration
     */
    private void processBuildResults(IProject project, MavenProject mavenProject, MavenExecutionResult result, AbstractEclipseBuildContext buildContext, Map<Throwable, MojoExecutionKey> buildErrors) {
        String buildParticipantId;
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        for (Map.Entry<String, List<File>> entry : buildContext.getRemoveMessages().entrySet()) {
            buildParticipantId = entry.getKey();
            for (File file : entry.getValue()) {
                this.deleteBuildParticipantMarkers(project, markerManager, file, buildParticipantId);
            }
        }
        for (Map.Entry<String, List<Object>> entry : buildContext.getMessages().entrySet()) {
            buildParticipantId = entry.getKey();
            for (AbstractEclipseBuildContext.Message message : entry.getValue()) {
                this.addBuildParticipantMarker(project, markerManager, message, buildParticipantId);
                if (message.cause == null || !buildErrors.containsKey(message.cause)) continue;
                buildErrors.remove(message.cause);
            }
        }
        for (Throwable throwable : buildErrors.keySet()) {
            void var10_20;
            MojoExecutionKey mojoExecutionKey = buildErrors.get(throwable);
            if (mojoExecutionKey != null) {
                SourceLocation sourceLocation = SourceLocationHelper.findLocation(mavenProject, mojoExecutionKey);
            } else {
                SourceLocation sourceLocation = new SourceLocation(1, 0, 0);
            }
            BuildProblemInfo problem = new BuildProblemInfo(throwable, mojoExecutionKey, (SourceLocation)var10_20);
            markerManager.addErrorMarker((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", problem);
        }
        if (result.hasExceptions()) {
            markerManager.addMarkers((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", result);
        }
    }

    private void deleteBuildParticipantMarkers(IProject project, IMavenMarkerManager markerManager, File file, String buildParticipantId) {
        IPath path = MavenBuilderImpl.getProjectRelativePath(project, file);
        IResource resource = null;
        if (path != null) {
            resource = project.findMember(path);
        }
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        try {
            markerManager.deleteMarkers(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", BUILD_PARTICIPANT_ID_ATTR_NAME, buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addBuildParticipantMarker(IProject project, IMavenMarkerManager markerManager, AbstractEclipseBuildContext.Message buildMessage, String buildParticipantId) {
        IPath path = MavenBuilderImpl.getProjectRelativePath(project, buildMessage.file);
        IResource resource = null;
        if (path != null) {
            resource = project.findMember(path);
        }
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        int at = buildParticipantId.lastIndexOf(45);
        String pluginExecutionKey = buildParticipantId.substring(0, at);
        String message = String.valueOf(buildMessage.message) + " (" + pluginExecutionKey + ')';
        IMarker marker = markerManager.addMarker(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", message, buildMessage.line, buildMessage.severity);
        try {
            marker.setAttribute(BUILD_PARTICIPANT_ID_ATTR_NAME, (Object)buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void clean(MavenSession session, IMavenProjectFacade projectFacade, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IProgressMonitor monitor) throws CoreException {
        EclipseBuildContext buildContext;
        LinkedHashMap<Throwable, MojoExecutionKey> buildErrors;
        IProject project;
        MavenProject mavenProject;
        block12: {
            mavenProject = projectFacade.getMavenProject();
            project = projectFacade.getProject();
            project.setSessionProperty(BUILD_CONTEXT_KEY, null);
            buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
            HashMap<String, Object> contextState = new HashMap<String, Object>();
            buildContext = new EclipseBuildContext(project, contextState);
            ThreadBuildContext.setThreadBuildContext((BuildContext)buildContext);
            try {
                try {
                    for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : participants.entrySet()) {
                        MojoExecutionKey mojoExecutionKey = entry.getKey();
                        for (InternalBuildParticipant internalBuildParticipant : entry.getValue()) {
                            String stringMojoExecutionKey = mojoExecutionKey.getKeyString();
                            buildContext.setCurrentBuildParticipantId(String.valueOf(stringMojoExecutionKey) + "-" + internalBuildParticipant.getClass().getName());
                            internalBuildParticipant.setMavenProjectFacade(projectFacade);
                            internalBuildParticipant.setGetDeltaCallback(this.getDeltaProvider());
                            internalBuildParticipant.setSession(session);
                            internalBuildParticipant.setBuildContext(buildContext);
                            try {
                                try {
                                    internalBuildParticipant.clean(monitor);
                                }
                                catch (Exception e) {
                                    log.debug("Exception in build participant", (Throwable)e);
                                    buildErrors.put(e, mojoExecutionKey);
                                    internalBuildParticipant.setMavenProjectFacade(null);
                                    internalBuildParticipant.setGetDeltaCallback(null);
                                    internalBuildParticipant.setSession(null);
                                    internalBuildParticipant.setBuildContext(null);
                                    this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                internalBuildParticipant.setMavenProjectFacade(null);
                                internalBuildParticipant.setGetDeltaCallback(null);
                                internalBuildParticipant.setSession(null);
                                internalBuildParticipant.setBuildContext(null);
                                this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                                throw throwable;
                            }
                            internalBuildParticipant.setMavenProjectFacade(null);
                            internalBuildParticipant.setGetDeltaCallback(null);
                            internalBuildParticipant.setSession(null);
                            internalBuildParticipant.setBuildContext(null);
                            this.processMavenSessionErrors(session, mojoExecutionKey, buildErrors);
                        }
                    }
                }
                catch (Exception e) {
                    buildErrors.put(e, null);
                    ThreadBuildContext.setThreadBuildContext(null);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                ThreadBuildContext.setThreadBuildContext(null);
                throw throwable;
            }
            ThreadBuildContext.setThreadBuildContext(null);
        }
        this.refreshResources(project, buildContext, monitor);
        MavenExecutionResult result = session.getResult();
        this.processBuildResults(project, mavenProject, result, buildContext, buildErrors);
    }

    DeltaProvider getDeltaProvider() {
        return this.deltaProvider;
    }
}

