/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class Bundles {
    private static Bundle findDependencyBundle(Bundle bundle, String dependencyName, Set<Bundle> visited) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        ArrayList dependencies = new ArrayList();
        dependencies.addAll(bundleWiring.getRequiredWires("osgi.wiring.bundle"));
        dependencies.addAll(bundleWiring.getRequiredWires("osgi.wiring.package"));
        for (BundleWire wire : dependencies) {
            Bundle requiredBundle = wire.getProviderWiring().getBundle();
            if (requiredBundle == null || !visited.add(requiredBundle)) continue;
            if (dependencyName.equals(requiredBundle.getSymbolicName())) {
                return requiredBundle;
            }
            Bundle required = Bundles.findDependencyBundle(requiredBundle, dependencyName, visited);
            if (required == null) continue;
            return required;
        }
        return null;
    }

    public static Bundle findDependencyBundle(Bundle bundle, String dependencyId) {
        return Bundles.findDependencyBundle(bundle, dependencyId, new HashSet<Bundle>());
    }

    public static ClassLoader getBundleClassloader(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        return bundleWiring.getClassLoader();
    }
}

