/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.hibernate.configurators;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.jboss.tools.maven.ui.Activator;

public class HibernateProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String HIBERNATE_GROUP_ID = "org.hibernate";
    private static final String HIBERNATE_ARTIFACT_ID_PREFIX = "hibernate";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.isHibernateConfigurable(mavenProject) || project.hasNature("org.hibernate.eclipse.console.hibernateNature")) {
            return;
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature") && this.isHibernateProject(mavenProject)) {
            boolean enabled;
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
            if (node != null && (enabled = node.getBoolean("hibernate3.enabled", false))) {
                return;
            }
            ProjectUtils.toggleHibernateOnProject((IProject)project, (boolean)true, (String)project.getName());
        }
    }

    private boolean isHibernateConfigurable(MavenProject mavenProject) {
        boolean configureHibernate;
        String hibernateActivation = mavenProject.getProperties().getProperty("m2e.hibernate.activation");
        if (hibernateActivation == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            configureHibernate = store.getBoolean("configureHibernate");
        } else {
            configureHibernate = Boolean.valueOf(hibernateActivation);
        }
        return configureHibernate;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            this.configureInternal(mavenProject, project, monitor);
        }
    }

    private boolean isHibernateProject(MavenProject mavenProject) {
        ScopeArtifactFilter filter = new ScopeArtifactFilter("test");
        for (Artifact artifact : mavenProject.getArtifacts()) {
            String artifactId;
            String groupId;
            if (!filter.include(artifact) || !HIBERNATE_GROUP_ID.equals(groupId = artifact.getGroupId()) || (artifactId = artifact.getArtifactId()) == null || !artifactId.startsWith(HIBERNATE_ARTIFACT_ID_PREFIX)) continue;
            return true;
        }
        return false;
    }
}

