/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.quickfix;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.ws.jaxrs.ui.JBossJaxrsUIPlugin;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public abstract class AbstractAnnotationMarkerResolution
extends BaseMarkerResolution {
    private final IType type;
    private final String annotationName;
    private final String annotationValue;
    private final int editMode;
    public static final int ADD = 0;
    public static final int UPDATE = 1;

    public AbstractAnnotationMarkerResolution(IType type, String annotationName, String annotationValue, int editMode, String label) {
        super(type.getCompilationUnit());
        this.type = type;
        this.annotationName = annotationName;
        this.annotationValue = String.valueOf('(') + annotationValue + ')';
        this.editMode = editMode;
        this.label = label;
        this.init();
    }

    public CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        try {
            if (this.editMode == 0) {
                MarkerResolutionUtils.addAnnotation((String)this.annotationName, (ICompilationUnit)compilationUnit, (IJavaElement)this.type, (String)this.annotationValue, (MultiTextEdit)edit);
            } else {
                MarkerResolutionUtils.updateAnnotation((String)this.annotationName, (ICompilationUnit)compilationUnit, (IJavaElement)this.type, (String)this.annotationValue, (MultiTextEdit)edit);
            }
            String[] stringArray = this.getImports();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String importName = stringArray[n2];
                MarkerResolutionUtils.addImport((String)importName, (ICompilationUnit)compilationUnit, (MultiTextEdit)edit);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logger.error("Failed to add '@" + this.annotationName + "' annotation on type '" + this.type.getFullyQualifiedName() + "'", e);
        }
        change.setEdit((TextEdit)edit);
        return change;
    }

    public Image getImage() {
        return JBossJaxrsUIPlugin.getDefault().getImage("annotation_obj.gif");
    }

    abstract String[] getImports();
}

