/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.launcher;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ClientDelegate;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.ui.internal.launcher.JaxrsEndpointModuleArtifact;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class WSTesterClientDelegate
extends ClientDelegate {
    public boolean supports(IServer server, Object launchable, String launchMode) {
        return launchable instanceof JaxrsEndpointModuleArtifact;
    }

    public IStatus launch(IServer server, Object launchable, String launchMode, ILaunch launch) {
        if (launchable instanceof JaxrsEndpointModuleArtifact) {
            JaxrsEndpointModuleArtifact artifact = (JaxrsEndpointModuleArtifact)launchable;
            IJaxrsEndpoint endpoint = artifact.getEndpoint();
            IModule module = artifact.getModule();
            String endpointUri = this.computeEndpointURI(module, endpoint);
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = win.getActivePage();
            String id = "org.jboss.tools.ws.ui.tester.views.TestWSView";
            try {
                Class[] parmtypes;
                Class<?> c;
                Method setURL;
                IViewPart part = page.showView(id);
                if (part != null && part.getClass().getName().equalsIgnoreCase("org.jboss.tools.ws.ui.views.JAXRSWSTestView2") && (setURL = (c = part.getClass()).getDeclaredMethod("setJAXRS", parmtypes = new Class[]{String.class, String.class})) != null) {
                    Object[] arglist = new Object[]{endpointUri, endpoint.getHttpMethod().getHttpVerb()};
                    setURL.invoke((Object)part, arglist);
                }
            }
            catch (Exception e) {
                Logger.error("Failed to open WS Tester", e);
                return new Status(4, "org.jboss.tools.ws.jaxrs.ui", "Failed to launch WS Tester", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private String computeEndpointURI(IModule module, IJaxrsEndpoint endpoint) {
        String uriPathTemplate = endpoint.getUriPathTemplate();
        if (!uriPathTemplate.startsWith("/")) {
            uriPathTemplate = "/" + uriPathTemplate;
        }
        String fullUriPathTemplate = String.valueOf(module.getName()) + uriPathTemplate;
        IServer[] servers = ServerUtil.getServersByModule((IModule)module, null);
        if (servers == null || servers.length == 0) {
            return "http://[domain]:[port]/" + fullUriPathTemplate;
        }
        String domain = servers[0].getHost();
        String webport = servers[0].getAttribute("org.jboss.ide.eclipse.as.core.server.webPort", "8080");
        return "http://" + domain + ':' + webport + "/" + fullUriPathTemplate;
    }
}

