/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementChangedBuildJob;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.JavaElementDelta;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriMappingsContentProvider;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class UriPathTemplateCategory
implements ITreeContentProvider {
    private final IJavaProject javaProject;
    private final UriMappingsContentProvider parent;
    private final Map<IJaxrsEndpoint, UriPathTemplateElement> wrapperCache = new HashMap<IJaxrsEndpoint, UriPathTemplateElement>();

    public UriPathTemplateCategory(UriMappingsContentProvider parent, IProject project) {
        this(parent, JavaCore.create((IProject)project));
    }

    public UriPathTemplateCategory(UriMappingsContentProvider parent, IJavaProject javaProject) {
        this.parent = parent;
        this.javaProject = javaProject;
    }

    public Object[] getChildren(Object parentElement) {
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null && !metamodel.isInitializing()) {
                Collection endpoints = metamodel.getAllEndpoints();
                Logger.debug("UriPathTemplateCategory contains {} endpoints", endpoints.size());
                ArrayList<UriPathTemplateElement> uriPathTemplateElements = new ArrayList<UriPathTemplateElement>();
                for (IJaxrsEndpoint endpoint : endpoints) {
                    UriPathTemplateElement element = this.getUriPathTemplateElement(endpoint);
                    uriPathTemplateElements.add(element);
                }
                return uriPathTemplateElements.toArray();
            }
            if (metamodel != null && metamodel.isInitializing()) {
                Logger.debug("Displaying the 'Loading...' stub for project '{}' and launching a build", this.javaProject.getElementName());
                return new Object[]{new UriMappingsContentProvider.LoadingStub(this.javaProject)};
            }
            Logger.debug("*** There's no JAX-RS Metamodel for project '{}' -> no element to display ***", this.javaProject.getElementName());
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve JAX-RS Metamodel in project '" + this.javaProject.getElementName() + "'", e);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return this.javaProject.getProject();
    }

    public final IProject getProject() {
        return this.javaProject.getProject();
    }

    public final IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public boolean hasChildren(Object element) {
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null && !metamodel.isInitializing()) {
                Collection endpoints = metamodel.getAllEndpoints();
                Logger.debug("UriPathTemplateCategory has endpoints: {}", !endpoints.isEmpty());
                return !endpoints.isEmpty();
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve JAX-RS Metamodel in project '" + this.javaProject.getElementName() + "'", e);
        }
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public UriPathTemplateElement getUriPathTemplateElement(IJaxrsEndpoint endpoint) {
        if (this.wrapperCache.containsKey(endpoint)) {
            return this.wrapperCache.get(endpoint);
        }
        Logger.trace("Creating element for endpoint '{}' (was not found in wrapperCache)", endpoint);
        UriPathTemplateElement element = new UriPathTemplateElement(endpoint, this);
        this.wrapperCache.put(endpoint, element);
        return element;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Logger.debug("Input changed in UriPathTemplateCategory");
    }

    public int getProblemLevel() {
        int level = 0;
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null) {
                level = metamodel.getProblemSeverity();
                for (IJaxrsEndpoint endpoint : metamodel.getAllEndpoints()) {
                    level = Math.max(level, endpoint.getProblemLevel());
                }
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to determine the problem severity for the JAX-RS Web Services", e);
        }
        return level;
    }

    public void dispose() {
    }

    public void refreshContent() {
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject, (boolean)true);
            if (metamodel != null) {
                JavaElementDelta delta = new JavaElementDelta((IJavaElement)this.javaProject, null, 1, 0);
                ElementChangedEvent event = new ElementChangedEvent((IJavaElementDelta)delta, 4);
                JavaElementChangedBuildJob job = new JavaElementChangedBuildJob(event);
                job.setRule(this.javaProject.getProject().getWorkspace().getRuleFactory().buildRule());
                job.schedule();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter((IJaxrsMetamodel)metamodel){
                    private final /* synthetic */ IJaxrsMetamodel val$metamodel;
                    {
                        this.val$metamodel = iJaxrsMetamodel;
                    }

                    public void done(IJobChangeEvent event) {
                        UriPathTemplateCategory.this.parent.refreshContent(this.val$metamodel);
                    }
                });
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to determine the problem severity for the JAX-RS Web Services", e);
        }
    }

    public String toString() {
        return "UriPathTemplateCategory on project '" + this.javaProject.getElementName() + "'";
    }
}

