/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.livereload.core.internal.util.Logger;

public class ProjectUtils {
    public static IProject extractProject(String fileLocation) {
        try {
            IFile[] filesForLocation;
            URI fileURI = new URI(fileLocation);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] iFileArray = filesForLocation = root.findFilesForLocationURI(fileURI);
            int n = filesForLocation.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    return file.getProject();
                }
                ++n2;
            }
        }
        catch (URISyntaxException e) {
            Logger.error("Failed to convert given file location into an URI:" + fileLocation, e);
        }
        Logger.warn("Unable to retrieve project from file location:" + fileLocation);
        return null;
    }

    public static IProject findProjectFromAbsolutePath(IPath file) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().isPrefixOf(file)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static IProject findProjectFromResourceLocation(IPath file) {
        IPath relativePath = file.makeRelative();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (new Path(project.getName()).isPrefixOf(relativePath)) {
                return project;
            }
            ++n2;
        }
        return null;
    }
}

