/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.forge.core.internal.ForgeCorePlugin;
import org.jboss.tools.forge.core.internal.runtime.ForgeAbstractRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeType;
import org.osgi.framework.Bundle;

public class ForgeEmbeddedRuntime
extends ForgeAbstractRuntime {
    public static final ForgeRuntime INSTANCE = new ForgeEmbeddedRuntime();
    private String location = null;

    private ForgeEmbeddedRuntime() {
    }

    @Override
    public final String getName() {
        return String.valueOf(this.getVersion()) + " - " + this.getType().toString().toLowerCase();
    }

    @Override
    public String getLocation() {
        if (this.location == null) {
            this.initLocation();
        }
        return this.location;
    }

    private void initLocation() {
        try {
            File file = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.jboss.tools.forge.runtime"));
            String[] stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (str.startsWith("forge-distribution-")) {
                    this.location = String.valueOf(file.getCanonicalPath()) + File.separator + str;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            ForgeCorePlugin.log(e);
        }
    }

    @Override
    public ForgeRuntimeType getType() {
        return ForgeRuntimeType.EMBEDDED;
    }
}

