/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.furnace;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.tools.forge.core.furnace.FurnaceProvider;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.core.internal.ForgeCorePlugin;
import org.jboss.tools.forge.core.internal.helper.ForgeHelper;
import org.jboss.tools.forge.core.io.ForgeOutputListener;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeType;
import org.osgi.framework.Bundle;

public class FurnaceRuntime
implements ForgeRuntime {
    public static final FurnaceRuntime INSTANCE = new FurnaceRuntime();
    private ForgeRuntimeState state = ForgeRuntimeState.STOPPED;
    private String location = null;
    private String version = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private FurnaceRuntime() {
    }

    @Override
    public String getName() {
        return String.valueOf(this.getVersion()) + " - " + this.getType().toString().toLowerCase();
    }

    @Override
    public String getLocation() {
        if (this.location == null) {
            this.initLocation();
        }
        return this.location;
    }

    @Override
    public ForgeRuntimeType getType() {
        return ForgeRuntimeType.EMBEDDED;
    }

    @Override
    public ForgeRuntimeState getState() {
        return this.state;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = this.initializeVersion();
        }
        return this.version;
    }

    @Override
    public void start(IProgressMonitor progressMonitor) {
        block5: {
            ForgeHelper.sendStartEvent(this);
            if (progressMonitor == null) {
                progressMonitor = new NullProgressMonitor();
            }
            try {
                String taskName = "Please wait while Forge " + this.getVersion() + " is started.";
                progressMonitor.beginTask(taskName, -1);
                this.setNewState(ForgeRuntimeState.STARTING);
                FurnaceProvider.INSTANCE.startFurnace();
                progressMonitor.worked(1);
                while (FurnaceService.INSTANCE.getContainerStatus().isStarting()) {
                    if (progressMonitor.isCanceled()) {
                        FurnaceService.INSTANCE.stop();
                        this.setNewState(ForgeRuntimeState.STOPPED);
                        continue;
                    }
                    Thread.sleep(1000L);
                    progressMonitor.worked(1);
                }
                FurnaceService.INSTANCE.waitUntilContainerIsStarted();
                FurnaceRuntime.getAllCandidatesAsMap();
                this.setNewState(ForgeRuntimeState.RUNNING);
            }
            catch (InterruptedException interruptedException) {
                if (!progressMonitor.isCanceled()) break block5;
                FurnaceService.INSTANCE.stop();
                this.setNewState(ForgeRuntimeState.STOPPED);
            }
        }
    }

    @Override
    public void stop(IProgressMonitor progressMonitor) {
        this.setNewState(ForgeRuntimeState.STOPPED);
        FurnaceService.INSTANCE.stop();
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void sendInput(String str) {
    }

    @Override
    public String sendCommand(String str) {
        return null;
    }

    @Override
    public void addOutputListener(ForgeOutputListener outputListener) {
    }

    @Override
    public void removeOutputListener(ForgeOutputListener outputListener) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void setNewState(ForgeRuntimeState newState) {
        ForgeRuntimeState oldState = this.state;
        this.state = newState;
        this.propertyChangeSupport.firePropertyChange("org.jboss.tools.forge.runtime.state", (Object)oldState, (Object)this.state);
    }

    private static Map<String, UICommand> getAllCandidatesAsMap() {
        TreeMap<String, UICommand> result = new TreeMap<String, UICommand>();
        Imported<UICommand> instances = FurnaceService.INSTANCE.lookupImported(UICommand.class);
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            UICommand cfr_ignored_0 = (UICommand)iterator.next();
        }
        return result;
    }

    private String initializeVersion() {
        String[] candidates;
        String result = "unknown version";
        String location = this.getLocation();
        if (location == null) {
            return result;
        }
        File file = new File(location = String.valueOf(location) + "/lib");
        if (!file.exists()) {
            return result;
        }
        String[] stringArray = candidates = file.list();
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            String candidate = stringArray[n2];
            if (candidate.startsWith("shell-spi-") && (end = candidate.indexOf(".jar")) != -1) {
                result = candidate.substring("shell-spi-".length(), end);
            }
            ++n2;
        }
        return result;
    }

    private void initLocation() {
        try {
            this.location = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.jboss.tools.forge2.runtime")).getCanonicalPath();
        }
        catch (IOException e) {
            ForgeCorePlugin.log(e);
        }
    }
}

