/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.xpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.jboss.tools.common.quickfix.MarkerAnnotationInfo;
import org.jboss.tools.common.text.xml.TextXMLMessages;

public class MarkerProblemAnnotationHoverProcessor
extends ProblemAnnotationHoverProcessor
implements ITextHoverExtension,
ITextHoverExtension2 {
    private IInformationControlCreator controlCreator = null;
    private static IInformationControlCreator presenterControlCreator;

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        return null;
    }

    public Object getHoverInfo2(ITextViewer viewer, IRegion hoverRegion) {
        ArrayList all = new ArrayList();
        ArrayList<MarkerAnnotationInfo.AnnotationInfo> high = new ArrayList<MarkerAnnotationInfo.AnnotationInfo>();
        ArrayList<MarkerAnnotationInfo.AnnotationInfo> low = new ArrayList<MarkerAnnotationInfo.AnnotationInfo>();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        IAnnotationModel model = ((SourceViewer)viewer).getAnnotationModel();
        if (model != null) {
            Iterator iterator = model.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!this.isAnnotationValid(annotation) || annotations.contains(annotation)) continue;
                annotations.add(annotation);
                Position position = model.getPosition(annotation);
                if (!position.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength())) continue;
                MarkerAnnotationInfo.AnnotationInfo info = new MarkerAnnotationInfo.AnnotationInfo(annotation, position);
                if (info.isTop()) {
                    high.add(info);
                    continue;
                }
                low.add(info);
            }
            all.addAll(high);
            all.addAll(low);
        }
        if (all.size() > 0) {
            return new MarkerAnnotationInfo(all, (ISourceViewer)((SourceViewer)viewer));
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (presenterControlCreator == null) {
            presenterControlCreator = new PresenterControlCreator();
        }
        return presenterControlCreator;
    }

    protected boolean isAnnotationValid(Annotation annotation) {
        return annotation instanceof SimpleMarkerAnnotation || annotation instanceof TemporaryAnnotation;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.controlCreator == null) {
            this.controlCreator = new AnnotationHoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.controlCreator;
    }

    private static final class AnnotationHoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator presenterControlCreator;

        public AnnotationHoverControlCreator(IInformationControlCreator presenterControlCreator) {
            this.presenterControlCreator = presenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new MarkerAnnotationInformationControl(parent, EditorsUI.getTooltipAffordanceString()){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return AnnotationHoverControlCreator.this.presenterControlCreator;
                }
            };
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)control).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static class MarkerAnnotationInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private final DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        private MarkerAnnotationInfo info;
        private Composite parent;

        public MarkerAnnotationInformationControl(Shell parentShell, String str) {
            super(parentShell, str);
            this.create();
        }

        public boolean hasContents() {
            return this.info != null;
        }

        private MarkerAnnotationInfo getAnnotationInfo() {
            return this.info;
        }

        protected void createContent(Composite parent) {
            this.parent = parent;
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            parent.setLayout((Layout)layout);
        }

        public final void setVisible(boolean visible) {
            if (!visible) {
                this.disposeContent();
            }
            super.setVisible(visible);
        }

        public Point computeSizeHint() {
            Point preferedSize = this.getShell().computeSize(-1, -1, true);
            Point constrains = this.getSizeConstraints();
            if (constrains == null) {
                return preferedSize;
            }
            Point constrainedSize = this.getShell().computeSize(constrains.x, -1, true);
            int width = Math.min(preferedSize.x, constrainedSize.x);
            int height = Math.max(preferedSize.y, constrainedSize.y);
            return new Point(width, height);
        }

        public void setInput(Object input) {
            Assert.isLegal((boolean)(input instanceof MarkerAnnotationInfo));
            this.info = (MarkerAnnotationInfo)input;
            this.disposeContent();
            this.createContent();
        }

        protected void disposeContent() {
            Control[] controlArray = this.parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }

        protected void createContent() {
            boolean first = true;
            ScrolledComposite scrolledComposite = new ScrolledComposite(this.parent, 768);
            GridData gridData = new GridData(4, 4, true, true);
            scrolledComposite.setLayoutData((Object)gridData);
            scrolledComposite.setExpandVertical(false);
            scrolledComposite.setExpandHorizontal(false);
            Composite composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(1, false);
            layout.marginLeft = 5;
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            for (MarkerAnnotationInfo.AnnotationInfo info : this.getAnnotationInfo().infos) {
                List proposals;
                this.createInfo(composite, info.annotation, first);
                if (first) {
                    first = false;
                }
                if ((proposals = this.getAnnotationInfo().getCompletionProposals(info)).size() <= 0) continue;
                this.createControl(composite, proposals);
            }
            scrolledComposite.setContent((Control)composite);
            this.setDecoration((Control)scrolledComposite, this.parent.getForeground(), this.parent.getBackground(), JFaceResources.getDialogFont());
            Point contentSize = composite.computeSize(-1, -1);
            composite.setSize(contentSize);
            Point constraints = this.getSizeConstraints();
            if (constraints != null && contentSize.x < constraints.x) {
                int scrollBarHeight;
                ScrollBar horizontalBar = scrolledComposite.getHorizontalBar();
                if (horizontalBar == null) {
                    Point scrollSize = scrolledComposite.computeSize(-1, -1);
                    scrollBarHeight = scrollSize.y - contentSize.y;
                } else {
                    scrollBarHeight = horizontalBar.getSize().y;
                }
                gridData.heightHint = contentSize.y - scrollBarHeight;
            }
            this.parent.layout(true);
        }

        private void createControl(Composite parent, List<ICompletionProposal> proposals) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout2 = new GridLayout(1, false);
            layout2.verticalSpacing = 2;
            layout2.marginLeft = 5;
            composite.setLayout((Layout)layout2);
            Label separator = new Label(composite, 258);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            separator.setLayoutData((Object)gridData);
            Label quickFixLabel = new Label(composite, 0);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            layoutData.horizontalIndent = 4;
            quickFixLabel.setLayoutData((Object)layoutData);
            String text = proposals.size() == 1 ? TextXMLMessages.SINGLE_QUICK_FIX : NLS.bind((String)TextXMLMessages.MULTIPLE_QUICK_FIX, (Object)proposals.size());
            quickFixLabel.setText(text);
            this.createList(composite, proposals);
        }

        private void createList(Composite parent, List<ICompletionProposal> proposals) {
            ArrayList<Link> list = new ArrayList<Link>();
            for (ICompletionProposal proposal : proposals) {
                list.add(this.createLink(parent, proposal));
            }
        }

        private Link createLink(Composite parent, final ICompletionProposal proposal) {
            parent = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 1;
            parent.setLayout((Layout)layout);
            Label proposalImage = new Label(parent, 0);
            proposalImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Image image = proposal.getImage();
            if (image != null) {
                proposalImage.setImage(image);
                proposalImage.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        MarkerAnnotationInformationControl.this.fix(proposal, (ITextViewer)((MarkerAnnotationInformationControl)MarkerAnnotationInformationControl.this).info.viewer, ((MarkerAnnotationInfo.AnnotationInfo)((MarkerAnnotationInformationControl)MarkerAnnotationInformationControl.this).info.infos.get((int)0)).position.getOffset());
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
            }
            Link proposalLink = new Link(parent, 64);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            String linkText = proposal.getDisplayString();
            proposalLink.setText("<a>" + linkText + "</a>");
            proposalLink.setLayoutData((Object)layoutData);
            proposalLink.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    MarkerAnnotationInformationControl.this.fix(proposal, (ITextViewer)((MarkerAnnotationInformationControl)MarkerAnnotationInformationControl.this).info.viewer, ((MarkerAnnotationInfo.AnnotationInfo)((MarkerAnnotationInformationControl)MarkerAnnotationInformationControl.this).info.infos.get((int)0)).position.getOffset());
                }

                public void mouseUp(MouseEvent e) {
                }
            });
            return proposalLink;
        }

        private void fix(ICompletionProposal p, ITextViewer viewer, int offset) {
            this.dispose();
            IRewriteTarget target = null;
            try {
                IDocument document = viewer.getDocument();
                if (viewer instanceof ITextViewerExtension) {
                    ITextViewerExtension extension = (ITextViewerExtension)viewer;
                    target = extension.getRewriteTarget();
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                if (p instanceof ICompletionProposalExtension2) {
                    ((ICompletionProposalExtension2)p).apply(viewer, '\u0000', 0, offset);
                } else {
                    p.apply(document);
                }
                Point selection = p.getSelection(document);
                if (selection != null) {
                    viewer.setSelectedRange(selection.x, selection.y);
                    viewer.revealRange(selection.x, selection.y);
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }

        private void createInfo(Composite parent, final Annotation annotation, boolean firstElement) {
            if (!firstElement) {
                Label separator = new Label(parent, 258);
                GridData gridData = new GridData(4, 0x1000000, true, false);
                separator.setLayoutData((Object)gridData);
            }
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 2;
            layout.marginWidth = 2;
            layout.horizontalSpacing = 0;
            composite.setLayout((Layout)layout);
            final Canvas canvas = new Canvas(composite, 524288);
            GridData gridData = new GridData(1, 1, false, false);
            gridData.widthHint = 17;
            gridData.heightHint = 16;
            canvas.setLayoutData((Object)gridData);
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setFont(null);
                    MarkerAnnotationInformationControl.this.annotationAccess.paint(annotation, e.gc, canvas, new Rectangle(0, 0, 16, 16));
                }
            });
            StyledText text = new StyledText(composite, 74);
            GridData data = new GridData(4, 4, true, true);
            text.setLayoutData((Object)data);
            String annotationText = annotation.getText();
            if (annotationText != null) {
                text.setText(annotationText);
            }
        }

        private void setDecoration(Control control, Color foreground, Color background, Font font) {
            control.setForeground(foreground);
            control.setBackground(background);
            control.setFont(font);
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.setDecoration(child, foreground, background, font);
                    ++n2;
                }
            }
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new MarkerAnnotationInformationControl(parent, EditorsUI.getTooltipAffordanceString()){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return presenterControlCreator;
                }
            };
        }
    }
}

