/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.util;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.transform.DomUtil;
import org.jboss.tools.vpe.preview.core.transform.TransformUtil;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.util.EditorUtil;
import org.jboss.tools.vpe.preview.core.util.OS;
import org.jboss.tools.vpe.preview.core.util.PlatformUtil;
import org.jboss.tools.vpe.preview.core.util.SuitableFileExtensions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NavigationUtil {
    private static final String VPV_SELECTION_STYLE_ID = "VPV_STYLESHEET_ID";

    private NavigationUtil() {
    }

    public static void disableLinks(Browser browser) {
        if (browser != null && !browser.isDisposed()) {
            String disableHrefScript = PlatformUtil.isWindows() ? "'#'" : "'javascript: void(0);'";
            String disablerScript = "var anchors = document.getElementsByTagName('a');for (var i = 0; i < anchors.length; i++) {if (anchors[i].href.indexOf('#') == -1 || anchors[i].href.indexOf('://localhost:') == -1) {anchors[i].href = " + disableHrefScript + ";" + "anchors[i].target = '';" + "}" + "};";
            browser.execute("(setTimeout(function() { " + disablerScript + "}, 10))();");
            NavigationUtil.disableDynamic(browser, disablerScript);
        }
    }

    public static void disableInputs(Browser browser) {
        if (browser != null && !browser.isDisposed()) {
            String disablerScript = "var inputs = document.getElementsByTagName('INPUT');for (var i = 0; i < inputs.length; i++) {inputs[i].blur();inputs[i].disabled = true;}";
            String disableInputs = "function() {" + disablerScript + "}";
            OS platform = PlatformUtil.getOs();
            if (OS.WINDOWS.equals((Object)platform)) {
                browser.execute("(" + disableInputs + ")();");
            } else {
                int timeout = 30;
                if (OS.LINUX.equals((Object)platform)) {
                    timeout = 150;
                }
                browser.execute("(setTimeout(" + disableInputs + ", " + timeout + "))();");
            }
            NavigationUtil.disableDynamic(browser, disablerScript);
        }
    }

    public static void outlineSelectedElement(Browser browser, Long currentSelectionId) {
        if (browser != null && !browser.isDisposed()) {
            String styleAttributeSelector = currentSelectionId == null ? "" : "'[data-vpvid=\"" + currentSelectionId + "\"] {outline: 1px solid blue; border: 1px solid blue;  z-index: 2147483638;}'";
            String outlineJsFunction = "function() {var style=document.getElementById('VPV_STYLESHEET_ID');if (!style) {style = document.createElement('STYLE');style.type = 'text/css';}style.id = 'VPV_STYLESHEET_ID';style.innerHTML = " + styleAttributeSelector + ";" + "var head = document.head || document.getElementsByTagName('head')[0] ;" + "head.appendChild(style);" + "}";
            if (OS.WINDOWS.equals((Object)PlatformUtil.getOs())) {
                browser.execute("(" + outlineJsFunction + ")();");
            } else {
                browser.execute("(setTimeout(" + outlineJsFunction + ", 10))();");
            }
        }
    }

    public static void disableJsPopUps(Browser browser) {
        browser.execute("window.alert = function() {};window.confirm = function() {};window.prompt = function() {};window.open = function() {};");
    }

    public static String removeAnchor(String url) {
        int index = url.lastIndexOf(35);
        if (index != -1) {
            return url.substring(0, index);
        }
        return url;
    }

    public static String fixUrl(Browser browser) {
        String url = browser.getUrl();
        if (PlatformUtil.isWindows()) {
            return NavigationUtil.removeAnchor(url);
        }
        if (PlatformUtil.isMacOS()) {
            return (String)browser.evaluate("return window.location.href");
        }
        return url;
    }

    public static void navigateToVisual(IEditorPart currentEditor, Browser browser, VpvVisualModel visualModel, int x, int y) {
        String stringToEvaluate = "";
        stringToEvaluate = OS.LINUX.equals((Object)PlatformUtil.getOs()) ? "var selected = document.elementFromPoint(" + x + ", " + y + ");" + "var temp = document.createElement('div');" + "temp.appendChild(selected.cloneNode(true));" + "return temp.innerHTML;" : "return document.elementFromPoint(" + x + ", " + y + ").outerHTML;";
        String result = (String)browser.evaluate(stringToEvaluate);
        if (result != null) {
            String selectedElementId = TransformUtil.getSelectedElementId(result, "(?<=data-vpvid=\").*?(?=\")");
            Long id = selectedElementId != null && !selectedElementId.isEmpty() ? Long.valueOf(Long.parseLong(selectedElementId)) : null;
            NavigationUtil.outlineSelectedElement(browser, id);
            String fileExtension = EditorUtil.getFileExtensionFromEditor(currentEditor);
            if (SuitableFileExtensions.isHTML(fileExtension)) {
                try {
                    Node visualNode = TransformUtil.getVisualNodeByVpvId(visualModel, selectedElementId);
                    Node sourseNode = TransformUtil.getSourseNodeByVisualNode(visualModel, visualNode);
                    if (sourseNode != null && sourseNode instanceof IDOMNode) {
                        int startOffset = ((IDOMNode)sourseNode).getStartOffset();
                        int endOffset = ((IDOMNode)sourseNode).getEndOffset();
                        StructuredTextEditor editor = (StructuredTextEditor)currentEditor.getAdapter(StructuredTextEditor.class);
                        editor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                }
                catch (XPathExpressionException e) {
                    Activator.logError(e);
                }
            }
        }
    }

    public static void updateSelectionAndScrollToIt(ISelection currentSelection, Browser browser, VpvVisualModel visualModel) {
        if (currentSelection instanceof IStructuredSelection) {
            Node sourceNode = EditorUtil.getNodeFromSelection((IStructuredSelection)currentSelection);
            Long currentSelectionId = NavigationUtil.getIdForSelection(sourceNode, visualModel);
            NavigationUtil.scrollToId(browser, currentSelectionId);
            NavigationUtil.outlineSelectedElement(browser, currentSelectionId);
        }
    }

    private static void scrollToId(Browser browser, Long currentSelectionId) {
        if (browser != null && !browser.isDisposed() && currentSelectionId != null) {
            browser.execute("(setTimeout(function() {var selectedElement = document.querySelector('[data-vpvid=\"" + currentSelectionId + "\"]');" + "selectedElement.scrollIntoView(true);" + "}, 300))();");
        }
    }

    private static Long getIdForSelection(Node selectedSourceNode, VpvVisualModel visualModel) {
        Long id = null;
        if (selectedSourceNode != null && visualModel != null) {
            Map<Node, Node> sourceVisuaMapping = visualModel.getSourceVisualMapping();
            Node visualNode = null;
            Node sourceNode = selectedSourceNode;
            do {
                visualNode = sourceVisuaMapping.get(sourceNode);
                sourceNode = DomUtil.getParentNode(sourceNode);
            } while (visualNode == null && sourceNode != null);
            if (!(visualNode instanceof Element)) {
                visualNode = DomUtil.getParentNode(visualNode);
            }
            String idString = null;
            if (visualNode instanceof Element) {
                Element elementNode = (Element)visualNode;
                idString = elementNode.getAttribute("data-vpvid");
            }
            if (idString != null && !idString.isEmpty()) {
                try {
                    id = Long.parseLong(idString);
                }
                catch (NumberFormatException e) {
                    Activator.logError(e);
                }
            }
        }
        return id;
    }

    private static void disableDynamic(Browser browser, String disablerScript) {
        String script = "var observeDOM = (function(){var MutationObserver = window.MutationObserver || window.WebKitMutationObserver,eventListenerSupported = window.addEventListener;return function(obj, callback){if( MutationObserver ){var obs = new MutationObserver(function(mutations, observer){if( mutations[0].addedNodes.length || mutations[0].removedNodes.length )callback();});obs.observe( obj, { childList:true, subtree:true });}else if( eventListenerSupported ){obj.addEventListener('DOMNodeInserted', callback, false);obj.addEventListener('DOMNodeRemoved', callback, false);}}})();observeDOM( document.body ,function(){" + disablerScript + "});";
        browser.execute(script);
    }
}

