/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.template.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.preview.core.template.VpeChildrenInfo;
import org.jboss.tools.vpe.preview.core.template.VpeCreationData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualDomUtil {
    public static String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    public static String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    public static String RICH_FACES_URI = "http://richfaces.org/rich";
    public static String A4J_URI = "http://richfaces.org/a4j";
    public static String FACELETS_URI = "http://java.sun.com/jsf/facelets";
    public static final String VPE_FACET = "VPE-FACET";
    public static String FACET_JSF_TAG = "FACET-JSF-TAG";
    public static String FACET_ODD_TAGS = "FACET-ODD-TAGS";
    public static String FACET_HTML_TAGS = "FACET-HTML-TAGS";
    private static Set<String> escapedTags = new HashSet<String>();

    static {
        escapedTags.add("f:facet");
        escapedTags.add("f:selectItem");
        escapedTags.add("f:selectItems");
    }

    public static Node getAncestorNode(Node visualNode, String tagName) {
        if (tagName == null) {
            return null;
        }
        Node element = visualNode;
        do {
            if (!tagName.equalsIgnoreCase(element.getNodeName())) continue;
            return element;
        } while ((element = element.getParentNode()) != null);
        return null;
    }

    public static long getChildCount(Node node) {
        long count = 0L;
        NodeList children = node.getChildNodes();
        if (children != null) {
            count = children.getLength();
        }
        return count;
    }

    public static Node getChildNode(Node node, int index) {
        Node child = null;
        NodeList children = node.getChildNodes();
        if (children != null && index >= 0 && index < children.getLength()) {
            child = children.item(index);
        }
        return child;
    }

    public static long getOffset(Node node) {
        long offset = 0L;
        Node previousSibling = node;
        while ((previousSibling = previousSibling.getPreviousSibling()) != null) {
            ++offset;
        }
        return offset;
    }

    public static void replaceNodeByItsChildren(Node node) {
        NodeList subTableContainerChildren = node.getChildNodes();
        Node containerParent = node.getParentNode();
        if (subTableContainerChildren != null) {
            int length = subTableContainerChildren.getLength();
            int i = 0;
            while (i < length) {
                Node child = subTableContainerChildren.item(i);
                node.removeChild(child);
                containerParent.insertBefore(child, node);
                ++i;
            }
        }
        containerParent.removeChild(node);
    }

    public static void setSubAttribute(Element element, String attributeName, String subAttributeName, String subAttributeValue) {
        String attributeValue = element.getAttribute(attributeName);
        attributeValue = attributeValue == null ? "" : VisualDomUtil.deleteFromString(attributeValue, subAttributeName, ";");
        if (attributeValue.length() > 0 && !attributeValue.endsWith(";")) {
            attributeValue = String.valueOf(attributeValue) + ";";
        }
        attributeValue = String.valueOf(attributeValue) + subAttributeName + ":" + subAttributeValue + ";";
        element.setAttribute(attributeName, attributeValue);
    }

    public static String deleteFromString(String data, String begin, String end) {
        int startPosition = data.indexOf(begin);
        if (startPosition < 0) {
            return data;
        }
        int endPosition = data.indexOf(end, startPosition);
        String result = data.substring(0, startPosition).trim();
        if (endPosition > 0) {
            result = String.valueOf(result) + data.substring(endPosition + 1, data.length()).trim();
        }
        return result;
    }

    public static void copyAttributes(Node sourceNode, Element visualElement) {
        NamedNodeMap namedNodeMap = sourceNode.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attribute = namedNodeMap.item(i);
            visualElement.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
    }

    public static void copyAttribute(Element sourceElement, String sourceAttrName, Element visualElement, String visualAttrName) {
        if (sourceElement.hasAttribute(sourceAttrName)) {
            String attrValue = sourceElement.getAttribute(sourceAttrName);
            visualElement.setAttribute(visualAttrName, attrValue);
        }
    }

    public static void copyAttributes(Element sourceElement, Element visualElement, List<String> attributes) {
        for (String attributeName : attributes) {
            VisualDomUtil.copyAttribute(sourceElement, attributeName, visualElement, attributeName);
        }
    }

    public static void copyAttributes(Element sourceElement, Element visualElement, Map<String, String> sourceToVisualMap) {
        for (Map.Entry<String, String> sourceToVisual : sourceToVisualMap.entrySet()) {
            String sourceAttrName = sourceToVisual.getKey();
            String visualAttrName = sourceToVisual.getValue();
            VisualDomUtil.copyAttribute(sourceElement, sourceAttrName, visualElement, visualAttrName);
        }
    }

    public static Element createBorderlessContainer(Document visualDocument) {
        return VisualDomUtil.createBorderlessContainer(visualDocument, "span");
    }

    public static Element createBorderlessContainer(Document visualDocument, String containerName) {
        Element element = visualDocument.createElement(containerName);
        element.setAttribute("class", "vpe-text");
        return element;
    }

    public static void appendChildrenInsertionPoint(Element source, Element target, VpeCreationData creationData, Document visualDocument) {
        Element childrenContainer = VisualDomUtil.createBorderlessContainer(visualDocument);
        target.appendChild(childrenContainer);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(childrenContainer);
        NodeList childNodes = source.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            childrenInfo.addSourceChild(childNodes.item(i));
            ++i;
        }
        creationData.addChildrenInfo(childrenInfo);
    }

    public static VpeCreationData createTemplateWithTextContainer(Element sourceElement, Element templateContainer, String borderlessContainerName, Document visualDocument) {
        ArrayList<Node> children = new ArrayList<Node>();
        VpeCreationData creationData = null;
        NodeList nodeList = sourceElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (!escapedTags.contains(child.getNodeName())) {
                children.add(child);
            }
            ++i;
        }
        if (children != null && children.size() > 0) {
            Element topContainer = VisualDomUtil.createBorderlessContainer(visualDocument, borderlessContainerName);
            Element textContainer = VisualDomUtil.createBorderlessContainer(visualDocument, borderlessContainerName);
            topContainer.appendChild(textContainer);
            topContainer.appendChild(templateContainer);
            creationData = new VpeCreationData(topContainer);
            VpeChildrenInfo textInfo = new VpeChildrenInfo(textContainer);
            creationData.addChildrenInfo(textInfo);
            for (Node child : children) {
                textInfo.addSourceChild(child);
            }
        } else {
            creationData = new VpeCreationData(templateContainer);
        }
        return creationData;
    }

    public static Element findVisualTagWithFacetAttribute(Node facetsParentNode, String facetName) {
        Element tagForFacet = null;
        if (facetsParentNode != null) {
            NodeList nodeList = facetsParentNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String facetAttributeName;
                Element element = null;
                if (nodeList.item(i).getNodeType() != 1) {
                    return null;
                }
                element = (Element)nodeList.item(i);
                if (element.hasAttribute(VPE_FACET) && (facetAttributeName = element.getAttribute(VPE_FACET)).indexOf(facetName) >= 0) {
                    return element;
                }
                tagForFacet = VisualDomUtil.findVisualTagWithFacetAttribute(element, facetName);
                if (tagForFacet != null) {
                    return tagForFacet;
                }
                ++i;
            }
        }
        return tagForFacet;
    }

    public static boolean isAscendant(Node potentialAscendant, Node potentialDescendant) {
        while (potentialDescendant != null) {
            if (!potentialAscendant.equals(potentialDescendant = potentialDescendant.getParentNode())) continue;
            return true;
        }
        return false;
    }
}

