/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeConstants;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.seam.solder.core.definition.InterfaceDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.model.XModelObject;

public class DeltaspikeMessageBundleExtension
implements ICDIExtension,
IBuildParticipantFeature,
DeltaspikeConstants {
    DeltaspikeMessageBundleDefinitionContext context = new DeltaspikeMessageBundleDefinitionContext();

    public IDefinitionContextExtension getContext() {
        return this.context;
    }

    public void beginVisiting() {
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
    }

    public void visit(IFile file, IPath src, IPath webinf) {
    }

    public void buildDefinitions() {
    }

    public void buildDefinitions(FileSet fileSet) {
        DeltaspikeMessageBundleDefinitionContext workingCopy = (DeltaspikeMessageBundleDefinitionContext)this.context.getWorkingCopy();
        Map is = fileSet.getInterfaces();
        for (IPath path : is.keySet()) {
            List ts = (List)is.get(path);
            for (IType t : ts) {
                InterfaceDefinition i = new InterfaceDefinition(t, (IDefinitionContextExtension)this.context);
                List as = i.getAnnotations();
                for (IAnnotationDeclaration a : as) {
                    if (!workingCopy.isMessageBundleAnnotation(a.getType())) continue;
                    TypeDefinition d = new TypeDefinition();
                    d.setType(t, workingCopy.getRootContext(), 0);
                    d.setBeanConstructor(true);
                    workingCopy.addMessageBundle(path, d);
                }
            }
        }
    }

    public void buildBeans(CDIProject target) {
        CDIProject p = target;
        Map<String, TypeDefinition> services = this.context.getMessageBundles();
        for (TypeDefinition d : services.values()) {
            ClassBean b = new ClassBean();
            b.setDefinition(d);
            b.setParent((ICDIElement)p);
            p.addBean((IBean)b);
        }
    }

    class DeltaspikeMessageBundleDefinitionContext
    extends AbstractDefinitionContextExtension {
        Set<String> messageBundleAnnotations = new HashSet<String>();
        Map<String, TypeDefinition> messageBundles = new HashMap<String, TypeDefinition>();

        DeltaspikeMessageBundleDefinitionContext() {
        }

        protected DeltaspikeMessageBundleDefinitionContext copy(boolean clean) {
            DeltaspikeMessageBundleDefinitionContext copy = new DeltaspikeMessageBundleDefinitionContext();
            copy.root = this.root;
            if (!clean) {
                for (String qn : this.messageBundles.keySet()) {
                    TypeDefinition d = this.messageBundles.get(qn);
                    if (!d.exists()) continue;
                    copy.messageBundles.put(qn, d);
                }
                copy.messageBundleAnnotations.addAll(this.messageBundleAnnotations);
            }
            return copy;
        }

        protected void doApplyWorkingCopy() {
            this.messageBundles = ((DeltaspikeMessageBundleDefinitionContext)this.workingCopy).messageBundles;
            this.messageBundleAnnotations = ((DeltaspikeMessageBundleDefinitionContext)this.workingCopy).messageBundleAnnotations;
        }

        public void clean() {
            this.messageBundles.clear();
            this.messageBundleAnnotations.clear();
        }

        public void clean(String typeName) {
            this.messageBundles.remove(typeName);
            this.messageBundleAnnotations.remove(typeName);
        }

        public void addMessageBundle(IPath path, TypeDefinition def) {
            String typeName = def.getType().getFullyQualifiedName();
            this.messageBundles.put(typeName, def);
            this.root.addType(path, typeName);
        }

        public Map<String, TypeDefinition> getMessageBundles() {
            return this.messageBundles;
        }

        public void computeAnnotationKind(AnnotationDefinition annotation) {
            if (annotation.isAnnotationPresent("org.apache.deltaspike.core.api.message.MessageBundle")) {
                annotation.setExtendedKind((Object)"messageBundleAnnotation");
                this.messageBundleAnnotations.add(annotation.getType().getFullyQualifiedName());
            }
        }

        public boolean isMessageBundleAnnotation(IType type) {
            return type != null && (this.messageBundleAnnotations.contains(type.getFullyQualifiedName()) || "org.apache.deltaspike.core.api.message.MessageBundle".equals(type.getFullyQualifiedName()));
        }
    }
}

