/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeCorePlugin;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSecurityBindingConfiguration;
import org.jboss.tools.cdi.deltaspike.core.SecurityBindingDeclaration;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;

public class DeltaspikeAuthorityMethod {
    MethodDefinition method;
    IPath path;
    String declaringTypeName;
    Map<SecurityBindingDeclaration, DeltaspikeSecurityBindingConfiguration> bindings = new HashMap<SecurityBindingDeclaration, DeltaspikeSecurityBindingConfiguration>();

    public DeltaspikeAuthorityMethod(MethodDefinition method) {
        this.method = method;
        IType type = method.getTypeDefinition().getType();
        if (type != null) {
            this.path = type.getPath();
            this.declaringTypeName = type.getFullyQualifiedName();
        }
    }

    public MethodDefinition getMethod() {
        return this.method;
    }

    public IPath getPath() {
        return this.path;
    }

    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    public void addBinding(SecurityBindingDeclaration d, DeltaspikeSecurityBindingConfiguration c) {
        this.bindings.put(d, c);
    }

    public Map<SecurityBindingDeclaration, DeltaspikeSecurityBindingConfiguration> getBindings() {
        return this.bindings;
    }

    public boolean isMatching(IAnnotationDeclaration d) throws CoreException {
        if (this.bindings.isEmpty()) {
            return false;
        }
        String key = CDIProject.getAnnotationDeclarationKey((IAnnotationDeclaration)d);
        for (SecurityBindingDeclaration d2 : this.bindings.keySet()) {
            if (!d2.getBinding().getTypeName().equals(d.getTypeName()) || !key.equals(CDIProject.getAnnotationDeclarationKey((IAnnotationDeclaration)d2.getBinding()))) continue;
            return true;
        }
        return false;
    }

    public String getKey() {
        String separator = ":";
        String result = String.valueOf(this.declaringTypeName) + separator + this.method.getMethod().getElementName();
        try {
            result = String.valueOf(result) + separator + this.method.getMethod().getSignature();
        }
        catch (JavaModelException e) {
            DeltaspikeCorePlugin.getDefault().logError(e);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeltaspikeAuthorityMethod)) {
            return false;
        }
        DeltaspikeAuthorityMethod other = (DeltaspikeAuthorityMethod)o;
        return this.getKey().equals(other.getKey());
    }
}

