/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.CheckBoxEditorWrapper;
import org.jboss.tools.cdi.ui.wizard.NewCDIAnnotationWizardPage;

public class NewScopeWizardPage
extends NewCDIAnnotationWizardPage {
    protected CheckBoxEditorWrapper normal = null;
    protected CheckBoxEditorWrapper passivating = null;

    public NewScopeWizardPage() {
        this.setTitle(CDIUIMessages.NEW_SCOPE_WIZARD_PAGE_NAME);
    }

    @Override
    protected void addAnnotations(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        this.addScopeAnnotation(imports, sb, lineDelimiter);
        this.addInheritedAnnotation(imports, sb, lineDelimiter);
        this.addTargetAnnotation(imports, sb, lineDelimiter, this.getTargets());
        this.addRetentionAnnotation(imports, sb, lineDelimiter);
        this.addDocumentedAnnotation(imports, sb, lineDelimiter);
    }

    @Override
    protected String[] getTargets() {
        return new String[]{"TYPE", "METHOD", "FIELD"};
    }

    protected void addScopeAnnotation(NewTypeWizardPage.ImportsManager imports, StringBuffer sb, String lineDelimiter) {
        if (this.normal != null) {
            if (this.normal.composite.getValue() == Boolean.FALSE) {
                NewScopeWizardPage.addAnnotation("javax.inject.Scope", imports, sb, lineDelimiter);
            } else if (this.passivating.composite.getValue() == Boolean.FALSE) {
                NewScopeWizardPage.addAnnotation("javax.enterprise.context.NormalScope", imports, sb, lineDelimiter);
            } else {
                String typeName = "javax.enterprise.context.NormalScope";
                int i = typeName.lastIndexOf(46);
                String name = typeName.substring(i + 1);
                imports.addImport(typeName);
                sb.append("@").append(name).append("(passivating=true)").append(lineDelimiter);
            }
        }
    }

    @Override
    protected void createCustomFields(Composite parent) {
        this.createInheritedField(parent, true);
        this.createNormalField(parent);
        this.createPassivatingField(parent);
    }

    protected void createNormalField(Composite composite) {
        String label = "is normal scope";
        this.normal = this.createCheckBoxField(composite, "isNormal", label, true);
        this.normal.checkBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                NewScopeWizardPage.this.passivating.checkBox.setEnabled(o != Boolean.FALSE);
            }
        });
    }

    protected void createPassivatingField(Composite composite) {
        String label = "is passivating";
        this.passivating = this.createCheckBoxField(composite, "isPassivating", label, false);
    }
}

