/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IObserverMethod;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.ui.search.CDIMatch;
import org.jboss.tools.cdi.ui.search.InjectionPointMatchPresentation;

public class InjectionPointQueryParticipant
implements IQueryParticipant {
    ArrayList<String> objects = new ArrayList();

    public int estimateTicks(QuerySpecification specification) {
        return 10;
    }

    public IMatchPresentation getUIParticipant() {
        return new InjectionPointMatchPresentation();
    }

    private static boolean containsInSearchScope(QuerySpecification querySpecification, IPath projectPath) {
        IPath[] paths;
        IJavaSearchScope searchScope = querySpecification.getScope();
        if (searchScope == null) {
            return true;
        }
        IPath[] iPathArray = paths = searchScope.enclosingProjectsAndJars();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path.equals((Object)projectPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsInSearchScope(QuerySpecification querySpecification, ICDIElement element) {
        return InjectionPointQueryParticipant.containsInSearchScope(querySpecification, element.getResource().getProject().getFullPath());
    }

    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        this.objects.clear();
        if (querySpecification instanceof ElementQuerySpecification) {
            if (!this.isSearchForReferences(querySpecification.getLimitTo())) {
                return;
            }
            ElementQuerySpecification qs = (ElementQuerySpecification)querySpecification;
            IJavaElement element = qs.getElement();
            if (element instanceof IMethod || element instanceof IField || element instanceof ILocalVariable) {
                IParameter param;
                IProject project = element.getJavaProject().getProject();
                if (project == null) {
                    return;
                }
                CDICoreNature cdiNature = CDICorePlugin.getCDI((IProject)project, (boolean)true);
                if (cdiNature == null) {
                    return;
                }
                ICDIProject cdiProject = cdiNature.getDelegate();
                if (cdiProject == null) {
                    return;
                }
                Collection beans = cdiProject.getBeans(element.getPath());
                IInjectionPoint injectionPoint = CDIUtil.findInjectionPoint((Collection)beans, (IJavaElement)element, (int)0);
                if (injectionPoint != null) {
                    List resultBeanList = CDIUtil.sortBeans((Collection)cdiProject.getBeans(false, injectionPoint));
                    for (IBean bean : resultBeanList) {
                        CDIMatch match;
                        if (bean == null || !InjectionPointQueryParticipant.containsInSearchScope(querySpecification, (ICDIElement)bean) || this.objects.contains((match = new CDIMatch((ICDIElement)bean)).getPath())) continue;
                        requestor.reportMatch((Match)match);
                        this.objects.add(match.getPath());
                    }
                    this.resolveObserverMethods(cdiProject, injectionPoint, requestor, querySpecification);
                }
                if (element instanceof IMethod && (param = this.findObserverParameter(beans, (IMethod)element)) != null) {
                    this.findObservedEvents(cdiProject, param, requestor, querySpecification);
                }
            }
        }
    }

    private void resolveObserverMethods(ICDIProject cdiProject, IInjectionPoint injectionPoint, ISearchRequestor requestor, QuerySpecification querySpecification) {
        for (IObserverMethod observerMethod : cdiProject.resolveObserverMethods(injectionPoint)) {
            CDIMatch match;
            if (!InjectionPointQueryParticipant.containsInSearchScope(querySpecification, (ICDIElement)observerMethod) || this.objects.contains((match = new CDIMatch((ICDIElement)observerMethod)).getPath())) continue;
            requestor.reportMatch((Match)match);
            this.objects.add(match.getPath());
        }
    }

    private void findObservedEvents(ICDIProject cdiProject, IParameter param, ISearchRequestor requestor, QuerySpecification querySpecification) {
        for (IInjectionPoint event : cdiProject.findObservedEvents(param)) {
            CDIMatch match;
            if (!InjectionPointQueryParticipant.containsInSearchScope(querySpecification, (ICDIElement)event) || this.objects.contains((match = new CDIMatch((ICDIElement)event)).getPath())) continue;
            requestor.reportMatch((Match)match);
            this.objects.add(match.getPath());
        }
    }

    private IParameter findObserverParameter(Collection<IBean> beans, IMethod method) throws JavaModelException {
        for (IBean bean : beans) {
            if (!(bean instanceof IClassBean)) continue;
            for (IObserverMethod bm : ((IClassBean)bean).getObserverMethods()) {
                IObserverMethod obs;
                Collection ps;
                if (!bm.getMethod().equals(method) || (ps = (obs = bm).getObservedParameters()).isEmpty()) continue;
                return (IParameter)ps.iterator().next();
            }
        }
        return null;
    }

    public boolean isSearchForReferences(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 2 || maskedLimitTo == 3;
    }
}

