/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.text.ext.hyperlink;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.cdi.seam.text.ext.CDISeamExtMessages;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.Utils;

public class CDISeamResourceLoadingHyperlink
extends AbstractHyperlink {
    private static final String PROPERTIES = ".properties";
    private String path;
    private IFile file;

    public CDISeamResourceLoadingHyperlink(IFile file, IDocument document, IRegion region, String path) {
        this.file = file;
        this.setRegion(region);
        this.path = path;
        this.setDocument(document);
    }

    protected IFile getFile() {
        return this.file;
    }

    public IFile getReadyToOpenFile() {
        String fileName = this.path;
        IFile result = this.searchFile(fileName);
        if (result != null && result.exists()) {
            return result;
        }
        result = this.searchFile(fileName = this.replaceDots(fileName));
        if (result != null && result.exists()) {
            return result;
        }
        fileName = this.path;
        fileName = String.valueOf(fileName) + PROPERTIES;
        fileName = this.replaceDots(fileName);
        return this.searchFile(fileName);
    }

    private String replaceDots(String name) {
        String fileName = name;
        int propIndex = fileName.lastIndexOf(".");
        if (propIndex < 0) {
            return fileName;
        }
        String extension = fileName.substring(propIndex);
        fileName = fileName.substring(0, propIndex);
        fileName = fileName.replace(".", "/");
        fileName = String.valueOf(fileName) + extension;
        return fileName;
    }

    public IFile searchFile(String fileName) {
        IFile result = this.getFileFromProject(fileName);
        if (result != null && result.exists()) {
            return result;
        }
        if (this.file == null || !this.file.isAccessible()) {
            return null;
        }
        fileName = this.findAndReplaceElVariable(fileName);
        IProject project = this.file.getProject();
        String name = Utils.trimFilePath((String)fileName);
        IPath currentPath = this.file.getLocation().removeLastSegments(1);
        IFile member = null;
        if (name.startsWith("/")) {
            member = this.findByAbsolutePath(project, name);
        } else {
            member = this.findByRelativePath(project, currentPath, name);
            if (member == null && name.length() > 0) {
                member = this.findByAbsolutePath(project, "/" + name);
            }
        }
        if (member != null && member instanceof IFile && member.exists()) {
            return member;
        }
        return null;
    }

    private IFile findByRelativePath(IProject project, IPath basePath, String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        path = this.findAndReplaceElVariable(path);
        IFile member = null;
        Set sources = EclipseResourceUtil.getSourceFolders((IProject)this.file.getProject());
        for (IFolder source : sources) {
            IPath webRootPath = source.getProjectRelativePath();
            IPath relativePath = Utils.getRelativePath((IPath)webRootPath, (IPath)basePath);
            IPath filePath = relativePath.append(path);
            member = project.getFolder(webRootPath).getFile(filePath);
            if (!member.exists()) continue;
            return member;
        }
        return null;
    }

    private IFile findByAbsolutePath(IProject project, String path) {
        path = this.findAndReplaceElVariable(path);
        IFile member = null;
        Set sources = EclipseResourceUtil.getSourceFolders((IProject)this.file.getProject());
        for (IFolder source : sources) {
            IPath sourcePath = source.getProjectRelativePath();
            member = project.getFolder(sourcePath).getFile(path);
            if (!member.exists()) continue;
            return member;
        }
        return null;
    }

    protected void doHyperlink(IRegion region) {
        IFile file = this.getReadyToOpenFile();
        IEditorPart part = this.openFileInEditor(file);
        if (part == null) {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        return NLS.bind((String)CDISeamExtMessages.CDI_SEAM_RESOURCE_LOADING_HYPERLINK, (Object)this.path);
    }
}

