/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.seam.detector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IDownloadRuntimesProvider;
import org.jboss.tools.stacks.core.model.StacksManager;

public class DownloadRuntimesSeamProvider
implements IDownloadRuntimesProvider {
    private static final String LABEL_FILE_SIZE = "runtime-size";
    private static final String LABEL_CATEGORY = "runtime-category";
    private static final String LABEL_TYPE = "runtime-type";
    private static final String CATEGORY_PROJECT = "PROJECT";
    private static final String TYPE_SEAM = "SEAM";
    private ArrayList<DownloadRuntime> downloads = null;
    private HashMap<String, String> LEGACY_HASHMAP = null;

    private Stacks[] getStacks(IProgressMonitor monitor) {
        return new StacksManager().getStacks("Loading Downloadable Runtimes", monitor, new StacksManager.StacksType[]{StacksManager.StacksType.PRESTACKS_TYPE});
    }

    public DownloadRuntime[] getDownloadableRuntimes(String requestType, IProgressMonitor monitor) {
        if (this.downloads == null) {
            this.loadDownloadableRuntimes(monitor);
        }
        return this.downloads.toArray(new DownloadRuntime[this.downloads.size()]);
    }

    private synchronized void loadDownloadableRuntimes(IProgressMonitor monitor) {
        monitor.beginTask("Load Remote Runtimes", 200);
        Stacks[] stacksArr = this.getStacks((IProgressMonitor)new SubProgressMonitor(monitor, 100));
        ArrayList<DownloadRuntime> all = new ArrayList<DownloadRuntime>();
        monitor.beginTask("Create Download Runtimes", stacksArr.length * 100);
        int i = 0;
        while (i < stacksArr.length) {
            SubProgressMonitor inner = new SubProgressMonitor(monitor, 100);
            if (stacksArr[i] != null) {
                this.traverseStacks(stacksArr[i], all, (IProgressMonitor)inner);
            }
            ++i;
        }
        monitor.done();
        this.downloads = all;
    }

    private void traverseStacks(Stacks stacks, ArrayList<DownloadRuntime> list, IProgressMonitor monitor) {
        List runtimes = stacks.getAvailableRuntimes();
        Iterator i = runtimes.iterator();
        Runtime workingRT = null;
        monitor.beginTask("Create Download Runtimes", runtimes.size() * 100);
        while (i.hasNext()) {
            workingRT = (Runtime)i.next();
            boolean isSeam = this.isSeam(workingRT);
            String url = workingRT.getDownloadUrl();
            if (isSeam && url != null && !"".equals(url)) {
                String fileSize = workingRT.getLabels().getProperty(LABEL_FILE_SIZE);
                String license = workingRT.getLicense();
                String id = workingRT.getId();
                String legacyId = this.getLegacyId(id);
                String effectiveId = legacyId == null ? id : legacyId;
                String name = workingRT.getName();
                String version = workingRT.getVersion();
                DownloadRuntime dr = new DownloadRuntime(effectiveId, name, version, url);
                dr.setLicenseURL(license);
                dr.setSize(fileSize);
                if (legacyId != null) {
                    dr.setProperty("PROPERTY_ALTERNATE_ID", (Object)id);
                }
                list.add(dr);
            }
            monitor.worked(100);
        }
        monitor.done();
    }

    private boolean isSeam(Runtime rt) {
        return CATEGORY_PROJECT.equals(rt.getLabels().get(LABEL_CATEGORY)) && TYPE_SEAM.equals(rt.getLabels().get(LABEL_TYPE));
    }

    private synchronized String getLegacyId(String id) {
        if (this.LEGACY_HASHMAP == null) {
            this.loadLegacy();
        }
        return this.LEGACY_HASHMAP.get(id);
    }

    private synchronized void loadLegacy() {
        this.LEGACY_HASHMAP = new HashMap();
        this.LEGACY_HASHMAP.put("seam202runtime", "org.jboss.tools.runtime.core.seam.202");
        this.LEGACY_HASHMAP.put("seam222runtime", "org.jboss.tools.runtime.core.seam.222");
    }
}

