/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.java.handlers.OpenJavaSourceHandler;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.model.JSFELCompletionEngine;
import org.jboss.tools.jsf.model.JSFXModelUtil;
import org.jboss.tools.jsf.model.helpers.converter.OpenConverterHelper;
import org.jboss.tools.jsf.model.helpers.converter.OpenKeyHelper;
import org.jboss.tools.jsf.model.helpers.converter.OpenRenderKitHelper;
import org.jboss.tools.jsf.model.helpers.converter.OpenTagLib;
import org.jboss.tools.jsf.model.helpers.converter.OpenValidatorHelper;
import org.jboss.tools.jsf.model.helpers.pages.OpenCaseHelper;
import org.jboss.tools.jsf.model.helpers.pages.ResourceBundleHelper;
import org.jboss.tools.jsf.model.pv.BeanConstants;
import org.jboss.tools.jsf.model.pv.JSFBeanSearcher;
import org.jboss.tools.jsf.model.pv.JSFProjectBean;
import org.jboss.tools.jsf.model.pv.JSFProjectBeanMember;
import org.jboss.tools.jsf.model.pv.JSFProjectBeans;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jsf.web.JSFWebProject;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.project.list.IWebPromptingProvider;

public class JSFPromptingProvider
implements IWebPromptingProvider {
    static Set<String> SUPPORTED_IDS = new HashSet<String>();
    public static final String PROVIDER_ID = "jsf";

    static {
        SUPPORTED_IDS.add("jsf.bundles");
        SUPPORTED_IDS.add("jsf.registered.bundles");
        SUPPORTED_IDS.add("jsf.bundle.properties");
        SUPPORTED_IDS.add("jsf.beans");
        SUPPORTED_IDS.add("jsf.bean.properties");
        SUPPORTED_IDS.add("jsf.bean.methods");
        SUPPORTED_IDS.add("jsf.bean.add.property");
        SUPPORTED_IDS.add("jsf.view.action");
        SUPPORTED_IDS.add("jsf.bean.open");
        SUPPORTED_IDS.add("jsf.get.path");
        SUPPORTED_IDS.add("jsf.open.action");
        SUPPORTED_IDS.add("jsf.open.convertor");
        SUPPORTED_IDS.add("jsf.open.validator");
        SUPPORTED_IDS.add("jsf.open.render-kit");
        SUPPORTED_IDS.add("jsf.open.property");
        SUPPORTED_IDS.add("jsf.open.taglibrary");
        SUPPORTED_IDS.add("jsf.open.bundle");
        SUPPORTED_IDS.add("jsf.open.key");
        SUPPORTED_IDS.add("jsf.get.url");
        SUPPORTED_IDS.add("jsf.url.to.path");
        SUPPORTED_IDS.add("jsf.get.taglibs");
        SUPPORTED_IDS.add("jsf.converter.ids");
        SUPPORTED_IDS.add("jsf.validator.ids");
        SUPPORTED_IDS.add("jsf.faces.config");
    }

    public boolean isSupporting(String id) {
        return id != null && SUPPORTED_IDS.contains(id);
    }

    public List<Object> getList(XModel model, String id, String prefix, Properties properties) {
        try {
            return this.getListInternal(model, id, prefix, properties);
        }
        catch (CoreException e) {
            if (properties != null) {
                String message = e.getMessage();
                if (message == null) {
                    message = ((Object)((Object)e)).getClass().getName();
                }
                properties.setProperty("error", message);
            }
            return EMPTY_LIST;
        }
    }

    private List<Object> getListInternal(XModel model, String id, String prefix, Properties properties) throws CoreException {
        String error = null;
        if ("jsf.bundles".equals(id)) {
            return this.getBundles(model);
        }
        if ("jsf.registered.bundles".equals(id)) {
            return ResourceBundleHelper.getRegisteredResourceBundles(model);
        }
        if ("jsf.bundle.properties".equals(id)) {
            return this.getBundleProperties(model, prefix);
        }
        if ("jsf.beans".equals(id)) {
            return this.getBeans(model);
        }
        if ("jsf.bean.properties".equals(id)) {
            String type = properties == null ? null : properties.getProperty("propertyType");
            String sBeanOnly = properties == null ? null : properties.getProperty("bean-only");
            boolean beanOnly = "true".equals(sBeanOnly);
            return this.getBeanProperties(model, prefix, type, beanOnly);
        }
        if ("jsf.bean.methods".equals(id)) {
            String[] parameterTypes = (String[])properties.get("parameterTypes");
            String returnType = properties.getProperty("returnType");
            return this.getBeanMethods(model, prefix, parameterTypes, returnType);
        }
        if ("jsf.bean.add.property".equals(id)) {
            XModelObject property = this.addPropertyToBean(model, prefix);
            if (property == null) {
                return EMPTY_LIST;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(property);
            return list;
        }
        if ("jsf.view.action".equals(id)) {
            String viewPath = properties.getProperty("viewPath");
            return this.getViewActions(model, viewPath);
        }
        if ("jsf.bean.open".equals(id)) {
            this.openBean(model, prefix);
        } else {
            if ("jsf.get.path".equals(id)) {
                return this.getPathAsList(model, prefix);
            }
            if ("jsf.open.action".equals(id)) {
                IFile file = (IFile)properties.get("file");
                String action = prefix;
                OpenCaseHelper h = new OpenCaseHelper();
                error = h.run(model, file, action);
            } else if ("jsf.open.convertor".equals(id)) {
                String converterId = prefix;
                OpenConverterHelper h = new OpenConverterHelper();
                error = h.run(model, converterId);
            } else if ("jsf.open.validator".equals(id)) {
                String validatorId = prefix;
                OpenValidatorHelper h = new OpenValidatorHelper();
                error = h.run(model, validatorId);
            } else if ("jsf.open.render-kit".equals(id)) {
                String renderkitId = prefix;
                OpenRenderKitHelper h = new OpenRenderKitHelper();
                error = h.run(model, renderkitId);
            } else if ("jsf.open.property".equals(id)) {
                OpenJavaSourceHandler.open((XModel)model, (String)prefix, (Properties)properties);
            } else if ("jsf.open.taglibrary".equals(id)) {
                String uri = prefix;
                String tagName = properties.getProperty("name");
                String attributeName = properties.getProperty("attribute");
                OpenTagLib h = new OpenTagLib();
                error = h.run(model, uri, tagName, attributeName);
            } else if ("jsf.open.bundle".equals(id)) {
                String bundle = properties.getProperty("bundle");
                String locale = properties.getProperty("locale");
                OpenKeyHelper h = new OpenKeyHelper();
                error = h.run(model, bundle, locale);
            } else if ("jsf.open.key".equals(id)) {
                String bundle = properties.getProperty("bundle");
                String key = properties.getProperty("key");
                String locale = properties.getProperty("locale");
                OpenKeyHelper h = new OpenKeyHelper();
                error = h.run(model, bundle, key, locale);
            } else {
                if ("jsf.get.url".equals(id)) {
                    if (!EclipseResourceUtil.hasNature((XModel)model, (String)"org.jboss.tools.jsf.jsfnature")) {
                        return EMPTY_LIST;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    String url = JSFWebProject.getInstance(model).getUrlPattern().getJSFUrl(prefix);
                    if (url != null && url.length() > 0) {
                        list.add(url);
                    }
                    return list;
                }
                if ("jsf.url.to.path".equals(id)) {
                    if (!EclipseResourceUtil.hasNature((XModel)model, (String)"org.jboss.tools.jsf.jsfnature")) {
                        XModelObject webxml = WebAppHelper.getWebApp((XModel)model);
                        if (webxml != null) {
                            JSFWebProject.getInstance(model).getPatternLoader().revalidate(webxml);
                        } else {
                            return EMPTY_LIST;
                        }
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    List<String> paths = JSFWebProject.getInstance(model).getUrlPattern().getJSFPaths(prefix);
                    if (!paths.isEmpty()) {
                        list.addAll(paths);
                    } else {
                        String path = JSFWebProject.getInstance(model).getUrlPattern().getJSFPath(prefix);
                        if (path != null && path.length() > 0) {
                            list.add(path);
                        }
                    }
                    return list;
                }
                if ("jsf.get.taglibs".equals(id)) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    WebProject p = WebProject.getInstance((XModel)model);
                    Map map = p.getTaglibMapping().getTaglibObjects();
                    list.addAll(map.keySet());
                    return list;
                }
                if ("jsf.converter.ids".equals(id)) {
                    return new OpenConverterHelper().getConverterIDs(model);
                }
                if ("jsf.validator.ids".equals(id)) {
                    return new OpenValidatorHelper().getValidatorIDs(model);
                }
                if ("jsf.faces.config".equals(id)) {
                    XModelObject fc = JSFPromptingProvider.findFacesConfig(model);
                    if (fc == null) {
                        return EMPTY_LIST;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(fc);
                    return list;
                }
            }
        }
        if (error != null) {
            throw new XModelException(error);
        }
        return EMPTY_LIST;
    }

    public List<Object> getBundles(XModel model) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return EMPTY_LIST;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Resource Bundles");
        if (n == null) {
            return EMPTY_LIST;
        }
        XModelObject[] os = n.getTreeChildren();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < os.length) {
            String p = XModelObjectLoaderUtil.getResourcePath((XModelObject)os[i]);
            if (p != null && p.endsWith(".properties")) {
                p = p.substring(1, p.length() - 11).replace('/', '.');
                list.add(p);
            }
            ++i;
        }
        return list;
    }

    public List<Object> getBundleProperties(XModel model, String bundle) {
        if (bundle == null || bundle.length() == 0) {
            return EMPTY_LIST;
        }
        OpenKeyHelper helper = new OpenKeyHelper();
        XModelObject[] bundleObjects = helper.findBundles(model, bundle, null);
        if (bundleObjects == null) {
            return EMPTY_LIST;
        }
        TreeSet<String> properties = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        XModelObject[] xModelObjectArray = bundleObjects;
        int n = bundleObjects.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject b = xModelObjectArray[n2];
            if (b != null) {
                XModelObject[] os = b.getChildren();
                int i = 0;
                while (i < os.length) {
                    properties.add(os[i].getAttributeValue("name"));
                    ++i;
                }
            }
            ++n2;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(properties);
        return list;
    }

    public List<Object> getBeans(XModel model) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return EMPTY_LIST;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null) {
            return EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        XModelObject[] xModelObjectArray = n.getTreeChildren();
        int n2 = xModelObjectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            XModelObject o = xModelObjectArray[n3];
            if (JSFXModelUtil.isFacesConfig(o)) {
                this.getBeans(o, BeanConstants.MANAGED_BEAN_CONSTANTS, list);
                this.getBeans(o, BeanConstants.REFERENCED_BEAN_CONSTANTS, list);
            }
            ++n3;
        }
        return list;
    }

    private void getBeans(XModelObject o, BeanConstants constants, List<Object> list) {
        XModelObject mb = o.getChildByPath(constants.folder);
        if (mb == null) {
            return;
        }
        XModelObject[] bs = mb.getChildren();
        int j = 0;
        while (j < bs.length) {
            list.add(bs[j].getAttributeValue(constants.nameAttribute));
            ++j;
        }
    }

    public List<JSFELCompletionEngine.IJSFVariable> getVariables(XModel model) {
        ArrayList<JSFELCompletionEngine.IJSFVariable> result = new ArrayList<JSFELCompletionEngine.IJSFVariable>();
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return result;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        WebProjectNode beans = (WebProjectNode)root.getChildByPath("Beans");
        XModelObject[] xModelObjectArray = n.getTreeChildren();
        int n2 = xModelObjectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            XModelObject o = xModelObjectArray[n3];
            if (JSFXModelUtil.isFacesConfig(o)) {
                this.getVariables(o, BeanConstants.MANAGED_BEAN_CONSTANTS, beans, result);
                this.getVariables(o, BeanConstants.REFERENCED_BEAN_CONSTANTS, beans, result);
            }
            ++n3;
        }
        return result;
    }

    private void getVariables(XModelObject o, BeanConstants constants, WebProjectNode beans, List<JSFELCompletionEngine.IJSFVariable> list) {
        XModelObject[] bs;
        XModelObject mb = o.getChildByPath(constants.folder);
        if (mb == null) {
            return;
        }
        XModelObject[] xModelObjectArray = bs = mb.getChildren();
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject q = xModelObjectArray[n2];
            final String name = q.getAttributeValue(constants.nameAttribute);
            String className = q.getAttributeValue(constants.classAttribute);
            XModelObject c = JSFPromptingProvider.findBeanClassByClassName(beans, className);
            if (c instanceof JSFProjectBean) {
                JSFProjectBean b = (JSFProjectBean)c;
                final IType type = b.getType();
                JSFELCompletionEngine.IJSFVariable var = new JSFELCompletionEngine.IJSFVariable(){

                    @Override
                    public IMember getSourceMember() {
                        return type;
                    }

                    public String getName() {
                        return name;
                    }
                };
                list.add(var);
            }
            ++n2;
        }
    }

    public List<Object> getBeanProperties(XModel model, String prefix, String type, boolean beanOnly) {
        if (prefix.length() == 0) {
            return EMPTY_LIST;
        }
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return EMPTY_LIST;
        }
        IProject project = EclipseResourceUtil.getProject((XModelObject)root);
        int d = prefix.indexOf(46);
        String beanName = d < 0 ? prefix : prefix.substring(0, d);
        String property = d < 0 ? null : prefix.substring(d + 1);
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Beans");
        WebProjectNode conf = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null || conf == null) {
            return EMPTY_LIST;
        }
        XModelObject bean = JSFPromptingProvider.findBean(conf, beanName);
        if (bean == null) {
            return EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        XModelObject beanClass = JSFPromptingProvider.findBeanClass(n, bean);
        if (beanClass == null) {
            if (property.length() > 0) {
                return EMPTY_LIST;
            }
            XModelObject[] cs = bean.getChildren("JSFManagedProperty");
            int i = 0;
            while (i < cs.length) {
                String cn = cs[i].getAttributeValue("property-class");
                if (!(type != null && !EclipseJavaUtil.isDerivedClass((String)cn, (String)type, (IProject)project) || beanOnly && this.isNotBean(cn))) {
                    list.add(cs[i].getAttributeValue("property-name"));
                }
                ++i;
            }
        } else {
            if (property != null && property.length() > 0) {
                beanClass = beanClass.getChildByPath(property.replace('.', '/'));
            }
            if (beanClass == null) {
                return EMPTY_LIST;
            }
            XModelObject[] os = beanClass.getChildren("JSFProjectBeanProperty");
            int i = 0;
            while (i < os.length) {
                String cn = os[i].getAttributeValue("class name");
                if (!(type != null && !EclipseJavaUtil.isDerivedClass((String)cn, (String)type, (IProject)project) || beanOnly && this.isNotBean(cn))) {
                    list.add(os[i].getAttributeValue("name"));
                }
                ++i;
            }
        }
        return list;
    }

    private boolean isNotBean(String cn) {
        if (cn == null || cn.length() == 0) {
            return true;
        }
        if (JSFProjectBeans.primitive.indexOf("!" + cn + "!") >= 0) {
            return true;
        }
        if (cn.startsWith("java.lang.")) {
            return true;
        }
        return cn.startsWith("java.util.");
    }

    private XModelObject addPropertyToBean(XModel model, String beanName) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        WebProjectNode conf = (WebProjectNode)root.getChildByPath("Configuration");
        XModelObject bean = JSFPromptingProvider.findBean(conf, beanName);
        if (bean == null) {
            return null;
        }
        Properties p = new Properties();
        XActionInvoker.invoke((String)"CreateActions.CreateProperty", (XModelObject)bean, (Properties)p);
        return (XModelObject)p.get("created");
    }

    public List buildBeanProperties(XModel model, String className, String type) {
        JSFProjectBean beanClass = JSFPromptingProvider.buildBean(model, className);
        if (beanClass == null) {
            return EMPTY_LIST;
        }
        IProject project = EclipseResourceUtil.getProject((XModelObject)beanClass);
        ArrayList<String> list = new ArrayList<String>();
        XModelObject[] os = beanClass.getChildren("JSFProjectBeanProperty");
        int i = 0;
        while (i < os.length) {
            if (type == null || EclipseJavaUtil.isDerivedClass((String)os[i].getAttributeValue("class name"), (String)type, (IProject)project)) {
                list.add(os[i].getAttributeValue("name"));
            }
            ++i;
        }
        return list;
    }

    public static JSFProjectBean buildBean(XModel model, String className) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return null;
        }
        JSFProjectBeans n = (JSFProjectBeans)root.getChildByPath("Beans");
        IType cls = n.getType(className);
        if (cls == null) {
            return null;
        }
        JSFProjectBean beanClass = (JSFProjectBean)model.createModelObject("JSFProjectBean", null);
        beanClass.setBeans(n);
        beanClass.setType(cls);
        beanClass.setAttributeValue("class name", className);
        return beanClass;
    }

    private boolean openBean(XModel model, String prefix) {
        if (prefix.length() == 0) {
            return false;
        }
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return false;
        }
        JSFBeanSearcher s = new JSFBeanSearcher(model);
        s.parse(prefix);
        XModelObject bean = s.getBeanClass();
        String property = s.getProperty();
        if (bean == null) {
            return false;
        }
        Properties p = new Properties();
        if (property != null) {
            p.setProperty("property", property);
        }
        if (bean != null) {
            XActionInvoker.invoke((String)"Open", (XModelObject)bean, (Properties)p);
        }
        return true;
    }

    static XModelObject findBean(WebProjectNode conf, String beanName) {
        XModelObject[] os = conf.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            if (JSFXModelUtil.isFacesConfig(os[i])) {
                XModelObject bean = os[i].getChildByPath("Managed Beans/" + beanName);
                if (bean != null) {
                    return bean;
                }
                bean = os[i].getChildByPath("Referenced Beans/" + beanName);
                if (bean != null) {
                    return bean;
                }
            }
            ++i;
        }
        return null;
    }

    static XModelObject findBeanClass(WebProjectNode beans, XModelObject bean) {
        BeanConstants constants = BeanConstants.getConstants(bean);
        if (constants == null) {
            return null;
        }
        String className = bean.getAttributeValue(constants.classAttribute);
        return JSFPromptingProvider.findBeanClassByClassName(beans, className);
    }

    static XModelObject findBeanClassByClassName(WebProjectNode beans, String className) {
        if (beans == null) {
            return null;
        }
        XModelObject[] os = beans.getTreeChildren();
        int i = 0;
        while (i < os.length) {
            if (className.equals(os[i].getAttributeValue("class name"))) {
                return os[i];
            }
            ++i;
        }
        return null;
    }

    public List<Object> getBeanMethods(XModel model, String prefix, String[] parameterTypes, String returnType) {
        if (prefix.length() == 0) {
            return EMPTY_LIST;
        }
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return EMPTY_LIST;
        }
        int d = prefix.indexOf(46);
        String beanName = d < 0 ? prefix : prefix.substring(0, d);
        String property = d < 0 ? null : prefix.substring(d + 1);
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Beans");
        WebProjectNode conf = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null || conf == null) {
            return EMPTY_LIST;
        }
        XModelObject bean = JSFPromptingProvider.findBean(conf, beanName);
        if (bean == null) {
            return EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        XModelObject beanClass = JSFPromptingProvider.findBeanClass(n, bean);
        if (beanClass == null) {
            return EMPTY_LIST;
        }
        if (property != null && property.length() > 0) {
            beanClass = beanClass.getChildByPath(property.replace('.', '/'));
        }
        if (beanClass == null) {
            return EMPTY_LIST;
        }
        XModelObject[] os = beanClass.getChildren("JSFProjectBeanMethod");
        int i = 0;
        while (i < os.length) {
            JSFProjectBeanMember bm = (JSFProjectBeanMember)os[i];
            if (returnType == null || bm.hasMethodSignature(returnType, parameterTypes)) {
                list.add(os[i].getAttributeValue("name"));
            }
            ++i;
        }
        return list;
    }

    public List<Object> getViewActions(XModel model, String viewPath) {
        if (viewPath == null) {
            return EMPTY_LIST;
        }
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return EMPTY_LIST;
        }
        WebProjectNode n = (WebProjectNode)root.getChildByPath("Configuration");
        if (n == null) {
            return EMPTY_LIST;
        }
        XModelObject[] os = n.getTreeChildren();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < os.length) {
            XModelObject r = os[i].getChildByPath("Navigation Rules");
            if (r != null) {
                XModelObject[] rs = r.getChildren();
                int j = 0;
                while (j < rs.length) {
                    if (OpenCaseHelper.isPatternMatches(rs[j].getAttributeValue("from-view-id"), viewPath)) {
                        XModelObject[] cs = rs[j].getChildren();
                        int k = 0;
                        while (k < cs.length) {
                            String q = cs[k].getAttributeValue("from-outcome");
                            if (!list.contains(q)) {
                                list.add(q);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }

    List<Object> getPathAsList(XModel model, String url) {
        ArrayList<Object> pathsList = new ArrayList<Object>();
        JSFWebProject p = JSFWebProject.getInstance(model);
        if (p == null) {
            pathsList.add(url);
        } else {
            JSFUrlPattern pattern = p.getUrlPattern();
            if (pattern != null) {
                pathsList.addAll(pattern.getJSFPaths(url));
            } else {
                pathsList.add(url);
            }
        }
        return pathsList;
    }

    String getPath(XModel model, String url) {
        JSFWebProject p = JSFWebProject.getInstance(model);
        if (p == null) {
            return url;
        }
        JSFUrlPattern pattern = p.getUrlPattern();
        return pattern == null ? url : pattern.getJSFPath(url);
    }

    public static XModelObject findFacesConfig(XModel model) {
        WebProjectNode n;
        XModelObject facesConfig = null;
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root != null && (n = (WebProjectNode)root.getChildByPath("Configuration")) != null) {
            XModelObject[] os;
            XModelObject[] xModelObjectArray = os = n.getTreeChildren();
            int n2 = os.length;
            int n3 = 0;
            while (n3 < n2) {
                XModelObject o = xModelObjectArray[n3];
                if (o.isObjectEditable()) {
                    facesConfig = o;
                    break;
                }
                ++n3;
            }
        }
        if (facesConfig == null) {
            facesConfig = model.getByPath("/faces-config.xml");
        }
        return facesConfig;
    }
}

