/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2ManagedBean;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.JSF2ProjectFactory;
import org.jboss.tools.jsf.model.pv.BeanConstants;
import org.jboss.tools.jsf.model.pv.JSFProjectBean;
import org.jboss.tools.jsf.model.pv.JSFProjectConfiguration;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class JSFProjectBeans
extends RegularObjectImpl
implements WebProjectNode {
    private static final long serialVersionUID = 2682624545623269421L;
    private Map<String, IType> types = new HashMap<String, IType>();
    protected boolean isLoading = false;
    protected boolean valid = false;
    static String primitive = "!int!char!boolean!short!double!long!void!byte!float!";
    JavaElementChangedListener listener = null;

    public void invalidate() {
        if (!this.valid || this.isLoading) {
            return;
        }
        this.valid = false;
        this.fireStructureChanged(3, (Object)this);
    }

    public XModelObject[] getTreeChildren() {
        if (this.isLoading || this.valid) {
            return this.getChildren();
        }
        this.isLoading = true;
        this.valid = true;
        try {
            this.updateListener();
            XModelObject[] cs = this.getChildren();
            HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
            HashMap<String, JSFProjectBean> classes = new HashMap<String, JSFProjectBean>();
            int i = 0;
            while (i < cs.length) {
                map.put(cs[i].getPathPart(), cs[i]);
                ++i;
            }
            List<XModelObject> list = JSFProjectConfiguration.getConfiguration(this.getModel());
            XModelObject[] fcs = list.toArray(new XModelObject[0]);
            int i2 = 0;
            while (i2 < fcs.length) {
                this.process(fcs[i2], BeanConstants.MANAGED_BEAN_CONSTANTS, map, classes);
                this.process(fcs[i2], BeanConstants.REFERENCED_BEAN_CONSTANTS, map, classes);
                ++i2;
            }
            IJSF2Project jsf2 = JSF2ProjectFactory.getJSF2Project(EclipseResourceUtil.getProject((XModelObject)this), true);
            if (jsf2 != null) {
                for (IJSF2ManagedBean b : jsf2.getManagedBeans()) {
                    this.process(b, map, classes);
                }
            }
            for (XModelObject o : map.values()) {
                o.removeFromParent();
            }
        }
        finally {
            this.isLoading = false;
        }
        return this.getChildren();
    }

    private void process(XModelObject fcg, BeanConstants constants, Map<String, XModelObject> map, Map<String, JSFProjectBean> classes) {
        XModelObject mb = fcg.getChildByPath(constants.folder);
        if (mb != null) {
            this.process(mb.getChildren(), constants, map, classes);
        }
    }

    private void process(XModelObject[] bs, BeanConstants constants, Map<String, XModelObject> map, Map<String, JSFProjectBean> classes) {
        int j = 0;
        while (j < bs.length) {
            String bn = bs[j].getAttributeValue(constants.nameAttribute);
            String cn = bs[j].getAttributeValue(constants.classAttribute);
            if (this.acceptClass(cn)) {
                JSFProjectBean b;
                if (classes.containsKey(cn)) {
                    b = classes.get(cn);
                    if (b != null) {
                        b.addBean(bs[j]);
                    }
                } else {
                    b = (JSFProjectBean)map.get(bn);
                    IType type = this.getType(cn);
                    if (b == null) {
                        b = (JSFProjectBean)this.getModel().createModelObject("JSFProjectBean", null);
                        b.setAttributeValue("name", bn);
                        b.setBeans(this);
                        this.addChild((XModelObject)b);
                    } else {
                        map.remove(bn);
                        b.cleanBeans();
                    }
                    b.setAttributeValue("class name", cn);
                    b.addBean(bs[j]);
                    b.setType(type);
                    classes.put(cn, b);
                }
            }
            ++j;
        }
    }

    private void process(IJSF2ManagedBean bean, Map<String, XModelObject> map, Map<String, JSFProjectBean> classes) {
        String bn = bean.getName();
        String cn = bean.getBeanClass().getFullyQualifiedName();
        if (!this.acceptClass(cn)) {
            return;
        }
        if (classes.containsKey(cn)) {
            return;
        }
        JSFProjectBean b = (JSFProjectBean)map.get(bn);
        IType type = bean.getBeanClass();
        if (b == null) {
            b = (JSFProjectBean)this.getModel().createModelObject("JSFProjectBean", null);
            b.setAttributeValue("name", bn);
            b.setBeans(this);
            this.addChild((XModelObject)b);
        } else {
            map.remove(bn);
            b.cleanBeans();
        }
        b.setAttributeValue("class name", cn);
        b.setType(type);
        classes.put(cn, b);
    }

    private boolean acceptClass(String classname) {
        if (classname == null) {
            return false;
        }
        if (classname.indexOf(46) < 0 && primitive.indexOf("!" + classname + "!") >= 0) {
            return false;
        }
        if (classname.indexOf(91) >= 0) {
            return false;
        }
        return !classname.startsWith("java.") && !classname.startsWith("javax.");
    }

    public IType getType(String typename) {
        IProject project;
        if (typename == null || typename.length() == 0 || !this.acceptClass(typename)) {
            return null;
        }
        IType type = this.types.get(typename);
        if (type != null && type.exists()) {
            return type;
        }
        if (type != null) {
            this.types.remove(typename);
        }
        if ((project = EclipseResourceUtil.getProject((XModelObject)this)) == null) {
            return null;
        }
        type = EclipseResourceUtil.getValidType((IProject)project, (String)typename);
        if (type != null) {
            this.types.put(typename, type);
        }
        return type;
    }

    public XModelObject getTreeParent(XModelObject object) {
        if (this.isChild(object)) {
            return this;
        }
        return null;
    }

    public boolean isChild(XModelObject object) {
        return object != null && object.getParent() == this;
    }

    private void updateListener() {
        if (this.listener != null) {
            return;
        }
        if (EclipseResourceUtil.getProject((XModelObject)this) == null) {
            return;
        }
        this.listener = new JavaElementChangedListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener);
    }

    private void lazyInvalidate() {
        if (!this.valid || this.isLoading) {
            return;
        }
        this.valid = false;
        Display.getDefault().asyncExec((Runnable)new XJob.XRunnable(){

            public void run() {
                JSFProjectBeans.this.fireStructureChanged(3, this);
            }

            public String getId() {
                return "JSF Project Beans Update - " + XModelConstants.getWorkspace((XModel)JSFProjectBeans.this.getModel());
            }
        });
    }

    private class JavaElementChangedListener
    implements IElementChangedListener {
        private JavaElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (!JSFProjectBeans.this.isActive()) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this);
            } else {
                JSFProjectBeans.this.lazyInvalidate();
            }
        }
    }
}

