/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.bean;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.model.helpers.bean.BeanHelper;

public class ManagedBeanHelper {
    public static IType getType(XModelObject bean) {
        if (bean == null) {
            return null;
        }
        String typename = bean.getAttributeValue("managed-bean-class");
        if (typename == null || typename.length() == 0) {
            return null;
        }
        IJavaProject jp = BeanHelper.getJavaProject(bean);
        try {
            return jp == null ? null : jp.findType(typename);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IMember getMember(XModelObject property) {
        if (property == null) {
            return null;
        }
        String propertyName = property.getAttributeValue("property-name");
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        IType type = ManagedBeanHelper.getType(property.getParent());
        if (type == null) {
            return null;
        }
        IField f = type.getField(propertyName);
        if (f != null && f.exists()) {
            return f;
        }
        String getter = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        IMethod m = type.getMethod(getter, new String[0]);
        if (m != null && m.exists()) {
            return m;
        }
        return null;
    }
}

