/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.templates.TemplateContextTypeIdsJSP;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.JSFPreference;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.JSFNavigationModel;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.helpers.JSFProcessHelper;
import org.jboss.tools.jsf.model.impl.NavigationRuleObjectImpl;

public class AddViewSupport
extends SpecialWizardSupport
implements JSFConstants {
    public static String JSF_ADD_VIEW_PATH = JSFPreference.JSF_ADD_VIEW_PATH;
    static String LAST_CREATE_FILE_PREFERENCE = "org.jboss.tools.jsf.lastCreateFileValue";
    XModelObject sample;
    Map<String, Template> templates = null;
    static String FORBIDDEN_INDICES = "\"\n\t*\\:<>?|";
    protected DefaultWizardDataValidator viewValidator = new ViewValidator();

    public void reset() {
        this.sample = (XModelObject)this.getProperties().get("sample");
        if (this.sample != null) {
            this.setAttributeValue(0, "from-view-id", this.sample.getAttributeValue("path"));
        }
        this.loadTemplates();
        String[] s = this.templates.keySet().toArray(new String[0]);
        this.setValueList(0, "template", s);
        this.setAttributeValue(0, "template", this.getDefaultTemplate(s));
        String last = JSFModelPlugin.getDefault().getPluginPreferences().getString(LAST_CREATE_FILE_PREFERENCE);
        if (last == null || last.length() == 0) {
            last = "true";
        } else if (!"true".equals(last)) {
            last = "false";
        }
        this.setAttributeValue(0, "create file", last);
    }

    TemplateStore getTemplateStore() {
        return JSPUIPlugin.getInstance().getTemplateStore();
    }

    String getTemplateString(String templateName) {
        if (templateName == null) {
            return null;
        }
        String templateString = null;
        Template template = this.templates.get(templateName);
        if (template != null) {
            TemplateContextType contextType = JSPUIPlugin.getInstance().getTemplateContextRegistry().getContextType(TemplateContextTypeIdsJSP.NEW);
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                templateString = buffer.getString();
            }
            catch (BadLocationException e) {
                JSFModelPlugin.getDefault().logWarning("Could not create template for new html", e);
            }
            catch (TemplateException e) {
                JSFModelPlugin.getDefault().logWarning("Could not create template for new html", e);
            }
        }
        return templateString;
    }

    void loadTemplates() {
        Template[] ts;
        this.templates = new TreeMap<String, Template>();
        Template[] templateArray = ts = this.getTemplateStore().getTemplates(TemplateContextTypeIdsJSP.NEW);
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            Template t = templateArray[n2];
            this.templates.put(t.getName(), t);
            ++n2;
        }
    }

    static XModelObject getPreferenceObject() {
        return PreferenceModelUtilities.getPreferenceModel().getByPath(JSF_ADD_VIEW_PATH);
    }

    public String getDefaultTemplate(String[] list) {
        String v;
        if (list.length == 0) {
            return "";
        }
        XModelObject addView = AddViewSupport.getPreferenceObject();
        String string = v = addView == null ? "" : addView.getAttributeValue("Page Template");
        if (v != null) {
            int i = 0;
            while (i < list.length) {
                if (v.equals(list[i])) {
                    return list[i];
                }
                ++i;
            }
        }
        return list[0];
    }

    public String getExtension(String template) {
        int i;
        if (template != null && (i = template.trim().lastIndexOf(46)) > 0) {
            return template.trim().substring(i);
        }
        return AddViewSupport.getExtension();
    }

    public static String getExtension() {
        String v;
        XModelObject addView = AddViewSupport.getPreferenceObject();
        String string = v = addView == null ? "" : addView.getAttributeValue("Extension");
        if (v == null || v.length() == 0) {
            return ".jsp";
        }
        if (!v.startsWith(".")) {
            v = "." + v;
        }
        return v;
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        }
    }

    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL, HELP};
    }

    protected void execute() throws XModelException {
        boolean exists;
        boolean doNotCreateEmptyRule = "yes".equals(JSFPreference.DO_NOT_CREATE_EMPTY_RULE.getValue());
        Properties p = this.extractStepData(0);
        String path = p.getProperty("from-view-id");
        path = this.revalidatePath(path, this.getAttributeValue(0, "template"));
        this.createFile(path);
        JSFNavigationModel m = (JSFNavigationModel)this.getTarget().getParent();
        String pp = NavigationRuleObjectImpl.toNavigationRulePathPart(path);
        boolean isPattern = JSFProcessHelper.isPattern(path);
        boolean existsR = m.getRuleCount(path) != 0;
        boolean existsV = this.findView(path) != null;
        boolean bl = exists = existsR || existsV;
        if (exists) {
            ServiceDialog d = this.getTarget().getModel().getService();
            String message = NLS.bind((String)JSFUIMessages.THE_VIEW_WITH_PATH_IS_ALREADY_CREATED, (Object)path);
            message = existsR ? String.valueOf(message) + JSFUIMessages.YOU_WANT_TO_ADD_ADDITIONAL_NAVIGATION_RULE_WITH_SAME_FROM_VIEW_ID : (existsV && isPattern ? String.valueOf(message) + JSFUIMessages.YOU_WANT_TO_CREATE_AN_ADDITIONAL_VIEW_WITH_THE_SAME_FROM_VIEW_ID : String.valueOf(message) + JSFUIMessages.YOU_WANT_TO_CREATE_A_NAVIGATION_RULE_FOR_THIS_FROM_VIEW_ID);
            int q = d.showDialog(JSFUIMessages.WARNING, message, new String[]{JSFUIMessages.OK, JSFUIMessages.CANCEL}, null, 2);
            if (q != 0) {
                return;
            }
        }
        XModelObject created = null;
        if (!doNotCreateEmptyRule || exists && !isPattern || this.sample != null) {
            XModelObject rule = m.addRule(path);
            this.addCasesFromSample(rule);
            m.setModified(true);
            created = this.getTarget().getChildByPath(pp);
        } else {
            created = this.getTarget().getModel().createModelObject("JSFProcessGroup", null);
            String ppi = pp;
            if (exists && JSFProcessHelper.isPattern(path)) {
                int index = -1;
                while (this.getTarget().getChildByPath(String.valueOf(ppi) + ":" + index) != null) {
                    --index;
                }
                ppi = String.valueOf(ppi) + ":" + index;
            }
            created.setAttributeValue("name", ppi);
            created.setAttributeValue("path", path);
            created.setAttributeValue("persistent", "true");
            DefaultCreateHandler.addCreatedObject((XModelObject)this.getTarget(), (XModelObject)created, (Properties)this.getProperties());
        }
        if (!exists || isPattern) {
            String shape = this.getShape();
            if (created != null && shape != null) {
                created.setAttributeValue("shape", shape);
            }
        }
        if (created != null) {
            FindObjectHelper.findModelObject((XModelObject)created, (int)FindObjectHelper.IN_EDITOR_ONLY);
        }
    }

    private XModelObject findView(String path) {
        String pp = NavigationRuleObjectImpl.toNavigationRulePathPart(path);
        XModelObject o = this.getTarget().getChildByPath(pp);
        if (o != null) {
            return o;
        }
        if (!JSFProcessHelper.isPattern(path)) {
            return null;
        }
        XModelObject[] cs = this.getTarget().getChildren();
        int i = 0;
        while (i < cs.length) {
            String p = cs[i].getPathPart();
            if (pp.equals(p) || p.startsWith(String.valueOf(pp) + ":")) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    private void addCasesFromSample(XModelObject rule) {
        if (!(this.sample instanceof ReferenceGroupImpl)) {
            return;
        }
        XModelObject[] rs = ((ReferenceGroupImpl)this.sample).getReferences();
        if (rs == null || rs.length == 0) {
            return;
        }
        int i = 0;
        while (i < rs.length) {
            String caseEntity = rule.getModelEntity().getChildren()[0].getName();
            XModelObject[] cs = rs[i].getChildren();
            int j = 0;
            while (j < cs.length) {
                XModelObject c = cs[j].copy();
                if (c.getModelEntity().getName().equals(caseEntity)) {
                    ((XModelObjectImpl)c).changeEntity(caseEntity);
                }
                rule.addChild(c);
                ++j;
            }
            ++i;
        }
    }

    private String getShape() {
        String x = this.getProperties().getProperty("process.mouse.x");
        String y = this.getProperties().getProperty("process.mouse.y");
        return x == null || y == null ? null : String.valueOf(x) + "," + y + ",0,0";
    }

    public static String revalidatePath(String path) {
        if (path != null) {
            path = path.trim();
        }
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.startsWith("/") && !path.startsWith("*")) {
            path = "/" + path;
        }
        if (path.indexOf(42) >= 0) {
            return path;
        }
        if (path.indexOf(46) < 0 && !path.endsWith("/")) {
            path = String.valueOf(path) + AddViewSupport.getExtension();
        }
        return path;
    }

    String revalidatePath(String path, String template) {
        if (path != null) {
            path = path.trim();
        }
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.startsWith("/") && !path.startsWith("*")) {
            path = "/" + path;
        }
        if (path.indexOf(42) >= 0) {
            return path;
        }
        if (path.indexOf(46) < 0 && !path.endsWith("/")) {
            path = String.valueOf(path) + this.getExtension(template);
        }
        return path;
    }

    public boolean canCreateFile(String path) {
        XModelObject fs = this.getTarget().getModel().getByPath("FileSystems/WEB-ROOT");
        if (fs == null) {
            return false;
        }
        if ((path = this.revalidatePath(path, this.getAttributeValue(0, "template"))) == null || path.length() == 0 || path.indexOf(42) >= 0) {
            return false;
        }
        return AddViewSupport.isCorrectPath(path) && !this.fileExists(path);
    }

    static boolean isCorrectPath(String path) {
        if (path == null || path.equals("/") || path.indexOf("//") >= 0) {
            return false;
        }
        if (path.endsWith("/") || path.indexOf("../") >= 0) {
            return false;
        }
        if (path.endsWith("..")) {
            return false;
        }
        if (path.equals("*")) {
            return true;
        }
        int i = 0;
        while (i < FORBIDDEN_INDICES.length()) {
            if (path.indexOf(FORBIDDEN_INDICES.charAt(i)) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean fileExists(String path) {
        return this.getTarget().getModel().getByPath(path) != null;
    }

    void createFile(String path) throws XModelException {
        if (!this.canCreateFile(path)) {
            return;
        }
        String lastCreateFileValue = this.getAttributeValue(0, "create file");
        JSFModelPlugin.getDefault().getPluginPreferences().setDefault(LAST_CREATE_FILE_PREFERENCE, lastCreateFileValue);
        if (!"true".equals(lastCreateFileValue)) {
            return;
        }
        String template = this.getAttributeValue(0, "template");
        if (template != null) {
            template = template.trim();
        }
        String location = ((FileSystemImpl)this.getTarget().getModel().getByPath("FileSystems/WEB-ROOT")).getAbsoluteLocation();
        location = String.valueOf(location) + path;
        File ft = new File(location);
        String templateString = this.getTemplateString(template);
        try {
            ft.createNewFile();
        }
        catch (IOException iOException) {}
        if (templateString != null) {
            FileUtil.writeFile((File)ft, (String)templateString);
        }
        this.getTarget().getModel().update();
        try {
            EclipseResourceUtil.getResource((XModelObject)this.getTarget()).getProject().refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new XModelException((Throwable)e);
        }
    }

    public WizardDataValidator getValidator(int step) {
        this.viewValidator.setSupport((SpecialWizardSupport)this, step);
        return this.viewValidator;
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        boolean g;
        String path = values.getProperty("from-view-id");
        boolean c = this.canCreateFile(path);
        if (name.equals("create file")) {
            return c;
        }
        boolean bl = g = c && "true".equals(values.getProperty("create file"));
        if (name.equals("template")) {
            return g;
        }
        return true;
    }

    class ViewValidator
    extends DefaultWizardDataValidator {
        ViewValidator() {
        }

        public void validate(Properties data) {
            boolean exists;
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String path = AddViewSupport.this.revalidatePath(data.getProperty("from-view-id"), data.getProperty("template"));
            if (!AddViewSupport.isCorrectPath(path)) {
                this.message = JSFUIMessages.ATTRIBUTE_FROM_VIEW_ID_IS_NOT_CORRECT;
            }
            if (this.message != null) {
                return;
            }
            String template = data.getProperty("template");
            if (template != null && AddViewSupport.this.isFieldEditorEnabled(0, "template", data)) {
                if (template.trim().length() == 0) {
                    this.message = JSFUIMessages.TEMPLATE_IS_NOT_SPECIFIED;
                    return;
                }
                String t = AddViewSupport.this.getTemplateString(template.trim());
                if (t == null) {
                    this.message = JSFUIMessages.TEMPLATE_DOES_NOT_EXIST;
                }
            }
            if (this.message != null) {
                return;
            }
            boolean doNotCreateEmptyRule = "yes".equals(JSFPreference.DO_NOT_CREATE_EMPTY_RULE.getValue());
            JSFNavigationModel m = (JSFNavigationModel)AddViewSupport.this.getTarget().getParent();
            String pp = NavigationRuleObjectImpl.toNavigationRulePathPart(path);
            boolean bl = exists = m.getRuleCount(path) != 0 || AddViewSupport.this.getTarget().getChildByPath(pp) != null;
            if (doNotCreateEmptyRule && exists && !JSFProcessHelper.isPattern(path)) {
                this.message = JSFUIMessages.THE_VIEW_EXISTS;
            }
        }
    }
}

