/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.jboss.tools.jsf.jsf2.refactoring.action.rename.CompositeAttributeRenameDescriptor;
import org.jboss.tools.jsf.jsf2.refactoring.action.rename.IRenameDescriptor;

public class RefactoringActionFactory {
    public static IRenameDescriptor createRenameDescriptor(StructuredTextEditor editorPart) {
        ISelection selection = editorPart.getEditorSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() > 1) {
                return null;
            }
            Object object = structuredSelection.getFirstElement();
            if (object instanceof IDOMAttr) {
                return RefactoringActionFactory.createRenameDescriptor((IDOMAttr)object, (ISourceViewer)editorPart.getTextViewer(), ((IFileEditorInput)editorPart.getEditorInput()).getFile());
            }
        }
        return null;
    }

    public static IRenameDescriptor createRenameDescriptor(IDOMAttr attr, ISourceViewer sourceViewer, IFile file) {
        CompositeAttributeRenameDescriptor renameDescriptor = null;
        String uri = RefactoringActionFactory.createJSF2URIFromPath(file.getParent().getFullPath());
        if ("http://java.sun.com/jsf/composite".equals(uri)) {
            return renameDescriptor;
        }
        if (!attr.getOwnerElement().getNamespaceURI().trim().equalsIgnoreCase("http://java.sun.com/jsf/composite")) {
            return renameDescriptor;
        }
        if (!"attribute".equals(attr.getOwnerElement().getLocalName())) {
            return renameDescriptor;
        }
        int offset = sourceViewer.getSelectedRange().x;
        if (offset > attr.getValueRegionStartOffset() && offset < attr.getValueRegionStartOffset() + attr.getValueRegionText().length()) {
            renameDescriptor = new CompositeAttributeRenameDescriptor(attr, file, uri);
        }
        return renameDescriptor;
    }

    private static String createJSF2URIFromPath(IPath path) {
        StringBuilder uri = new StringBuilder("");
        String[] segments = path.segments();
        if (segments.length > 3 && segments[2].equals("resources")) {
            int i = 3;
            while (i < segments.length) {
                uri.append("/" + segments[i]);
                ++i;
            }
        }
        uri.insert(0, "http://java.sun.com/jsf/composite");
        return uri.toString();
    }
}

