/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.seam.template;

import java.util.StringTokenizer;
import org.jboss.tools.jsf.vpe.seam.template.SeamPdfAbstractChapterTemplate;
import org.jboss.tools.jsf.vpe.seam.template.SeamUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamPdfSectionTemplate
extends SeamPdfAbstractChapterTemplate {
    private nsIDOMElement visualElement;
    private Element sourceElement;
    private String sectionNumberString;
    private String headNameString;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        this.visualElement = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)visualDocument);
        this.sourceElement = (Element)sourceNode;
        this.sectionNumberString = this.calculateSectionNumber(pageContext, this.sourceElement);
        this.headNameString = this.calculateHeadName(this.sectionNumberString);
        nsIDOMElement headNode = visualDocument.createElement(this.headNameString);
        nsIDOMText textNode = visualDocument.createTextNode(this.sectionNumberString);
        headNode.appendChild((nsIDOMNode)textNode);
        this.visualElement.appendChild((nsIDOMNode)headNode);
        return new VpeCreationData((nsIDOMNode)this.visualElement);
    }

    private String calculateSectionNumber(VpePageContext pageContext, Element sourceElement) {
        StringBuffer chapterNumberBuffer = new StringBuffer();
        this.calculateNumberFromTree(pageContext, sourceElement, chapterNumberBuffer);
        Node parentSection = SeamUtil.getParentByName(pageContext, sourceElement, "p:chapter");
        if (parentSection != null) {
            int chapterNumber = this.getChapterNumber(parentSection);
            chapterNumberBuffer.insert(0, String.valueOf(Integer.toString(chapterNumber)) + ".");
        }
        return chapterNumberBuffer.toString();
    }

    private String calculateHeadName(String sectionNumberString) {
        StringTokenizer tokenizer = new StringTokenizer(sectionNumberString, ".", false);
        int headNumber = 0;
        while (tokenizer.hasMoreElements()) {
            tokenizer.nextToken();
            ++headNumber;
        }
        if (headNumber > 6) {
            headNumber = 6;
        }
        return "H" + Integer.toString(headNumber);
    }

    private void calculateNumberFromTree(VpePageContext pageContext, Element sourceElement, StringBuffer sectionNumberString) {
        Node parentSection = SeamUtil.getParentByName(pageContext, sourceElement, "p:section");
        if (parentSection != null) {
            int sectionNum = 0;
            NodeList children = parentSection.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeName().endsWith("section")) {
                    ++sectionNum;
                    if (children.item(i) == sourceElement) {
                        sectionNumberString.insert(0, String.valueOf(Integer.toString(sectionNum)) + ".");
                        break;
                    }
                }
                ++i;
            }
            this.calculateNumberFromTree(pageContext, (Element)parentSection, sectionNumberString);
        } else {
            Node parentChapter = SeamUtil.getParentByName(pageContext, sourceElement, "p:chapter");
            int sectionNum = 0;
            NodeList children = parentChapter.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeName().endsWith("section")) {
                    ++sectionNum;
                    if (children.item(i) == sourceElement) {
                        sectionNumberString.insert(0, String.valueOf(Integer.toString(sectionNum)) + ".");
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private int getChapterNumber(Node chapterNode) {
        int chapterNumber = 1;
        Element chapterElement = (Element)chapterNode;
        String numberAttrName = "number";
        if (chapterElement.hasAttribute(numberAttrName)) {
            String chapterNumberString = chapterElement.getAttribute(numberAttrName);
            try {
                chapterNumber = Integer.parseInt(chapterNumberString);
            }
            catch (NumberFormatException numberFormatException) {
                chapterNumber = 1;
            }
        } else {
            chapterNumber = 1;
        }
        return chapterNumber;
    }

    @Override
    protected nsIDOMElement getHeadElement(VpeCreationData data) {
        nsIDOMNode visualNode = data.getNode();
        nsIDOMNodeList children = visualNode.getChildNodes();
        int i = 0;
        while ((long)i < children.getLength()) {
            String nodeName;
            if (children.item((long)i).getNodeType() == 1 && ("h1".equalsIgnoreCase(nodeName = children.item((long)i).getNodeName()) || "h2".equalsIgnoreCase(nodeName) || "h3".equalsIgnoreCase(nodeName) || "h4".equalsIgnoreCase(nodeName) || "h5".equalsIgnoreCase(nodeName) || "h6".equalsIgnoreCase(nodeName))) {
                return (nsIDOMElement)XPCOM.queryInterface((nsISupports)children.item((long)i), nsIDOMElement.class);
            }
            ++i;
        }
        return null;
    }
}

