/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.runtime.ext;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.spi.CommandInterceptor;

public class AllCommandsInterceptor
implements CommandInterceptor {
    private static final String ESCAPE = new String(new char[]{'\u001b', '%'});
    @Inject
    private Shell shell;

    public String intercept(String line) {
        if (line.startsWith("open ")) {
            return this.doOpenLine(line);
        }
        if (line.startsWith("cd ")) {
            return this.doCdLine(line);
        }
        if (line.startsWith("pick-up ")) {
            return this.doPickUpLine(line);
        }
        return line;
    }

    private String doCdLine(String line) {
        return "cd " + this.handleWorkspaceShortCut(line.substring(3));
    }

    private String doPickUpLine(String line) {
        return "pick-up " + this.handleWorkspaceShortCut(line.substring(8));
    }

    private String doOpenLine(String line) {
        String crn = this.shell.getCurrentResource().getFullyQualifiedName();
        String crt = this.shell.getCurrentResource().getClass().getSimpleName();
        Project project = this.shell.getCurrentProject();
        String cpn = "";
        if (project != null) {
            cpn = project.getProjectRoot().getFullyQualifiedName();
        }
        String par = this.handleWorkspaceShortCut(line.substring(5));
        this.sendEscaped(" EC: " + line + " CRN: " + crn + " CRT: " + crt + " CPN: " + cpn + " PAR: " + par);
        return "\n";
    }

    private String handleWorkspaceShortCut(String str) {
        String result = str;
        if (str.startsWith("#")) {
            result = String.valueOf(this.encloseWithDoubleQuotesIfNeeded(System.getProperty("forge.workspace"))) + str.substring(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEscaped(String str) {
        Shell shell = this.shell;
        synchronized (shell) {
            this.shell.print(String.valueOf(ESCAPE) + str + ESCAPE);
        }
    }

    private String encloseWithDoubleQuotesIfNeeded(String str) {
        if (str.contains(" ") && !this.isEnclosedWithDoubleQuotes(str)) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private boolean isEnclosedWithDoubleQuotes(String str) {
        return str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"';
    }
}

