/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesTabTemplate;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesTabPanelTemplate
extends VpeAbstractTemplate
implements VpeToggableTemplate {
    public static final String CSS_PANEL = "rich-tabpanel";
    public static final String CSS_CONTENT = "rich-tabpanel-content";
    public static final String CSS_CONTENT_POSITION = "rich-tabpanel-content-position";
    public static final String CSS_SIDE_BORDER = "rich-tabhdr-side-border";
    public static final String CSS_SIDE_CELL = "rich-tabhdr-side-cell";
    public static final String CSS_CELL_ACTIVE = "rich-tabhdr-cell-active";
    public static final String CSS_CELL_INACTIVE = "rich-tabhdr-cell-inactive";
    public static final String CSS_CELL_DISABLED = "rich-tabhdr-cell-disabled";
    private static final String RICH_FACES_TAB_PANEL = "richFacesTabPanel";
    private static final String CSS_FILE_PATH = "tabPanel/tabPanel.css";
    private static final String SPACER_FILE_PATH = "common/spacer.gif";
    private static final String INCLUDE_TAG = ":include";
    private static final String YES = "yes";
    private final String HEADER_ALINGMENT = "headerAlignment";
    private final String HEADER_SPACING = "headerSpacing";
    private final String SELECTED_TAB = "selectedTab";
    private final String DIR = "dir";
    private final String DIR_RTL = "RTL";
    private final String DIR_LTR = "LTR";
    private final String HEADER_CLASS = "headerClass";
    private final String CONTENT_CLASS = "contentClass";
    private final String CONTENT_STYLE = "contentStyle";
    private final String TAB_CLASS = "tabClass";
    private final String ACTIVE_TAB_CLASS = "activeTabClass";
    private final String INACTIVE_TAB_CLASS = "inactiveTabClass";
    private final String DISABLED_TAB_CLASS = "disabledTabClass";
    private final String ZERO = "0";
    private final String ONE = "1";
    private final String TWO = "2";
    private final String SPACE = " ";
    private final String EMPTY = "";
    private final String TAB = ":tab";
    private final String NAME = "name";
    private List<nsIDOMElement> storedTabHeaders = new ArrayList<nsIDOMElement>();
    private static Map toggleMap = new HashMap();

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        boolean active;
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement table = visualDocument.createElement("table");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)table);
        ComponentUtil.setCSSLink(pageContext, CSS_FILE_PATH, RICH_FACES_TAB_PANEL);
        this.setDirAttr(table, sourceElement);
        table.setAttribute("class", String.valueOf(ComponentUtil.getAttribute(sourceElement, "styleClass")) + " " + CSS_PANEL);
        table.setAttribute("border", "0");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("style", this.getStyle(sourceElement));
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        table.appendChild((nsIDOMNode)tbody);
        nsIDOMElement tr = visualDocument.createElement("tr");
        tbody.appendChild((nsIDOMNode)tr);
        nsIDOMElement td = visualDocument.createElement("td");
        tr.appendChild((nsIDOMNode)td);
        td.setAttribute("align", this.getHeaderAlignment(sourceElement));
        td.setAttribute("class", ComponentUtil.getAttribute(sourceElement, "headerClass"));
        nsIDOMElement inerTable = visualDocument.createElement("table");
        td.appendChild((nsIDOMNode)inerTable);
        inerTable.setAttribute("border", "0");
        inerTable.setAttribute("cellpadding", "0");
        inerTable.setAttribute("cellspacing", "0");
        nsIDOMElement inerTr = visualDocument.createElement("tr");
        inerTable.appendChild((nsIDOMNode)inerTr);
        nsIDOMElement inerTd = visualDocument.createElement("td");
        inerTr.appendChild((nsIDOMNode)inerTd);
        nsIDOMElement img = visualDocument.createElement("img");
        inerTd.appendChild((nsIDOMNode)img);
        ComponentUtil.setImg(img, SPACER_FILE_PATH);
        img.setAttribute("width", "2");
        img.setAttribute("height", "1");
        img.setAttribute("border", "0");
        List<Node> children = ComponentUtil.getChildren(sourceElement);
        int activeId = this.getActiveId(sourceElement, children);
        int i = 0;
        for (Node child : children) {
            String headerSpacing;
            boolean bl = active = i == activeId;
            if (child.getNodeName().endsWith(INCLUDE_TAG)) {
                VpeChildrenInfo vpeChildrenInfo = new VpeChildrenInfo(inerTr);
                creationData.addChildrenInfo(vpeChildrenInfo);
                vpeChildrenInfo.addSourceChild(child);
            }
            if (!child.getNodeName().endsWith(":tab")) continue;
            String string = headerSpacing = sourceElement.hasAttribute("headerSpacing") ? sourceElement.getAttribute("headerSpacing") : "1";
            if (i == 0) {
                this.addSpacer(visualDocument, inerTr, headerSpacing);
            }
            nsIDOMElement headerTd = RichFacesTabTemplate.encodeHeader(pageContext, creationData, (Element)child, visualDocument, inerTr, active, ComponentUtil.getAttribute(sourceElement, "tabClass"), (String.valueOf(ComponentUtil.getAttribute(sourceElement, "activeTabClass")) + " " + CSS_CELL_ACTIVE).trim(), (String.valueOf(ComponentUtil.getAttribute(sourceElement, "inactiveTabClass")) + " " + CSS_CELL_INACTIVE).trim(), (String.valueOf(ComponentUtil.getAttribute(sourceElement, "disabledTabClass")) + " " + CSS_CELL_DISABLED).trim(), String.valueOf(i));
            ++i;
            this.addSpacer(visualDocument, inerTr, headerSpacing);
            this.storedTabHeaders.add(headerTd);
        }
        inerTd = visualDocument.createElement("td");
        inerTr.appendChild((nsIDOMNode)inerTd);
        img = visualDocument.createElement("img");
        inerTd.appendChild((nsIDOMNode)img);
        ComponentUtil.setImg(img, SPACER_FILE_PATH);
        img.setAttribute("width", "1");
        img.setAttribute("height", "1");
        img.setAttribute("border", "0");
        inerTr = visualDocument.createElement("tr");
        tbody.appendChild((nsIDOMNode)inerTr);
        children = ComponentUtil.getChildren(sourceElement);
        i = 0;
        for (Node child : children) {
            boolean bl = active = i == activeId;
            if (!child.getNodeName().endsWith(":tab")) continue;
            ++i;
            if (!active) continue;
            RichFacesTabTemplate.encodeBody(pageContext, creationData, (Element)child, visualDocument, inerTr, true, String.valueOf(ComponentUtil.getAttribute(sourceElement, "contentClass")) + " " + CSS_PANEL + " " + CSS_CONTENT + " " + CSS_CONTENT_POSITION, ComponentUtil.getAttribute(sourceElement, "contentStyle"));
            break;
        }
        return creationData;
    }

    private void addSpacer(nsIDOMDocument visualDocument, nsIDOMElement parentTr, String headerSpacing) {
        nsIDOMElement spaceTd = visualDocument.createElement("td");
        parentTr.appendChild((nsIDOMNode)spaceTd);
        nsIDOMElement spaceImg = visualDocument.createElement("img");
        spaceTd.appendChild((nsIDOMNode)spaceImg);
        ComponentUtil.setImg(spaceImg, SPACER_FILE_PATH);
        spaceImg.setAttribute("height", "1");
        spaceImg.setAttribute("border", "0");
        spaceImg.setAttribute("style", "width: " + headerSpacing + "px");
    }

    private int getActiveId(Element sourceElement, List<Node> children) {
        int count;
        int activeId = -1;
        try {
            activeId = Integer.valueOf((String)toggleMap.get(sourceElement));
        }
        catch (NumberFormatException numberFormatException) {
            activeId = -1;
        }
        if (activeId == -1 && sourceElement.hasAttribute("selectedTab")) {
            activeId = this.getTabId(children, sourceElement.getAttribute("selectedTab"));
        }
        if (activeId == -1) {
            activeId = 0;
        }
        if ((count = this.getChildrenCount(children)) - 1 < activeId) {
            activeId = count - 1;
        }
        return activeId;
    }

    private int getChildrenCount(List<Node> children) {
        int count = 0;
        for (Node child : children) {
            if (!child.getNodeName().endsWith(":tab")) continue;
            ++count;
        }
        return count;
    }

    private int getTabId(List<Node> children, String tabName) {
        int count = 0;
        for (Node child : children) {
            if (!child.getNodeName().endsWith(":tab") || !(child instanceof Element)) continue;
            String name = ((Element)child).getAttribute("name");
            if (tabName.equals(name)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    private String getStyle(Element sourceElement) {
        String style;
        String styleAttrValue = sourceElement.getAttribute("style");
        String string = style = sourceElement.hasAttribute("style") ? styleAttrValue : "";
        if (!ComponentUtil.parameterPresent(styleAttrValue, "width")) {
            String width = sourceElement.hasAttribute("width") ? sourceElement.getAttribute("width") : "100%";
            style = ComponentUtil.addParameter(style, "width:" + width);
        }
        if (!ComponentUtil.parameterPresent(styleAttrValue, "height")) {
            String height;
            String string2 = height = sourceElement.hasAttribute("height") ? sourceElement.getAttribute("height") : "";
            if (height.length() > 0) {
                style = ComponentUtil.addParameter(style, "height:" + height);
            }
        }
        return style;
    }

    private void setDirAttr(nsIDOMElement element, Element sourceElement) {
        String dir = ComponentUtil.getAttribute(sourceElement, "dir");
        if (dir != null && !"".equals(dir) && ("LTR".equalsIgnoreCase(dir) || "RTL".equalsIgnoreCase(dir))) {
            element.setAttribute("dir", dir);
        }
    }

    private String getHeaderAlignment(Element sourceElement) {
        return sourceElement.hasAttribute("headerAlignment") ? sourceElement.getAttribute("headerAlignment") : "left";
    }

    public void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        toggleMap.put(sourceNode, toggleId);
    }

    public void stopToggling(Node sourceNode) {
        toggleMap.remove(sourceNode);
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        ArrayList<nsIDOMNode> elements = new ArrayList<nsIDOMNode>();
        ComponentUtil.findAllElementsByName(data.getNode(), elements, "table");
        for (nsIDOMNode node : elements) {
            try {
                nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
                if (ComponentUtil.getAttribute(element, "tabheaderattr").equalsIgnoreCase(YES)) {
                    element.removeAttribute("style");
                }
                if (!ComponentUtil.getAttribute(element, "tabbodyattr").equalsIgnoreCase(YES)) continue;
                element.setAttribute("style", "display:none;");
            }
            catch (XPCOMException xPCOMException) {}
        }
        super.validate(pageContext, sourceNode, visualDocument, data);
        if (this.storedTabHeaders == null || this.storedTabHeaders.size() < 1) {
            return;
        }
        for (nsIDOMElement tab : this.storedTabHeaders) {
            String value = tab.getAttribute("vpe-user-toggle-id");
            ComponentUtil.applyAttributeValueOnChildren("vpe-user-toggle-id", value, ComponentUtil.getElementChildren(tab));
            ComponentUtil.applyAttributeValueOnChildren("vpe-user-toggle-lookup-parent", "true", ComponentUtil.getElementChildren(tab));
        }
    }
}

