/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesListShuttleTemplate
extends VpeAbstractTemplate {
    private static final String SOURCE_CAPTION = "sourceCaption";
    private static final String TARGET_CAPTION = "targetCaption";
    private static final String STYLE_PATH = "shuttle/shuttle.css";
    private static final String BUTTON_IMG_PATH = "shuttle/button.gif";
    private static final String HEADER_IMG_PATH = "shuttle/header.gif";
    private static final String DEFAULT_LIST_WIDTH = "140px";
    private static final String DEFAULT_LIST_HEIGHT = "140px";
    private static final String ATTR_SOURCE_LIST_WIDTH = "sourceListWidth";
    private static final String ATTR_TARGET_LIST_WIDTH = "targetListWidth";
    private static final String ATTR_LISTS_HEIGHT = "listsHeight";
    private static final String ATTR_FAST_MOVE_CONTROLS_VIZIBLE = "fastMoveControlsVisible";
    private static final String ATTR_FAST_ORDER_CONTROLS_VIZIBLE = "fastOrderControlsVisible";
    private static final String ATTR_MOVE_CONTROLS_VIZIBLE = "moveControlsVisible";
    private static final String ATTR_ORDER_CONTROLS_VIZIBLE = "orderControlsVisible";
    private static final String DEFAULT_BUTTON_ALIGN = "middle";
    private static final String ATTR_MOVE_CONTROLS_VERTICAL_ALIGN = "moveControlsVerticalAlign";
    private static final String ATTR_ORDER_CONTROLS_VERTICAL_ALIGN = "orderControlsVerticalAlign";
    private static final Map<String, String> buttonImages = new HashMap<String, String>();
    private static final Map<String, String> defaultStyleClasses;
    private static final Map<String, String> defaultLabels;
    private static final List<String> fastMoveButtons;
    private static final List<String> moveButtons;
    private static final List<String> fastOrderButtons;
    private static final List<String> orderButtons;
    private final Map<String, String> labels = new HashMap<String, String>();
    private final List<String> sourceButtons = new ArrayList<String>();
    private final List<String> targetButtons = new ArrayList<String>();
    private static final Map<String, String> styleClasses;
    private String sourceButtonsAlign;
    private String targetButtonsAlign;
    private String listsHeight;
    private String sourceListsWidth;
    private String targetListsWidth;
    private String rowClass;
    private List<String> columnClasses;
    private final Map<String, Node> facetLabels = new HashMap<String, Node>();
    private boolean isShowButtonLabels;

    static {
        buttonImages.put("copyAllControl", "shuttle/arrow_copy_all.gif");
        buttonImages.put("copyControl", "shuttle/arrow_copy.gif");
        buttonImages.put("removeControl", "shuttle/arrow_remove.gif");
        buttonImages.put("removeAllControl", "shuttle/arrow_remove_all.gif");
        buttonImages.put("topControl", "shuttle/arrow_first.gif");
        buttonImages.put("upControl", "shuttle/arrow_up.gif");
        buttonImages.put("downControl", "shuttle/arrow_down.gif");
        buttonImages.put("bottomControl", "shuttle/arrow_last.gif");
        defaultStyleClasses = new HashMap<String, String>();
        defaultStyleClasses.put("style", "rich-list-shuttle");
        defaultStyleClasses.put("header", "rich-shuttle-list-header");
        defaultStyleClasses.put("headerCell", "rich-shuttle-header-tab-cell");
        defaultStyleClasses.put("list", "rich-shuttle-list-content");
        defaultStyleClasses.put("controls", "rich-shuttle-controls");
        defaultStyleClasses.put("copyAllControl", "rich-shuttle-button rich-shuttle-copyAll");
        defaultStyleClasses.put("copyControl", "rich-shuttle-button rich-shuttle-copy");
        defaultStyleClasses.put("removeControl", "rich-shuttle-button rich-shuttle-remove");
        defaultStyleClasses.put("removeAllControl", "rich-shuttle-button rich-shuttle-removeAll");
        defaultStyleClasses.put("topControl", "rich-shuttle-button rich-shuttle-top");
        defaultStyleClasses.put("upControl", "rich-shuttle-button rich-shuttle-up");
        defaultStyleClasses.put("downControl", "rich-shuttle-button rich-shuttle-down");
        defaultStyleClasses.put("bottomControl", "rich-shuttle-button rich-shuttle-bottom");
        defaultStyleClasses.put(SOURCE_CAPTION, "rich-shuttle-source-caption");
        defaultStyleClasses.put(TARGET_CAPTION, "rich-shuttle-target-caption");
        defaultStyleClasses.put("sourceRow", "rich-shuttle-source-row");
        defaultStyleClasses.put("targetRow", "rich-shuttle-target-row");
        defaultStyleClasses.put("columns", "");
        defaultLabels = new HashMap<String, String>();
        defaultLabels.put("copyAllControl", "Copy all");
        defaultLabels.put("copyControl", "Copy");
        defaultLabels.put("removeControl", "Remove");
        defaultLabels.put("removeAllControl", "Remove All");
        defaultLabels.put("topControl", "First");
        defaultLabels.put("upControl", "Up");
        defaultLabels.put("downControl", "Down");
        defaultLabels.put("bottomControl", "Last");
        defaultLabels.put(SOURCE_CAPTION, "");
        defaultLabels.put(TARGET_CAPTION, "");
        fastMoveButtons = Arrays.asList("copyAllControl", "removeAllControl");
        moveButtons = Arrays.asList("copyControl", "removeControl");
        fastOrderButtons = Arrays.asList("topControl", "bottomControl");
        orderButtons = Arrays.asList("upControl", "downControl");
        styleClasses = new HashMap<String, String>();
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        this.prepareData(sourceElement);
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, "shuttle");
        nsIDOMElement basicTable = visualDocument.createElement("table");
        basicTable.setAttribute("class", styleClasses.get("style"));
        String styleAttr = sourceElement.hasAttribute("style") ? sourceElement.getAttribute("style") : null;
        basicTable.setAttribute("style", styleAttr);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)basicTable);
        creationData.addChildrenInfo(new VpeChildrenInfo(null));
        nsIDOMElement caption = this.createCaption(visualDocument, creationData);
        if (caption != null) {
            basicTable.appendChild((nsIDOMNode)caption);
        }
        nsIDOMElement basicTr = visualDocument.createElement("tr");
        nsIDOMElement sourceBoxTd = visualDocument.createElement("td");
        nsIDOMElement sourceBox = this.createBox(visualDocument, creationData, RichFacesListShuttleTemplate.getChildren(sourceNode), "source");
        sourceBox.setAttribute("style", "width:" + this.sourceListsWidth + ";" + "height" + ":" + this.listsHeight + ";");
        sourceBoxTd.appendChild((nsIDOMNode)sourceBox);
        nsIDOMElement sourceButtonsTd = visualDocument.createElement("td");
        nsIDOMElement sourceButtonsBlock = this.createButtonsBlock(visualDocument, creationData, this.sourceButtons);
        sourceButtonsTd.appendChild((nsIDOMNode)sourceButtonsBlock);
        sourceButtonsTd.setAttribute("style", "vertical-align:" + this.sourceButtonsAlign);
        nsIDOMElement targetBoxTd = visualDocument.createElement("td");
        nsIDOMElement targetBox = this.createBox(visualDocument, creationData, RichFacesListShuttleTemplate.getChildren(sourceNode), "target");
        targetBox.setAttribute("style", "width:" + this.targetListsWidth + ";" + "height" + ":" + this.listsHeight + ";");
        targetBoxTd.appendChild((nsIDOMNode)targetBox);
        nsIDOMElement targetButtonsTd = visualDocument.createElement("td");
        nsIDOMElement targetButtonsBlock = this.createButtonsBlock(visualDocument, creationData, this.targetButtons);
        targetButtonsTd.appendChild((nsIDOMNode)targetButtonsBlock);
        targetButtonsTd.setAttribute("style", "vertical-align:" + this.targetButtonsAlign);
        basicTr.appendChild((nsIDOMNode)sourceBoxTd);
        basicTr.appendChild((nsIDOMNode)sourceButtonsTd);
        basicTr.appendChild((nsIDOMNode)targetBoxTd);
        basicTr.appendChild((nsIDOMNode)targetButtonsTd);
        basicTable.appendChild((nsIDOMNode)basicTr);
        this.clearData();
        return creationData;
    }

    private nsIDOMElement createCaption(nsIDOMDocument visualDocument, VpeCreationData creationData) {
        if (this.labels.get(SOURCE_CAPTION).length() == 0 && !this.facetLabels.containsKey(SOURCE_CAPTION) && this.labels.get(TARGET_CAPTION).length() == 0 && !this.facetLabels.containsKey(TARGET_CAPTION)) {
            return null;
        }
        nsIDOMElement caption = visualDocument.createElement("tr");
        caption.appendChild((nsIDOMNode)this.createCaptionLabel(visualDocument, creationData, SOURCE_CAPTION));
        caption.appendChild((nsIDOMNode)this.createCaptionLabel(visualDocument, creationData, TARGET_CAPTION));
        return caption;
    }

    private nsIDOMElement createCaptionLabel(nsIDOMDocument visualDocument, VpeCreationData creationData, String labelId) {
        nsIDOMElement captionLabelTd = visualDocument.createElement("td");
        captionLabelTd.setAttribute("colspan", "2");
        captionLabelTd.setAttribute("class", styleClasses.get(labelId));
        if (this.facetLabels.containsKey(labelId)) {
            VpeChildrenInfo captionLabelTdInfo = new VpeChildrenInfo(captionLabelTd);
            creationData.addChildrenInfo(captionLabelTdInfo);
            captionLabelTdInfo.addSourceChild(this.facetLabels.get(labelId));
        } else {
            nsIDOMText captionLabelText = visualDocument.createTextNode(this.labels.get(labelId));
            captionLabelTd.appendChild((nsIDOMNode)captionLabelText);
        }
        return captionLabelTd;
    }

    private nsIDOMElement createBox(nsIDOMDocument visualDocument, VpeCreationData creationData, List<Node> children, String boxId) {
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("class", styleClasses.get("list"));
        nsIDOMElement box = visualDocument.createElement("table");
        box.setAttribute("cellspacing", "0");
        box.setAttribute("cellpadding", "0");
        box.setAttribute("width", "100%");
        nsIDOMElement header = this.createHeader(visualDocument, creationData, children);
        if (header != null) {
            box.appendChild((nsIDOMNode)header);
        }
        nsIDOMElement tr = visualDocument.createElement("tr");
        tr.setAttribute("style", "vertical-align:top");
        tr.setAttribute("class", String.valueOf(styleClasses.get(String.valueOf(boxId) + "Row")) + " " + this.rowClass);
        int columnCount = 0;
        for (Node child : children) {
            String localName;
            if (child.getNodeType() != 1 || !"column".equals(localName = child.getLocalName()) && !"columns".equals(localName)) continue;
            nsIDOMElement column = visualDocument.createElement("td");
            tr.appendChild((nsIDOMNode)column);
            if (this.columnClasses.size() > 0) {
                String columnClass = this.columnClasses.get(columnCount % this.columnClasses.size());
                column.setAttribute("class", columnClass);
            }
            nsIDOMElement columnTable = visualDocument.createElement("table");
            column.appendChild((nsIDOMNode)columnTable);
            nsIDOMElement columnTableTr = visualDocument.createElement("tr");
            columnTable.appendChild((nsIDOMNode)columnTableTr);
            VpeChildrenInfo columnTableTrInfo = new VpeChildrenInfo(columnTableTr);
            creationData.addChildrenInfo(columnTableTrInfo);
            columnTableTrInfo.addSourceChild(child);
            ++columnCount;
        }
        box.appendChild((nsIDOMNode)tr);
        div.appendChild((nsIDOMNode)box);
        return div;
    }

    private nsIDOMElement createButtonsBlock(nsIDOMDocument visualDocument, VpeCreationData creationData, List<String> buttonNames) {
        nsIDOMElement buttonsBlock = visualDocument.createElement("div");
        buttonsBlock.setAttribute("class", styleClasses.get("controls"));
        for (String buttonId : buttonNames) {
            buttonsBlock.appendChild((nsIDOMNode)this.createButton(visualDocument, creationData, buttonId));
        }
        return buttonsBlock;
    }

    private nsIDOMElement createButton(nsIDOMDocument visualDocument, VpeCreationData creationData, String buttonId) {
        nsIDOMElement buttonSpace = visualDocument.createElement("div");
        buttonSpace.setAttribute("class", "rich-shuttle-control");
        if (this.facetLabels.containsKey(buttonId)) {
            VpeChildrenInfo buttonInfo = new VpeChildrenInfo(buttonSpace);
            creationData.addChildrenInfo(buttonInfo);
            buttonInfo.addSourceChild(this.facetLabels.get(buttonId));
        } else {
            nsIDOMElement metaButton = visualDocument.createElement("div");
            metaButton.setAttribute("style", ComponentUtil.getBackgoundImgStyle(BUTTON_IMG_PATH));
            metaButton.setAttribute("class", "rich-shuttle-meta-button");
            nsIDOMElement button = visualDocument.createElement("div");
            button.setAttribute("class", styleClasses.get(buttonId));
            nsIDOMElement buttonContent = visualDocument.createElement("div");
            buttonContent.setAttribute("class", "rich-shuttle-button-content");
            nsIDOMElement buttonImage = visualDocument.createElement("img");
            buttonImage.setAttribute("width", "15");
            buttonImage.setAttribute("height", "15");
            ComponentUtil.setImg(buttonImage, buttonImages.get(buttonId));
            buttonContent.appendChild((nsIDOMNode)buttonImage);
            if (this.isShowButtonLabels) {
                nsIDOMText buttonText = visualDocument.createTextNode(this.labels.get(buttonId));
                buttonContent.appendChild((nsIDOMNode)buttonText);
            }
            button.appendChild((nsIDOMNode)buttonContent);
            metaButton.appendChild((nsIDOMNode)button);
            buttonSpace.appendChild((nsIDOMNode)metaButton);
        }
        return buttonSpace;
    }

    private void prepareData(Element sourceElement) {
        Set<String> labelsKeys = defaultLabels.keySet();
        this.isShowButtonLabels = !"false".equalsIgnoreCase(sourceElement.getAttribute("showButtonLabels"));
        for (String key : labelsKeys) {
            if (sourceElement.hasAttribute(String.valueOf(key) + "Label")) {
                String label = sourceElement.getAttribute(String.valueOf(key) + "Label");
                this.labels.put(key, label);
                continue;
            }
            this.labels.put(key, defaultLabels.get(key));
        }
        Set<String> styleClassesKeys = defaultStyleClasses.keySet();
        for (String key : styleClassesKeys) {
            if (sourceElement.hasAttribute(String.valueOf(key) + "Class")) {
                String styleClass = sourceElement.getAttribute(String.valueOf(key) + "Class");
                styleClasses.put(key, String.valueOf(defaultStyleClasses.get(key)) + " " + styleClass);
                continue;
            }
            styleClasses.put(key, defaultStyleClasses.get(key));
        }
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && "facet".equals(child.getLocalName()) && defaultLabels.containsKey(((Element)child).getAttribute("name"))) {
                this.facetLabels.put(((Element)child).getAttribute("name"), child);
            }
            ++i;
        }
        if (sourceElement.hasAttribute("rowClasses")) {
            String rowClasses = sourceElement.getAttribute("rowClasses");
            this.rowClass = rowClasses.split("[,;]")[0];
        }
        if (sourceElement.hasAttribute("columnClasses")) {
            String columnClassesAtribute = sourceElement.getAttribute("columnClasses");
            this.columnClasses = Arrays.asList(columnClassesAtribute.split("[,;]"));
        } else {
            this.columnClasses = new ArrayList<String>();
        }
        if (!"none".equalsIgnoreCase(sourceElement.getAttribute("controlsType"))) {
            if (!"false".equalsIgnoreCase(sourceElement.getAttribute(ATTR_FAST_MOVE_CONTROLS_VIZIBLE))) {
                this.sourceButtons.addAll(fastMoveButtons);
            }
            if (!"false".equalsIgnoreCase(sourceElement.getAttribute(ATTR_MOVE_CONTROLS_VIZIBLE))) {
                this.sourceButtons.addAll(this.sourceButtons.size() == 0 ? 0 : 1, moveButtons);
            }
            if (!"false".equalsIgnoreCase(sourceElement.getAttribute(ATTR_FAST_ORDER_CONTROLS_VIZIBLE))) {
                this.targetButtons.addAll(fastOrderButtons);
            }
            if (!"false".equalsIgnoreCase(sourceElement.getAttribute(ATTR_ORDER_CONTROLS_VIZIBLE))) {
                this.targetButtons.addAll(this.targetButtons.size() == 0 ? 0 : 1, orderButtons);
            }
        }
        this.sourceButtonsAlign = sourceElement.hasAttribute(ATTR_MOVE_CONTROLS_VERTICAL_ALIGN) ? sourceElement.getAttribute(ATTR_MOVE_CONTROLS_VERTICAL_ALIGN) : DEFAULT_BUTTON_ALIGN;
        String string = this.targetButtonsAlign = sourceElement.hasAttribute(ATTR_ORDER_CONTROLS_VERTICAL_ALIGN) ? sourceElement.getAttribute(ATTR_ORDER_CONTROLS_VERTICAL_ALIGN) : DEFAULT_BUTTON_ALIGN;
        if (sourceElement.hasAttribute(ATTR_LISTS_HEIGHT)) {
            String listsHeightVal = sourceElement.getAttribute(ATTR_LISTS_HEIGHT);
            this.listsHeight = VpeStyleUtil.addPxIfNecessary((String)listsHeightVal);
        } else {
            this.listsHeight = "140px";
        }
        if (sourceElement.hasAttribute(ATTR_SOURCE_LIST_WIDTH)) {
            String listWidthVal = sourceElement.getAttribute(ATTR_SOURCE_LIST_WIDTH);
            this.sourceListsWidth = VpeStyleUtil.addPxIfNecessary((String)listWidthVal);
        } else {
            this.sourceListsWidth = "140px";
        }
        if (sourceElement.hasAttribute(ATTR_TARGET_LIST_WIDTH)) {
            String listWidthVal = sourceElement.getAttribute(ATTR_TARGET_LIST_WIDTH);
            this.targetListsWidth = VpeStyleUtil.addPxIfNecessary((String)listWidthVal);
        } else {
            this.targetListsWidth = "140px";
        }
    }

    private void clearData() {
        this.labels.clear();
        styleClasses.clear();
        this.sourceButtons.clear();
        this.targetButtons.clear();
        this.facetLabels.clear();
    }

    private Element getNodeFacet(Node node, String name) {
        NodeList children = node.getChildNodes();
        Element facet = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && "facet".equals(child.getLocalName()) && name.equals(((Element)child).getAttribute("name"))) {
                facet = (Element)child;
            }
            ++i;
        }
        return facet;
    }

    private boolean haveFacet(List<Node> children, String name) {
        for (Node node : children) {
            if (this.getNodeFacet(node, name) == null) continue;
            return true;
        }
        return false;
    }

    private nsIDOMElement createHeader(nsIDOMDocument visualDocument, VpeCreationData creationData, List<Node> children) {
        if (!this.haveFacet(children, "header")) {
            return null;
        }
        nsIDOMElement header = visualDocument.createElement("tr");
        header.setAttribute("class", styleClasses.get(header));
        for (Node child : children) {
            String localName = child.getLocalName();
            if (!"column".equals(localName) && !"columns".equals(localName)) continue;
            nsIDOMElement headerCell = visualDocument.createElement("th");
            headerCell.setAttribute("background", "file:///" + ComponentUtil.getAbsoluteResourcePath(HEADER_IMG_PATH).replace('\\', '/'));
            String headerClass = styleClasses.get("headerCell");
            if (child instanceof Element && ((Element)child).hasAttribute("headerClass")) {
                headerClass = String.valueOf(headerClass) + " " + ((Element)child).getAttribute("headerClass");
            }
            headerCell.setAttribute("class", headerClass);
            Element facet = this.getNodeFacet(child, "header");
            if (facet != null) {
                VpeChildrenInfo headerCellInfo = new VpeChildrenInfo(headerCell);
                creationData.addChildrenInfo(headerCellInfo);
                headerCellInfo.addSourceChild((Node)facet);
            } else {
                nsIDOMElement pre = visualDocument.createElement("pre");
                pre.appendChild((nsIDOMNode)visualDocument.createTextNode(""));
                headerCell.appendChild((nsIDOMNode)pre);
            }
            header.appendChild((nsIDOMNode)headerCell);
        }
        return header;
    }

    public static List<Node> getChildren(Node sourceNode) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodeList = sourceNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            children.add(child);
            ++i;
        }
        return children;
    }
}

