/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesLayoutTemplate
extends VpeAbstractTemplate {
    private static final String FLOAT_LEFT_STYLE = ";float: left;";
    private static final String FLOAT_RIGHT_STYLE = ";float: right;";
    private static final String BOTTOM_SECONDARY_DIV_STYLE = ";display: block; height: 0; clear: both; visibility: hidden;";
    private static final String BOTTOM_SECONDARY_DIV_TEXT = ".";
    private static final String LAYOUT_PANEL_NAME = ":layoutPanel";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        VpeCreationData creationData = null;
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement mainDiv = visualDocument.createElement("div");
        String style = sourceElement.getAttribute("style");
        if (ComponentUtil.isNotBlank(style)) {
            mainDiv.setAttribute("style", style);
        }
        nsIDOMElement topDiv = visualDocument.createElement("div");
        nsIDOMElement centerDiv = visualDocument.createElement("div");
        nsIDOMElement leftDiv = visualDocument.createElement("div");
        nsIDOMElement rightDiv = visualDocument.createElement("div");
        nsIDOMElement bottomDiv = visualDocument.createElement("div");
        nsIDOMElement bottomSecondaryDiv = visualDocument.createElement("div");
        creationData = new VpeCreationData((nsIDOMNode)mainDiv);
        bottomSecondaryDiv.setAttribute("style", BOTTOM_SECONDARY_DIV_STYLE);
        bottomSecondaryDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(BOTTOM_SECONDARY_DIV_TEXT));
        bottomDiv.appendChild((nsIDOMNode)bottomSecondaryDiv);
        NodeList children = sourceNode.getChildNodes();
        HashMap<String, Element> panels = new HashMap<String, Element>();
        String[] widthStrings = new String[]{"", "", ""};
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            String position;
            Node node = children.item(i);
            if (node instanceof Element && node.getNodeName() != null && node.getNodeName().indexOf(LAYOUT_PANEL_NAME) > 0 && ComponentUtil.isNotBlank(position = (element = (Element)node).getAttribute("position"))) {
                if ("top".equalsIgnoreCase(position)) {
                    panels.put("top", element);
                } else if ("left".equalsIgnoreCase(position)) {
                    panels.put("left", element);
                    widthStrings[0] = element.getAttribute("width");
                } else if ("center".equalsIgnoreCase(position)) {
                    panels.put("center", element);
                    widthStrings[1] = element.getAttribute("width");
                } else if ("right".equalsIgnoreCase(position)) {
                    panels.put("right", element);
                    widthStrings[2] = element.getAttribute("width");
                } else if ("bottom".equalsIgnoreCase(position)) {
                    panels.put("bottom", element);
                }
            }
            ++i;
        }
        double[] widths = new double[]{-1.0, -1.0, -1.0};
        int i2 = 0;
        while (i2 < widthStrings.length) {
            widths[i2] = this.parseWidthFromPercents(widthStrings[i2]);
            ++i2;
        }
        boolean widthOverflow = false;
        double[] dArray = widths;
        int n = widths.length;
        int n2 = 0;
        while (n2 < n) {
            double w = dArray[n2];
            if (w > 100.0) {
                widthOverflow = true;
            }
            ++n2;
        }
        if (!widthOverflow) {
            double totalWidth = 0.0;
            Object[] objectArray = widths;
            int n3 = widths.length;
            int n4 = 0;
            while (n4 < n3) {
                double w = objectArray[n4];
                if (w > 0.0) {
                    totalWidth += w;
                }
                ++n4;
            }
            int noWeightColumns = 0;
            objectArray = widthStrings;
            n3 = widthStrings.length;
            n4 = 0;
            while (n4 < n3) {
                double ws = objectArray[n4];
                if (ws == null || "".equalsIgnoreCase((String)ws)) {
                    ++noWeightColumns;
                }
                ++n4;
            }
            double totalFreeWidth = 100.0 - totalWidth;
            double availableWidth = 100.0;
            if (totalWidth < 100.0 && noWeightColumns > 0) {
                availableWidth = totalWidth;
            }
            double[] coeffs = new double[]{-1.0, -1.0, -1.0};
            int i3 = 0;
            while (i3 < widths.length) {
                if (widths[i3] > 0.0) {
                    coeffs[i3] = widths[i3] / totalWidth;
                    BigDecimal b = new BigDecimal(availableWidth * coeffs[i3]).setScale(2, 4);
                    widthStrings[i3] = String.valueOf(b.doubleValue()) + "%";
                }
                ++i3;
            }
            if (totalFreeWidth > 0.0 && noWeightColumns > 0) {
                BigDecimal b = new BigDecimal(totalFreeWidth / (double)noWeightColumns).setScale(2, 4);
                int i4 = 0;
                while (i4 < widthStrings.length) {
                    if (widthStrings[i4] == null || "".equalsIgnoreCase(widthStrings[i4])) {
                        widthStrings[i4] = String.valueOf(b.doubleValue()) + "%";
                    }
                    ++i4;
                }
            }
        }
        this.addPanelFromMap("top", panels, mainDiv, topDiv, "", null, creationData);
        this.addPanelFromMap("left", panels, mainDiv, leftDiv, FLOAT_LEFT_STYLE, widthStrings[0], creationData);
        this.addPanelFromMap("center", panels, mainDiv, centerDiv, FLOAT_LEFT_STYLE, widthStrings[1], creationData);
        this.addPanelFromMap("right", panels, mainDiv, rightDiv, FLOAT_RIGHT_STYLE, widthStrings[2], creationData);
        this.addPanelFromMap("bottom", panels, mainDiv, bottomDiv, "", null, creationData);
        return creationData;
    }

    private double parseWidthFromPercents(String widthStr) {
        double result = -1.0;
        if (widthStr != null && widthStr.endsWith("%")) {
            try {
                result = Double.parseDouble(widthStr.substring(0, widthStr.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private void addPanelFromMap(String panelPositionMapName, Map<String, Element> panelsMap, nsIDOMElement mainDiv, nsIDOMElement panelDiv, String style, String panelWidth, VpeCreationData creationData) {
        Element panel = panelsMap.get(panelPositionMapName);
        if (panel != null) {
            String widthStr = panel.getAttribute("width");
            if (!"top".equalsIgnoreCase(panelPositionMapName) && !"bottom".equalsIgnoreCase(panelPositionMapName) && panelWidth != null) {
                style = String.valueOf(style) + "; width: " + panelWidth + ";";
            }
            if (ComponentUtil.isNotBlank(widthStr)) {
                panelDiv.setAttribute("width", widthStr);
            }
            panelDiv.setAttribute("style", style);
            mainDiv.appendChild((nsIDOMNode)panelDiv);
            VpeChildrenInfo panelInfo = new VpeChildrenInfo(panelDiv);
            panelInfo.addSourceChild((Node)panel);
            creationData.addChildrenInfo(panelInfo);
        }
    }
}

