/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.m2e.egit.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.m2e.scm.spi.ScmHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgitScmHandler
extends ScmHandler {
    private final Logger log = LoggerFactory.getLogger(EgitScmHandler.class);
    public static final String GIT_SCM_ID = "scm:git:";

    public void checkoutProject(MavenProjectScmInfo info, File location, IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.log.debug("Checking out project from {} to {}", (Object)info, (Object)location);
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                URIish uri = this.getUri(info);
                String refName = this.getRefName(info);
                CloneOperation clone = new CloneOperation(uri, true, new ArrayList(), location, refName, "origin", this.getTimeout());
                clone.run((IProgressMonitor)pm.newChild(99));
                this.fixAutoCRLF(clone.getGitDir());
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), cause.getMessage(), cause));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), e.getMessage(), (Throwable)e));
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), e.getMessage(), (Throwable)e));
            }
            catch (InterruptedException interruptedException) {
                pm.done();
            }
        }
        finally {
            pm.done();
        }
    }

    protected int getTimeout() {
        return 30;
    }

    protected URIish getUri(MavenProjectScmInfo info) throws URISyntaxException {
        String url = info.getRepositoryUrl();
        URIish uri = new URIish(url = this.normalizeUri(url));
        if (this.isProtocolAuthAware(uri.getScheme()) && info.getUsername() != null && info.getUsername().length() > 0 && (uri.getUser() == null || info.getUsername().equals(uri.getUser()))) {
            uri = uri.setUser(info.getUsername());
        }
        return uri;
    }

    protected String normalizeUri(String uri) throws URISyntaxException {
        if (!uri.startsWith(GIT_SCM_ID)) {
            return uri;
        }
        if ((uri = uri.substring(GIT_SCM_ID.length())).startsWith("file:") && !uri.startsWith("file:///")) {
            throw new URISyntaxException(uri, "Invalid git URI");
        }
        URIish gitUri = new URIish(uri);
        if (gitUri.getScheme() == null) {
            if (gitUri.getHost() == null || "file".equals(gitUri.getHost())) {
                gitUri = gitUri.setHost(null);
                gitUri = gitUri.setScheme("file");
            } else {
                gitUri = gitUri.setScheme("ssh");
            }
        }
        return gitUri.toString();
    }

    protected boolean isProtocolAuthAware(String protocol) {
        return !"file".equalsIgnoreCase(protocol);
    }

    protected String getRefName(MavenProjectScmInfo info) {
        String branch = info.getBranch();
        if (branch == null || branch.trim().length() == 0) {
            branch = "HEAD";
        } else if (!branch.startsWith("refs/")) {
            branch = "refs/heads/" + branch;
        }
        return branch;
    }

    protected void fixAutoCRLF(File gitDirectory) throws IOException {
        FileRepository localRepository = new FileRepository(gitDirectory);
        try {
            FileBasedConfig localConfig = localRepository.getConfig();
            localConfig.unset("core", null, "autocrlf");
            localConfig.save();
        }
        finally {
            localRepository.close();
        }
    }
}

