/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.hibernate.spi.IService;
import org.jboss.tools.hibernate.spi.internal.HibernateServicePlugin;

public class ServiceLookup {
    private static final String SERVICES_EXTENSION_ID = "org.jboss.tools.hibernate.spi.services";
    private static Map<String, IService> services = null;
    private static String[] versions = null;

    public static IService findService(String hibernateVersion) {
        if (services == null) {
            ServiceLookup.initializeServices();
        }
        return services.get(hibernateVersion);
    }

    public static String[] getVersions() {
        if (services == null) {
            ServiceLookup.initializeServices();
        }
        return versions;
    }

    private static void initializeServices() {
        services = new HashMap<String, IService>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(SERVICES_EXTENSION_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Object object = configurationElement.createExecutableExtension("class");
                    String name = configurationElement.getAttribute("name");
                    if (object != null && name != null && object instanceof IService) {
                        services.put(name, (IService)object);
                    }
                }
                catch (CoreException e) {
                    HibernateServicePlugin.getDefault().log(e);
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<String> list = new ArrayList<String>(services.keySet());
        Collections.sort(list);
        versions = list.toArray(new String[list.size()]);
    }
}

