/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core.xml;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.cdi.seam.config.core.xml.Location;
import org.jboss.tools.cdi.seam.config.core.xml.SAXAttribute;
import org.jboss.tools.cdi.seam.config.core.xml.SAXElement;
import org.jboss.tools.cdi.seam.config.core.xml.SAXText;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.core.Messages;
import org.jboss.tools.common.xml.SAXValidator;
import org.jboss.tools.common.xml.XMLEntityResolverImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParser
extends SAXValidator {
    int supperssedFatalErrorLimit = 0;
    private String errorMessage = null;
    List<String> errors = new ArrayList<String>();

    public void setSupperssedFatalErrorLimit(int c) {
        this.supperssedFatalErrorLimit = c;
    }

    XMLReader createParser1(DefaultHandler handler) {
        org.apache.xerces.parsers.SAXParser parserInstance = null;
        parserInstance = new org.apache.xerces.parsers.SAXParser();
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://xml.org/sax/features/namespaces", (boolean)true);
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://xml.org/sax/features/namespace-prefixes", (boolean)false);
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://xml.org/sax/features/validation", (boolean)true);
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://apache.org/xml/features/validation/schema", (boolean)true);
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://apache.org/xml/features/validation/schema-full-checking", (boolean)false);
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://apache.org/xml/features/validation/dynamic", (boolean)false);
        SAXParser.setFeature((XMLReader)parserInstance, (String)"http://apache.org/xml/features/continue-after-fatal-error", (this.supperssedFatalErrorLimit > 0 ? 1 : 0) != 0);
        try {
            parserInstance.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new XMLEntityResolverImpl());
        }
        catch (SAXNotRecognizedException e1) {
            CommonPlugin.getPluginLog().logError(String.valueOf(e1.getMessage()), (Throwable)e1);
        }
        catch (SAXNotSupportedException e1) {
            CommonPlugin.getPluginLog().logError(String.valueOf(e1.getMessage()), (Throwable)e1);
        }
        parserInstance.setContentHandler(handler);
        parserInstance.setErrorHandler(handler);
        return parserInstance;
    }

    public SAXElement parse(InputStream input, IDocument document) {
        InputSource s = new InputSource(input);
        ConfigHanlder handler = new ConfigHanlder(document);
        XMLReader reader = this.createParser1(handler);
        try {
            if (reader != null) {
                reader.parse(s);
                this.errorMessage = null;
            } else if (this.errorMessage == null) {
                this.errorMessage = MessageFormat.format(Messages.SAXValidator_UnableToInstantiateMessage, "org.apache.xerces.parsers.SAXParser");
                CommonPlugin.getDefault().logError(this.errorMessage);
            }
        }
        catch (IOException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
        catch (SAXException sAXException) {}
        this.errors = handler.errors;
        return handler.getRootElement();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    class ConfigHanlder
    extends DefaultHandler {
        SAXElement root = null;
        IDocument document;
        Locator locator;
        List<String> errors = new ArrayList<String>();
        SAXElement current = null;
        StringBuffer currentText = new StringBuffer();
        Location currentTextLocation = null;

        ConfigHanlder(IDocument document) {
            this.document = document;
        }

        public SAXElement getRootElement() {
            return this.root;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private int getCurrentLocation() {
            if (this.locator != null) {
                int line = this.locator.getLineNumber() - 1;
                int lineOffset = this.locator.getColumnNumber() - 1;
                try {
                    return this.document.getLineOffset(line) + lineOffset;
                }
                catch (BadLocationException e) {
                    CommonPlugin.getDefault().logError((Throwable)e);
                }
            }
            return 0;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            int end = this.getCurrentLocation();
            int start = 0;
            if (end > 0) {
                start = this.document.get().lastIndexOf("<", end - 1);
            }
            SAXElement element = new SAXElement();
            element.setLocalName(localName);
            element.setURI(uri);
            element.setName(qName);
            element.setParent(this.current);
            if (start >= 0) {
                element.setLocation(new Location(start, end - start, this.getLine(start)));
                int ns = this.document.get().indexOf(qName, start);
                if (ns >= start) {
                    element.setNameLocation(new Location(ns, qName.length(), this.getLine(ns)));
                }
            }
            int i = 0;
            while (i < attributes.getLength()) {
                String n = attributes.getLocalName(i);
                String v = attributes.getValue(i);
                SAXAttribute a = new SAXAttribute();
                a.setName(n);
                a.setValue(v);
                int n_start = this.document.get().indexOf(n, start);
                if (n_start >= 0) {
                    a.setNameLocation(new Location(n_start, n.length(), this.getLine(n_start)));
                    int v_start = this.document.get().indexOf(34, n_start);
                    if (v_start >= 0) {
                        a.setValueLocation(new Location(v_start + 1, v.length(), this.getLine(v_start)));
                    }
                }
                element.addAttribute(a);
                ++i;
            }
            this.current = element;
            this.currentText = new StringBuffer();
            this.currentTextLocation = null;
            if (this.root == null) {
                this.root = element;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String append = new String(ch, start, length);
            if (append.trim().length() == 0) {
                return;
            }
            int end = this.getCurrentLocation();
            int s = 0;
            if (end > 0) {
                s = end - length;
            }
            this.currentText.append(append);
            this.currentTextLocation = new Location(s, length, this.getLine(s));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            int end = this.getCurrentLocation();
            if (end > 0) {
                int start = this.document.get().lastIndexOf("<", end);
                new Location(start, end - start, this.getLine(start));
            }
            if (this.currentText.length() > 0) {
                SAXText text = new SAXText();
                text.setValue(this.currentText.toString());
                this.current.setTextNode(text);
                text.setLocation(this.currentTextLocation);
                this.currentText.setLength(0);
            }
            if (this.current.getParent() != null) {
                this.current.getParent().addChildElement(this.current);
            }
            this.current = this.current.getParent();
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            String message = e.getMessage();
            this.errors.add(message);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            String message = e.getMessage();
            this.errors.add(message);
            if (this.errors.size() > SAXParser.this.supperssedFatalErrorLimit) {
                throw e;
            }
        }

        private int getLine(int start) {
            try {
                return this.document.getLineOfOffset(start) + 1;
            }
            catch (BadLocationException e) {
                CommonPlugin.getPluginLog().logError((Throwable)e);
                return -1;
            }
        }
    }
}

