/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core.definition;

import org.eclipse.core.resources.IResource;
import org.jboss.tools.cdi.seam.config.core.xml.SAXNode;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ITextSourceReference;

public class TextSourceReference
implements ITextSourceReference {
    XModelObject fileObject;
    IResource resource;
    SAXNode node;

    public TextSourceReference(XModelObject fileObject, IResource resource, SAXNode node) {
        this.fileObject = fileObject;
        this.resource = resource;
        this.node = node;
    }

    public int getStartPosition() {
        return this.node.getLocation().getStartPosition();
    }

    public int getLength() {
        return this.node.getLocation().getLength();
    }

    public IResource getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(FileAnyImpl.toFileName((XProperty)this.fileObject));
        sb.append(", line=").append(this.node.getLocation().getLine());
        sb.append(" - ");
        if (this.resource != null) {
            sb.append(this.resource.getFullPath().toString());
        } else if (this.fileObject != null) {
            String path = this.fileObject.getPath();
            XModelObject s = this.fileObject;
            while (s != null && s.getFileType() != 3) {
                s = s.getParent();
            }
            sb.append("/").append(EclipseResourceUtil.getProject((XModelObject)this.fileObject).getName());
            sb.append("/").append(s.getAttributeValue("name")).append(path.substring(s.getPath().length()));
        }
        return sb.toString();
    }
}

